/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.inventory;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.filter.ItemFilter;
import alexiil.mc.lib.attributes.item.impl.DelegatingFixedItemInv;
import appeng.api.storage.cells.ICellInventory;
import appeng.api.storage.cells.ICellInventoryHandler;
import appeng.core.Api;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.inv.IAEAppEngInventory;
import net.minecraft.class_1799;

public class AppEngCellInventory
extends DelegatingFixedItemInv {
    private static final ItemFilter CELL_FILTER = stack -> !stack.method_7960() && Api.instance().registries().cell().isCellHandled(stack);
    private final ICellInventoryHandler<?>[] handlerForSlot;

    public AppEngCellInventory(IAEAppEngInventory host, int slots) {
        super((FixedItemInv)new AppEngInternalInventory(host, slots, 1));
        this.handlerForSlot = new ICellInventoryHandler[slots];
    }

    public ItemFilter getFilterForSlot(int slot) {
        return CELL_FILTER;
    }

    public void setHandler(int slot, ICellInventoryHandler<?> handler) {
        this.handlerForSlot[slot] = handler;
    }

    public boolean setInvStack(int slot, class_1799 to, Simulation simulation) {
        this.persist(slot);
        boolean result = super.setInvStack(slot, to, simulation);
        this.cleanup(slot);
        return result;
    }

    public class_1799 getInvStack(int slot) {
        this.persist(slot);
        return super.getInvStack(slot);
    }

    private void persist(int slot) {
        ICellInventory<?> ci;
        if (this.handlerForSlot[slot] != null && (ci = this.handlerForSlot[slot].getCellInv()) != null) {
            ci.persist();
        }
    }

    private void cleanup(int slot) {
        ICellInventory<?> ci;
        if (this.handlerForSlot[slot] != null && ((ci = this.handlerForSlot[slot].getCellInv()) == null || ci.getItemStack() != super.getInvStack(slot))) {
            this.handlerForSlot[slot] = null;
        }
    }
}

