/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.inventory;

import alexiil.mc.lib.attributes.ListenerRemovalToken;
import alexiil.mc.lib.attributes.ListenerToken;
import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.InvMarkDirtyListener;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import appeng.util.item.AEItemStack;
import appeng.util.iterators.InvIterator;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class AppEngInternalAEInventory
implements FixedItemInv,
Iterable<class_1799> {
    private final IAEAppEngInventory te;
    private final IAEItemStack[] inv;
    private final int size;
    private int maxStack;
    private boolean dirtyFlag = false;

    public AppEngInternalAEInventory(IAEAppEngInventory te, int s) {
        this.te = te;
        this.size = s;
        this.maxStack = 64;
        this.inv = new IAEItemStack[s];
    }

    public void setMaxStackSize(int s) {
        this.maxStack = s;
    }

    public IAEItemStack getAEStackInSlot(int var1) {
        return this.inv[var1];
    }

    public void writeToNBT(class_2487 data, String name) {
        class_2487 c = new class_2487();
        this.writeToNBT(c);
        data.method_10566(name, (class_2520)c);
    }

    private void writeToNBT(class_2487 target) {
        for (int x = 0; x < this.size; ++x) {
            try {
                class_2487 c = new class_2487();
                if (this.inv[x] != null) {
                    this.inv[x].writeToNBT(c);
                }
                target.method_10566("#" + x, (class_2520)c);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void readFromNBT(class_2487 data, String name) {
        class_2487 c = data.method_10562(name);
        if (c != null) {
            this.readFromNBT(c);
        }
    }

    private void readFromNBT(class_2487 target) {
        for (int x = 0; x < this.size; ++x) {
            try {
                class_2487 c = target.method_10562("#" + x);
                if (c == null) continue;
                this.inv[x] = AEItemStack.fromNBT(c);
                continue;
            }
            catch (Exception e) {
                AELog.debug(e);
            }
        }
    }

    protected int getStackLimit(int slot, @Nonnull class_1799 stack) {
        return Math.min(this.getMaxAmount(slot, stack), stack.method_7914());
    }

    public class_1799 getInvStack(int slot) {
        if (this.inv[slot] == null) {
            return class_1799.field_8037;
        }
        return this.inv[slot].createItemStack();
    }

    public boolean setInvStack(int slot, class_1799 to, Simulation simulation) {
        if (!to.method_7960() && to.method_7947() > this.getMaxAmount(slot, to)) {
            return false;
        }
        if (simulation == Simulation.SIMULATE) {
            return true;
        }
        class_1799 oldStack = this.getInvStack(slot).method_7972();
        this.inv[slot] = (IAEItemStack)Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(to);
        class_1799 newStack = to.method_7972();
        InvOperation op = InvOperation.SET;
        if (class_1799.method_7987((class_1799)oldStack, (class_1799)newStack)) {
            if (newStack.method_7947() > oldStack.method_7947()) {
                newStack.method_7934(oldStack.method_7947());
                oldStack = class_1799.field_8037;
                op = InvOperation.INSERT;
            } else {
                oldStack.method_7934(newStack.method_7947());
                newStack = class_1799.field_8037;
                op = InvOperation.EXTRACT;
            }
        }
        this.fireOnChangeInventory(slot, op, oldStack, newStack);
        return true;
    }

    public int getSlotCount() {
        return this.size;
    }

    public boolean isItemValidForSlot(int slot, class_1799 stack) {
        return true;
    }

    public int getChangeValue() {
        return 0;
    }

    @Nullable
    public ListenerToken addListener(InvMarkDirtyListener listener, ListenerRemovalToken removalToken) {
        return null;
    }

    private void fireOnChangeInventory(int slot, InvOperation op, class_1799 removed, class_1799 inserted) {
        if (this.te != null && Platform.isServer() && !this.dirtyFlag) {
            this.dirtyFlag = true;
            this.te.onChangeInventory(this, slot, op, removed, inserted);
            this.te.saveChanges();
            this.dirtyFlag = false;
        }
    }

    public int getMaxAmount(int slot, class_1799 is) {
        return Math.min(this.maxStack, 64);
    }

    @Override
    public Iterator<class_1799> iterator() {
        return new InvIterator(this);
    }
}

