/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.inventory;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.LimitedFixedItemInv;
import alexiil.mc.lib.attributes.item.filter.ConstantItemFilter;
import alexiil.mc.lib.attributes.item.filter.ItemFilter;
import alexiil.mc.lib.attributes.item.impl.DirectFixedItemInv;
import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import appeng.util.inv.filter.IAEItemFilter;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class AppEngInternalInventory
extends DirectFixedItemInv
implements Iterable<class_1799> {
    private boolean enableClientEvents = false;
    private IAEAppEngInventory te;
    private final int[] maxStack;
    private IAEItemFilter filter;
    private boolean dirtyFlag = false;

    public AppEngInternalInventory(IAEAppEngInventory inventory, int size, int maxStack, IAEItemFilter filter) {
        super(size);
        this.setTileEntity(inventory);
        this.setFilter(filter);
        this.maxStack = new int[size];
        Arrays.fill(this.maxStack, maxStack);
    }

    public AppEngInternalInventory(IAEAppEngInventory inventory, int size, int maxStack) {
        this(inventory, size, maxStack, null);
    }

    public AppEngInternalInventory(IAEAppEngInventory inventory, int size) {
        this(inventory, size, 64);
    }

    public void setFilter(IAEItemFilter filter) {
        this.filter = filter;
    }

    public FixedItemInv createFiltered(IAEItemFilter filter) {
        LimitedFixedItemInv limitedFixedInv = this.createLimitedFixedInv();
        for (int i = 0; i < this.getSlotCount(); ++i) {
            int slot = i;
            limitedFixedInv.getRule(i).filterExtracts(stack -> filter.allowExtract((FixedItemInv)this, slot, stack.method_7947()));
            limitedFixedInv.getRule(i).filterInserts(stack -> {
                if (stack.method_7960()) {
                    class_1799 current = this.getInvStack(slot);
                    if (current.method_7960()) {
                        return true;
                    }
                    return filter.allowExtract((FixedItemInv)this, slot, current.method_7947());
                }
                return filter.allowInsert((FixedItemInv)this, slot, stack);
            });
        }
        return limitedFixedInv;
    }

    public int getMaxAmount(int slot, class_1799 stack) {
        return Math.min(this.maxStack[slot], super.getMaxAmount(slot, stack));
    }

    public boolean setInvStack(int slot, class_1799 to, Simulation simulation) {
        if (!to.method_7960() && to.method_7947() > this.getMaxAmount(slot, to)) {
            return false;
        }
        if (!simulation.isAction()) {
            return super.setInvStack(slot, to, simulation);
        }
        class_1799 previous = this.getInvStack(slot).method_7972();
        if (super.setInvStack(slot, to, simulation)) {
            this.onContentsChanged(slot, previous, to);
            return true;
        }
        return false;
    }

    protected void onContentsChanged(int slot, class_1799 previous, class_1799 current) {
        if (this.getBlockEntity() != null && this.eventsEnabled() && !this.dirtyFlag) {
            this.dirtyFlag = true;
            class_1799 newStack = current.method_7972();
            class_1799 oldStack = previous;
            InvOperation op = InvOperation.SET;
            if (newStack.method_7960() || oldStack.method_7960() || class_1799.method_7987((class_1799)newStack, (class_1799)oldStack)) {
                if (newStack.method_7947() > oldStack.method_7947()) {
                    newStack.method_7934(oldStack.method_7947());
                    oldStack = class_1799.field_8037;
                    op = InvOperation.INSERT;
                } else {
                    oldStack.method_7934(newStack.method_7947());
                    newStack = class_1799.field_8037;
                    op = InvOperation.EXTRACT;
                }
            }
            this.getBlockEntity().onChangeInventory((FixedItemInv)this, slot, op, oldStack, newStack);
            this.getBlockEntity().saveChanges();
            this.dirtyFlag = false;
        }
    }

    protected boolean eventsEnabled() {
        return Platform.isServer() || this.isEnableClientEvents();
    }

    public void setMaxStackSize(int slot, int size) {
        this.maxStack[slot] = size;
    }

    public ItemFilter getFilterForSlot(int slot) {
        if (this.maxStack[slot] == 0) {
            return ConstantItemFilter.NOTHING;
        }
        if (this.filter != null) {
            return stack -> {
                if (stack.method_7960()) {
                    class_1799 current = this.getInvStack(slot);
                    if (current.method_7960()) {
                        return true;
                    }
                    return this.filter.allowExtract((FixedItemInv)this, slot, current.method_7947());
                }
                return this.filter.allowInsert((FixedItemInv)this, slot, stack);
            };
        }
        return ConstantItemFilter.ANYTHING;
    }

    public boolean isItemValidForSlot(int slot, class_1799 stack) {
        if (this.maxStack[slot] == 0) {
            return false;
        }
        if (this.filter != null) {
            if (stack.method_7960()) {
                class_1799 current = this.getInvStack(slot);
                if (current.method_7960()) {
                    return true;
                }
                return this.filter.allowExtract((FixedItemInv)this, slot, current.method_7947());
            }
            return this.filter.allowInsert((FixedItemInv)this, slot, stack);
        }
        return true;
    }

    public void writeToNBT(class_2487 data, String name) {
        data.method_10566(name, (class_2520)this.toTag());
    }

    public void readFromNBT(class_2487 data, String name) {
        class_2487 c = data.method_10562(name);
        if (c != null) {
            this.readFromNBT(c);
        }
    }

    public void readFromNBT(class_2487 data) {
        this.fromTag(data);
    }

    @Override
    public Iterator<class_1799> iterator() {
        return this.stackIterable().iterator();
    }

    private boolean isEnableClientEvents() {
        return this.enableClientEvents;
    }

    public void setEnableClientEvents(boolean enableClientEvents) {
        this.enableClientEvents = enableClientEvents;
    }

    private IAEAppEngInventory getBlockEntity() {
        return this.te;
    }

    public void setTileEntity(IAEAppEngInventory te) {
        this.te = te;
    }
}

