/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import appeng.api.config.CopyMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.api.util.IConfigManager;
import appeng.tile.AEBaseBlockEntity;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class CellWorkbenchBlockEntity
extends AEBaseBlockEntity
implements IUpgradeableHost,
IAEAppEngInventory,
IConfigManagerHost {
    private final AppEngInternalInventory cell = new AppEngInternalInventory(this, 1);
    private final AppEngInternalAEInventory config = new AppEngInternalAEInventory(this, 63);
    private final ConfigManager manager = new ConfigManager(this);
    private FixedItemInv cacheUpgrades = null;
    private FixedItemInv cacheConfig = null;
    private boolean locked = false;

    public CellWorkbenchBlockEntity(class_2591<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.manager.registerSetting(Settings.COPY_MODE, (Enum)CopyMode.CLEAR_ON_REMOVE);
        this.cell.setEnableClientEvents(true);
    }

    public FixedItemInv getCellUpgradeInventory() {
        if (this.cacheUpgrades == null) {
            ICellWorkbenchItem cell = this.getCell();
            if (cell == null) {
                return null;
            }
            class_1799 is = this.cell.getInvStack(0);
            if (is.method_7960()) {
                return null;
            }
            FixedItemInv inv = cell.getUpgradesInventory(is);
            if (inv == null) {
                return null;
            }
            this.cacheUpgrades = inv;
            return this.cacheUpgrades;
        }
        return this.cacheUpgrades;
    }

    public ICellWorkbenchItem getCell() {
        if (this.cell.getInvStack(0).method_7960()) {
            return null;
        }
        if (this.cell.getInvStack(0).method_7909() instanceof ICellWorkbenchItem) {
            return (ICellWorkbenchItem)this.cell.getInvStack(0).method_7909();
        }
        return null;
    }

    @Override
    public class_2487 method_11007(class_2487 data) {
        super.method_11007(data);
        this.cell.writeToNBT(data, "cell");
        this.config.writeToNBT(data, "config");
        this.manager.writeToNBT(data);
        return data;
    }

    @Override
    public void method_11014(class_2680 state, class_2487 data) {
        super.method_11014(state, data);
        this.cell.readFromNBT(data, "cell");
        this.config.readFromNBT(data, "config");
        this.manager.readFromNBT(data);
    }

    @Override
    public FixedItemInv getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.config;
        }
        if (name.equals("cell")) {
            return this.cell;
        }
        return null;
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        return 0;
    }

    @Override
    public void onChangeInventory(FixedItemInv inv, int slot, InvOperation mc, class_1799 removedStack, class_1799 newStack) {
        if (inv == this.cell && !this.locked) {
            this.locked = true;
            this.cacheUpgrades = null;
            this.cacheConfig = null;
            FixedItemInv configInventory = this.getCellConfigInventory();
            if (configInventory != null) {
                int x;
                boolean cellHasConfig = false;
                for (x = 0; x < configInventory.getSlotCount(); ++x) {
                    if (configInventory.getInvStack(x).method_7960()) continue;
                    cellHasConfig = true;
                    break;
                }
                if (cellHasConfig) {
                    for (x = 0; x < this.config.getSlotCount(); ++x) {
                        this.config.forceSetInvStack(x, configInventory.getInvStack(x));
                    }
                } else {
                    ItemHandlerUtil.copy(this.config, configInventory, false);
                }
            } else if (this.manager.getSetting(Settings.COPY_MODE) == CopyMode.CLEAR_ON_REMOVE) {
                for (int x = 0; x < this.config.getSlotCount(); ++x) {
                    this.config.forceSetInvStack(x, class_1799.field_8037);
                }
                this.saveChanges();
            }
            this.locked = false;
        } else if (inv == this.config && !this.locked) {
            this.locked = true;
            FixedItemInv c = this.getCellConfigInventory();
            if (c != null) {
                ItemHandlerUtil.copy(this.config, c, false);
                ItemHandlerUtil.copy(c, (FixedItemInv)this.config, false);
            }
            this.locked = false;
        }
    }

    private FixedItemInv getCellConfigInventory() {
        if (this.cacheConfig == null) {
            ICellWorkbenchItem cell = this.getCell();
            if (cell == null) {
                return null;
            }
            class_1799 is = this.cell.getInvStack(0);
            if (is.method_7960()) {
                return null;
            }
            FixedItemInv inv = cell.getConfigInventory(is);
            if (inv == null) {
                return null;
            }
            this.cacheConfig = inv;
        }
        return this.cacheConfig;
    }

    @Override
    public void getDrops(class_1937 w, class_2338 pos, List<class_1799> drops) {
        super.getDrops(w, pos, drops);
        if (this.cell.getInvStack(0) != null) {
            drops.add(this.cell.getInvStack(0));
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.manager;
    }

    @Override
    public void updateSetting(IConfigManager manager, Settings settingName, Enum<?> newValue) {
    }
}

