/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.item.FixedItemInv;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IMaterials;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.implementations.tiles.ICrankable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.core.Api;
import appeng.core.settings.TickRates;
import appeng.me.GridAccessException;
import appeng.tile.grid.AENetworkPowerBlockEntity;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import appeng.util.inv.InvOperation;
import appeng.util.inv.filter.IAEItemFilter;
import appeng.util.item.AEItemStack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import org.jetbrains.annotations.NotNull;

public class ChargerBlockEntity
extends AENetworkPowerBlockEntity
implements ICrankable,
IGridTickable {
    private static final int POWER_MAXIMUM_AMOUNT = 1600;
    private static final int POWER_THRESHOLD = 1599;
    private static final int POWER_PER_CRANK_TURN = 160;
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 1, 1);
    private final FixedItemInv externalInv = this.inv.createFiltered(new ChargerInvFilter());

    public ChargerBlockEntity(class_2591<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.getProxy().setValidSides(EnumSet.noneOf(class_2350.class));
        this.getProxy().setFlags(new GridFlags[0]);
        this.setInternalMaxPower(1600.0);
        this.getProxy().setIdlePowerUsage(0.0);
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.COVERED;
    }

    @Override
    protected boolean readFromStream(class_2540 data) throws IOException {
        boolean c = super.readFromStream(data);
        try {
            AEItemStack item = AEItemStack.fromPacket(data);
            class_1799 is = item.createItemStack();
            this.inv.setInvStack(0, is, Simulation.ACTION);
        }
        catch (Throwable t) {
            this.inv.setInvStack(0, class_1799.field_8037, Simulation.ACTION);
        }
        return c;
    }

    @Override
    protected void writeToStream(class_2540 data) throws IOException {
        super.writeToStream(data);
        AEItemStack is = AEItemStack.fromItemStack(this.inv.getInvStack(0));
        if (is != null) {
            is.writeToPacket(data);
        }
    }

    @Override
    public void setOrientation(class_2350 inForward, class_2350 inUp) {
        super.setOrientation(inForward, inUp);
        this.getProxy().setValidSides(EnumSet.of(this.getUp(), this.getUp().method_10153()));
        this.setPowerSides(EnumSet.of(this.getUp(), this.getUp().method_10153()));
    }

    @Override
    public boolean canTurn() {
        return this.getInternalCurrentPower() < this.getInternalMaxPower();
    }

    @Override
    public void applyTurn() {
        IMaterials materials;
        this.injectExternalPower(PowerUnits.AE, 160.0, Actionable.MODULATE);
        class_1799 myItem = this.inv.getInvStack(0);
        if (this.getInternalCurrentPower() > 1599.0 && (materials = Api.instance().definitions().materials()).certusQuartzCrystal().isSameAs(myItem)) {
            this.extractAEPower(this.getInternalMaxPower(), Actionable.MODULATE, PowerMultiplier.CONFIG);
            materials.certusQuartzCrystalCharged().maybeStack(myItem.method_7947()).ifPresent(charged -> this.inv.setInvStack(0, (class_1799)charged, Simulation.ACTION));
        }
    }

    @Override
    public boolean canCrankAttach(class_2350 directionToCrank) {
        return this.getUp() == directionToCrank || this.getUp().method_10153() == directionToCrank;
    }

    @Override
    public FixedItemInv getInternalInventory() {
        return this.inv;
    }

    @Override
    @NotNull
    public FixedItemInv getExternalInventory() {
        return this.externalInv;
    }

    @Override
    public void onChangeInventory(FixedItemInv inv, int slot, InvOperation mc, class_1799 removed, class_1799 added) {
        try {
            this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        this.markForUpdate();
    }

    public void activate(class_1657 player) {
        if (!Platform.hasPermissions(new DimensionalCoord(this), player)) {
            return;
        }
        class_1799 myItem = this.inv.getInvStack(0);
        if (myItem.method_7960()) {
            class_1799 held = player.field_7514.method_7391();
            if (Api.instance().definitions().materials().certusQuartzCrystal().isSameAs(held) || Platform.isChargeable(held)) {
                held = player.field_7514.method_5434(player.field_7514.field_7545, 1);
                this.inv.setInvStack(0, held, Simulation.ACTION);
            }
        } else {
            ArrayList<class_1799> drops = new ArrayList<class_1799>();
            drops.add(myItem);
            this.inv.setInvStack(0, class_1799.field_8037, Simulation.ACTION);
            Platform.spawnDrops(this.field_11863, this.field_11867.method_10093(this.getForward()), drops);
        }
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.Charger.getMin(), TickRates.Charger.getMin(), false, true);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        return this.doWork() ? TickRateModulation.FASTER : TickRateModulation.SLEEP;
    }

    private boolean doWork() {
        class_1799 myItem = this.inv.getInvStack(0);
        boolean changed = false;
        if (!myItem.method_7960()) {
            IMaterials materials = Api.instance().definitions().materials();
            if (Platform.isChargeable(myItem)) {
                IAEItemPowerStorage ps = (IAEItemPowerStorage)myItem.method_7909();
                if (ps.getAEMaxPower(myItem) > ps.getAECurrentPower(myItem)) {
                    double chargeRate = Api.instance().registries().charger().getChargeRate(myItem.method_7909());
                    double extractedAmount = this.extractAEPower(chargeRate, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    double missingChargeRate = chargeRate - extractedAmount;
                    double missingAEPower = ps.getAEMaxPower(myItem) - ps.getAECurrentPower(myItem);
                    double toExtract = Math.min(missingChargeRate, missingAEPower);
                    try {
                        extractedAmount += this.getProxy().getEnergy().extractAEPower(toExtract, Actionable.MODULATE, PowerMultiplier.ONE);
                    }
                    catch (GridAccessException gridAccessException) {
                        // empty catch block
                    }
                    if (extractedAmount > 0.0) {
                        double adjustment = ps.injectAEPower(myItem, extractedAmount, Actionable.MODULATE);
                        this.setInternalCurrentPower(this.getInternalCurrentPower() + adjustment);
                        changed = true;
                    }
                }
            } else if (this.getInternalCurrentPower() > 1599.0 && materials.certusQuartzCrystal().isSameAs(myItem) && Platform.getRandomFloat() > 0.8f) {
                this.extractAEPower(this.getInternalMaxPower(), Actionable.MODULATE, PowerMultiplier.CONFIG);
                materials.certusQuartzCrystalCharged().maybeStack(myItem.method_7947()).ifPresent(charged -> this.inv.setInvStack(0, (class_1799)charged, Simulation.ACTION));
                changed = true;
            }
        }
        if (this.getInternalCurrentPower() < 1599.0) {
            try {
                double toExtract = Math.min(800.0, this.getInternalMaxPower() - this.getInternalCurrentPower());
                double extracted = this.getProxy().getEnergy().extractAEPower(toExtract, Actionable.MODULATE, PowerMultiplier.ONE);
                this.injectExternalPower(PowerUnits.AE, extracted, Actionable.MODULATE);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            changed = true;
        }
        if (changed) {
            this.markForUpdate();
        }
        return true;
    }

    private static class ChargerInvFilter
    implements IAEItemFilter {
        private ChargerInvFilter() {
        }

        @Override
        public boolean allowInsert(FixedItemInv inv, int i, class_1799 itemstack) {
            IItemDefinition cert = Api.instance().definitions().materials().certusQuartzCrystal();
            return Platform.isChargeable(itemstack) || cert.isSameAs(itemstack);
        }

        @Override
        public boolean allowExtract(FixedItemInv inv, int slotIndex, int amount) {
            IAEItemPowerStorage ips;
            class_1799 extractedItem = inv.getInvStack(slotIndex);
            if (Platform.isChargeable(extractedItem) && (ips = (IAEItemPowerStorage)extractedItem.method_7909()).getAECurrentPower(extractedItem) >= ips.getAEMaxPower(extractedItem)) {
                return true;
            }
            return Api.instance().definitions().materials().certusQuartzCrystalCharged().isSameAs(extractedItem);
        }
    }
}

