/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import alexiil.mc.lib.attributes.AttributeList;
import alexiil.mc.lib.attributes.ListenerRemovalToken;
import alexiil.mc.lib.attributes.ListenerToken;
import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FluidInsertable;
import alexiil.mc.lib.attributes.fluid.FluidVolumeUtil;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.InvMarkDirtyListener;
import alexiil.mc.lib.attributes.item.LimitedFixedItemInv;
import appeng.api.config.CondenserOutput;
import appeng.api.config.Settings;
import appeng.api.definitions.IMaterials;
import appeng.api.implementations.items.IStorageComponent;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.core.Api;
import appeng.tile.AEBaseInvBlockEntity;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.misc.CondenserItemInventory;
import appeng.tile.misc.CondenserVoidInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.inv.InvOperation;
import appeng.util.inv.WrapperChainedItemHandler;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class CondenserBlockEntity
extends AEBaseInvBlockEntity
implements IConfigManagerHost,
IConfigurableObject {
    public static final int BYTE_MULTIPLIER = 8;
    private final ConfigManager cm = new ConfigManager(this);
    private final AppEngInternalInventory outputSlot = new AppEngInternalInventory(this, 1);
    private final AppEngInternalInventory storageSlot = new AppEngInternalInventory(this, 1);
    private final CondenseItemHandler internalInputSlot = new CondenseItemHandler();
    private final FluidInsertable externalFluidInput = new FluidHandler();
    private final MEHandler meHandler = new MEHandler();
    private final FixedItemInv combinedInv = new WrapperChainedItemHandler(new FixedItemInv[]{this.internalInputSlot, this.outputSlot, this.storageSlot});
    private final FixedItemInv externalCombinedInv;
    private double storedPower = 0.0;

    public CondenserBlockEntity(class_2591<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.cm.registerSetting(Settings.CONDENSER_OUTPUT, (Enum)CondenserOutput.TRASH);
        LimitedFixedItemInv limitedOutput = this.outputSlot.createLimitedFixedInv();
        limitedOutput.getAllRule().disallowInsertion();
        this.externalCombinedInv = new WrapperChainedItemHandler(new FixedItemInv[]{this.internalInputSlot, limitedOutput});
    }

    @Override
    public class_2487 method_11007(class_2487 data) {
        super.method_11007(data);
        this.cm.writeToNBT(data);
        data.method_10549("storedPower", this.getStoredPower());
        return data;
    }

    @Override
    public void method_11014(class_2680 state, class_2487 data) {
        super.method_11014(state, data);
        this.cm.readFromNBT(data);
        this.setStoredPower(data.method_10574("storedPower"));
    }

    public double getStorage() {
        IStorageComponent sc;
        class_1799 is = this.storageSlot.getInvStack(0);
        if (!is.method_7960() && is.method_7909() instanceof IStorageComponent && (sc = (IStorageComponent)is.method_7909()).isStorageComponent(is)) {
            return sc.getBytes(is) * 8;
        }
        return 0.0;
    }

    public void addPower(double rawPower) {
        this.setStoredPower(this.getStoredPower() + rawPower);
        this.setStoredPower(Math.max(0.0, Math.min(this.getStorage(), this.getStoredPower())));
        double requiredPower = this.getRequiredPower();
        class_1799 output = this.getOutput();
        while (requiredPower <= this.getStoredPower() && !output.method_7960() && requiredPower > 0.0 && this.canAddOutput(output)) {
            this.setStoredPower(this.getStoredPower() - requiredPower);
            this.addOutput(output);
        }
    }

    private boolean canAddOutput(class_1799 output) {
        return this.outputSlot.getInsertable().wouldAccept(output);
    }

    private void addOutput(class_1799 output) {
        this.outputSlot.getInsertable().insert(output);
    }

    FixedItemInv getOutputSlot() {
        return this.outputSlot;
    }

    private class_1799 getOutput() {
        IMaterials materials = Api.instance().definitions().materials();
        switch ((CondenserOutput)this.cm.getSetting(Settings.CONDENSER_OUTPUT)) {
            case MATTER_BALLS: {
                return materials.matterBall().maybeStack(1).orElse(class_1799.field_8037);
            }
            case SINGULARITY: {
                return materials.singularity().maybeStack(1).orElse(class_1799.field_8037);
            }
        }
        return class_1799.field_8037;
    }

    public double getRequiredPower() {
        return ((CondenserOutput)this.cm.getSetting((Settings)Settings.CONDENSER_OUTPUT)).requiredPower;
    }

    @Override
    public FixedItemInv getInternalInventory() {
        return this.combinedInv;
    }

    @Override
    public void onChangeInventory(FixedItemInv inv, int slot, InvOperation mc, class_1799 removed, class_1799 added) {
        if (inv == this.outputSlot) {
            this.meHandler.outputChanged(added, removed);
        }
    }

    @Override
    public void updateSetting(IConfigManager manager, Settings settingName, Enum<?> newValue) {
        this.addPower(0.0);
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.cm;
    }

    public double getStoredPower() {
        return this.storedPower;
    }

    private void setStoredPower(double storedPower) {
        this.storedPower = storedPower;
    }

    @Override
    public void addAllAttributes(class_1937 world, class_2338 pos, class_2680 state, AttributeList<?> to) {
        to.offer((Object)this.externalCombinedInv);
        to.offer((Object)this.externalFluidInput);
        to.offer((Object)this.meHandler);
    }

    private class MEHandler
    implements IStorageMonitorableAccessor,
    IStorageMonitorable {
        private final CondenserItemInventory itemInventory;

        private MEHandler() {
            this.itemInventory = new CondenserItemInventory(CondenserBlockEntity.this);
        }

        void outputChanged(class_1799 added, class_1799 removed) {
            this.itemInventory.updateOutput(added, removed);
        }

        @Override
        @Nullable
        public IStorageMonitorable getInventory(IActionSource src) {
            return this;
        }

        @Override
        public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
            if (channel == Api.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
                return this.itemInventory;
            }
            return new CondenserVoidInventory<T>(CondenserBlockEntity.this, channel);
        }
    }

    private class FluidHandler
    implements FluidInsertable {
        private FluidHandler() {
        }

        public FluidVolume attemptInsertion(FluidVolume fluid, Simulation simulation) {
            if (simulation == Simulation.ACTION) {
                IFluidStorageChannel chan = Api.instance().storage().getStorageChannel(IFluidStorageChannel.class);
                CondenserBlockEntity.this.addPower((fluid.isEmpty() ? 0.0 : fluid.getAmount_F().asInexactDouble() * 1000.0) / (double)chan.transferFactor());
            }
            return FluidVolumeUtil.EMPTY;
        }

        @Nullable
        public FluidAmount getMinimumAcceptedAmount() {
            return FluidAmount.of((long)1L, (long)1000L);
        }
    }

    private class CondenseItemHandler
    implements FixedItemInv {
        private CondenseItemHandler() {
        }

        public int getSlotCount() {
            return 1;
        }

        public class_1799 getInvStack(int i) {
            return class_1799.field_8037;
        }

        public boolean isItemValidForSlot(int i, class_1799 itemStack) {
            return true;
        }

        public boolean setInvStack(int i, class_1799 itemStack, Simulation simulation) {
            if (simulation == Simulation.ACTION && !itemStack.method_7960()) {
                CondenserBlockEntity.this.addPower(itemStack.method_7947());
            }
            return true;
        }

        public int getChangeValue() {
            return 0;
        }

        @Nullable
        public ListenerToken addListener(InvMarkDirtyListener invMarkDirtyListener, ListenerRemovalToken listenerRemovalToken) {
            return null;
        }
    }
}

