/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.tile.misc.CondenserBlockEntity;

class CondenserVoidInventory<T extends IAEStack<T>>
implements IMEMonitor<T> {
    private final CondenserBlockEntity target;
    private final IStorageChannel<T> channel;

    CondenserVoidInventory(CondenserBlockEntity te, IStorageChannel<T> channel) {
        this.target = te;
        this.channel = channel;
    }

    @Override
    public T injectItems(T input, Actionable mode, IActionSource src) {
        if (mode == Actionable.SIMULATE) {
            return null;
        }
        if (input != null) {
            this.target.addPower((double)input.getStackSize() / (double)this.channel.transferFactor());
        }
        return null;
    }

    @Override
    public T extractItems(T request, Actionable mode, IActionSource src) {
        return null;
    }

    @Override
    public IItemList<T> getAvailableItems(IItemList<T> out) {
        return out;
    }

    @Override
    public IItemList<T> getStorageList() {
        return this.channel.createList();
    }

    @Override
    public IStorageChannel<T> getChannel() {
        return this.channel;
    }

    @Override
    public AccessRestriction getAccess() {
        return AccessRestriction.WRITE;
    }

    @Override
    public boolean isPrioritized(T input) {
        return false;
    }

    @Override
    public boolean canAccept(T input) {
        return true;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public int getSlot() {
        return 0;
    }

    @Override
    public boolean validForPass(int i) {
        return i == 2;
    }

    @Override
    public void addListener(IMEMonitorHandlerReceiver<T> l, Object verificationToken) {
    }

    @Override
    public void removeListener(IMEMonitorHandlerReceiver<T> l) {
    }
}

