/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.LimitedFixedItemInv;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.definitions.ITileDefinition;
import appeng.api.features.InscriberProcessType;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IConfigManager;
import appeng.core.Api;
import appeng.core.settings.TickRates;
import appeng.me.GridAccessException;
import appeng.parts.automation.DefinitionUpgradeInventory;
import appeng.parts.automation.UpgradeInventory;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.tile.grid.AENetworkPowerBlockEntity;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.misc.InscriberRecipes;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.inv.InvOperation;
import appeng.util.inv.WrapperChainedItemHandler;
import appeng.util.item.AEItemStack;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;

public class InscriberBlockEntity
extends AENetworkPowerBlockEntity
implements IGridTickable,
IUpgradeableHost,
IConfigManagerHost {
    private final int maxProcessingTime = 100;
    private final IConfigManager settings;
    private final UpgradeInventory upgrades;
    private int processingTime = 0;
    private boolean smash;
    private int finalStep;
    private long clientStart;
    private final AppEngInternalInventory topItemHandler = new AppEngInternalInventory(this, 1, 1);
    private final AppEngInternalInventory bottomItemHandler = new AppEngInternalInventory(this, 1, 1);
    private final AppEngInternalInventory sideItemHandler = new AppEngInternalInventory(this, 2, 1);
    private final LimitedFixedItemInv topItemHandlerExtern;
    private final LimitedFixedItemInv bottomItemHandlerExtern;
    private final LimitedFixedItemInv sideItemHandlerExtern;
    private InscriberRecipe cachedTask = null;
    private final FixedItemInv inv = new WrapperChainedItemHandler(new FixedItemInv[]{this.topItemHandler, this.bottomItemHandler, this.sideItemHandler});
    private final FixedItemInv externalInv;

    public InscriberBlockEntity(class_2591<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.getProxy().setValidSides(EnumSet.noneOf(class_2350.class));
        this.setInternalMaxPower(1600.0);
        this.getProxy().setIdlePowerUsage(0.0);
        this.settings = new ConfigManager(this);
        ITileDefinition inscriberDefinition = Api.instance().definitions().blocks().inscriber();
        this.upgrades = new DefinitionUpgradeInventory(inscriberDefinition, this, this.getUpgradeSlots());
        this.sideItemHandler.setMaxStackSize(1, 64);
        this.topItemHandlerExtern = this.topItemHandler.createLimitedFixedInv();
        this.topItemHandlerExtern.getAllRule().filterInserts(this::canInsertIntoTopOrBottom).filterExtracts(stack -> !this.isSmash());
        this.bottomItemHandlerExtern = this.bottomItemHandler.createLimitedFixedInv();
        this.bottomItemHandlerExtern.getAllRule().filterInserts(this::canInsertIntoTopOrBottom).filterExtracts(stack -> !this.isSmash());
        this.sideItemHandlerExtern = this.sideItemHandler.createLimitedFixedInv();
        this.sideItemHandlerExtern.getRule(0).disallowExtraction().filterInserts(stack -> !this.isSmash());
        this.sideItemHandlerExtern.getRule(1).filterExtracts(stack -> !this.isSmash()).disallowInsertion();
        this.externalInv = new WrapperChainedItemHandler(new FixedItemInv[]{this.topItemHandlerExtern, this.bottomItemHandlerExtern, this.sideItemHandlerExtern});
    }

    private boolean canInsertIntoTopOrBottom(class_1799 stack) {
        if (this.isSmash()) {
            return false;
        }
        if (Api.instance().definitions().materials().namePress().isSameAs(stack)) {
            return true;
        }
        return InscriberRecipes.isValidOptionalIngredient(this.method_10997(), stack);
    }

    private int getUpgradeSlots() {
        return 3;
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.COVERED;
    }

    @Override
    public class_2487 method_11007(class_2487 data) {
        super.method_11007(data);
        this.upgrades.writeToNBT(data, "upgrades");
        this.settings.writeToNBT(data);
        return data;
    }

    @Override
    public void method_11014(class_2680 state, class_2487 data) {
        super.method_11014(state, data);
        this.upgrades.readFromNBT(data, "upgrades");
        this.settings.readFromNBT(data);
    }

    @Override
    protected boolean readFromStream(class_2540 data) throws IOException {
        boolean newSmash;
        boolean c = super.readFromStream(data);
        byte slot = data.readByte();
        boolean oldSmash = this.isSmash();
        boolean bl = newSmash = (slot & 0x40) == 64;
        if (oldSmash != newSmash && newSmash) {
            this.setSmash(true);
            this.setClientStart(System.currentTimeMillis());
        }
        for (int num = 0; num < this.inv.getSlotCount(); ++num) {
            if ((slot & 1 << num) > 0) {
                this.inv.forceSetInvStack(num, AEItemStack.fromPacket(data).createItemStack());
                continue;
            }
            this.inv.forceSetInvStack(num, class_1799.field_8037);
        }
        this.cachedTask = null;
        return c;
    }

    @Override
    protected void writeToStream(class_2540 data) throws IOException {
        int num;
        super.writeToStream(data);
        int slot = this.isSmash() ? 64 : 0;
        for (num = 0; num < this.inv.getSlotCount(); ++num) {
            if (this.inv.getInvStack(num).method_7960()) continue;
            slot |= 1 << num;
        }
        data.writeByte(slot);
        for (num = 0; num < this.inv.getSlotCount(); ++num) {
            if ((slot & 1 << num) <= 0) continue;
            AEItemStack st = AEItemStack.fromItemStack(this.inv.getInvStack(num));
            st.writeToPacket(data);
        }
    }

    @Override
    public void setOrientation(class_2350 inForward, class_2350 inUp) {
        super.setOrientation(inForward, inUp);
        this.getProxy().setValidSides(EnumSet.complementOf(EnumSet.of(this.getForward())));
        this.setPowerSides(EnumSet.complementOf(EnumSet.of(this.getForward())));
    }

    @Override
    public void getDrops(class_1937 w, class_2338 pos, List<class_1799> drops) {
        super.getDrops(w, pos, drops);
        for (int h = 0; h < this.upgrades.getSlotCount(); ++h) {
            class_1799 is = this.upgrades.getInvStack(h);
            if (is.method_7960()) continue;
            drops.add(is);
        }
    }

    @Override
    public FixedItemInv getInternalInventory() {
        return this.inv;
    }

    @Override
    @NotNull
    public FixedItemInv getExternalInventory() {
        return this.externalInv;
    }

    @Override
    public void onChangeInventory(FixedItemInv inv, int slot, InvOperation mc, class_1799 removed, class_1799 added) {
        try {
            if (slot == 0) {
                this.setProcessingTime(0);
            }
            if (!this.isSmash()) {
                this.markForUpdate();
            }
            this.cachedTask = null;
            this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.Inscriber.getMin(), TickRates.Inscriber.getMax(), !this.hasWork(), false);
    }

    private boolean hasWork() {
        if (this.getTask() != null) {
            return true;
        }
        this.setProcessingTime(0);
        return this.isSmash();
    }

    @Nullable
    public InscriberRecipe getTask() {
        if (this.cachedTask == null && this.field_11863 != null) {
            class_1799 input = this.sideItemHandler.getInvStack(0);
            class_1799 plateA = this.topItemHandler.getInvStack(0);
            class_1799 plateB = this.bottomItemHandler.getInvStack(0);
            if (input.method_7960()) {
                return null;
            }
            if (input.method_7947() > 1 || plateA.method_7947() > 1 || plateB.method_7947() > 1) {
                return null;
            }
            this.cachedTask = InscriberRecipes.findRecipe(this.field_11863, input, plateA, plateB, true);
        }
        return this.cachedTask;
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.isSmash()) {
            ++this.finalStep;
            if (this.finalStep == 8) {
                InscriberRecipe out = this.getTask();
                if (out != null) {
                    class_1799 outputCopy = out.method_8110().method_7972();
                    if (this.sideItemHandler.getSlot(1).insert(outputCopy).method_7960()) {
                        this.setProcessingTime(0);
                        if (out.getProcessType() == InscriberProcessType.PRESS) {
                            this.topItemHandler.setInvStack(0, class_1799.field_8037, Simulation.ACTION);
                            this.bottomItemHandler.setInvStack(0, class_1799.field_8037, Simulation.ACTION);
                        }
                        this.sideItemHandler.setInvStack(0, class_1799.field_8037, Simulation.ACTION);
                    }
                }
                this.saveChanges();
            } else if (this.finalStep == 16) {
                this.finalStep = 0;
                this.setSmash(false);
                this.markForUpdate();
            }
        } else {
            try {
                IEnergyGrid eg = this.getProxy().getEnergy();
                IEnergySource src = this;
                int speedFactor = 1 + this.upgrades.getInstalledUpgrades(Upgrades.SPEED);
                int powerConsumption = 10 * speedFactor;
                double powerThreshold = (double)powerConsumption - 0.01;
                double powerReq = this.extractAEPower(powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                if (powerReq <= powerThreshold) {
                    src = eg;
                    powerReq = eg.extractAEPower(powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                }
                if (powerReq > powerThreshold) {
                    src.extractAEPower(powerConsumption, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    if (this.getProcessingTime() == 0) {
                        this.setProcessingTime(this.getProcessingTime() + speedFactor);
                    } else {
                        this.setProcessingTime(this.getProcessingTime() + ticksSinceLastCall * speedFactor);
                    }
                }
            }
            catch (GridAccessException eg) {
                // empty catch block
            }
            if (this.getProcessingTime() > this.getMaxProcessingTime()) {
                this.setProcessingTime(this.getMaxProcessingTime());
                InscriberRecipe out = this.getTask();
                if (out != null) {
                    class_1799 outputCopy = out.method_8110().method_7972();
                    if (this.sideItemHandler.getSlot(1).wouldAccept(outputCopy)) {
                        this.setSmash(true);
                        this.finalStep = 0;
                        this.markForUpdate();
                    }
                }
            }
        }
        return this.hasWork() ? TickRateModulation.URGENT : TickRateModulation.SLEEP;
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.settings;
    }

    @Override
    public FixedItemInv getInventoryByName(String name) {
        if (name.equals("inv")) {
            return this.getInternalInventory();
        }
        if (name.equals("upgrades")) {
            return this.upgrades;
        }
        return null;
    }

    @Override
    protected FixedItemInv getItemHandlerForSide(@Nonnull class_2350 facing) {
        if (facing == this.getUp()) {
            return this.topItemHandlerExtern;
        }
        if (facing == this.getUp().method_10153()) {
            return this.bottomItemHandlerExtern;
        }
        return this.sideItemHandlerExtern;
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        return this.upgrades.getInstalledUpgrades(u);
    }

    @Override
    public void updateSetting(IConfigManager manager, Settings settingName, Enum<?> newValue) {
    }

    public long getClientStart() {
        return this.clientStart;
    }

    private void setClientStart(long clientStart) {
        this.clientStart = clientStart;
    }

    public boolean isSmash() {
        return this.smash;
    }

    public void setSmash(boolean smash) {
        this.smash = smash;
    }

    public int getMaxProcessingTime() {
        return this.maxProcessingTime;
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    private void setProcessingTime(int processingTime) {
        this.processingTime = processingTime;
    }
}

