/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import alexiil.mc.lib.attributes.AttributeList;
import alexiil.mc.lib.attributes.item.FixedItemInv;
import appeng.api.config.Actionable;
import appeng.api.config.Upgrades;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.container.implementations.InterfaceContainer;
import appeng.core.Api;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.IPriorityHost;
import appeng.tile.grid.AENetworkInvBlockEntity;
import appeng.util.Platform;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.InvOperation;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3917;

public class InterfaceBlockEntity
extends AENetworkInvBlockEntity
implements IGridTickable,
IInventoryDestination,
IInterfaceHost,
IPriorityHost {
    private final DualityInterface duality = new DualityInterface(this.getProxy(), this);
    private boolean omniDirectional = true;

    public InterfaceBlockEntity(class_2591<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkChannelsChanged c) {
        this.duality.notifyNeighbors();
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkPowerStatusChange c) {
        this.duality.notifyNeighbors();
    }

    public void setSide(class_2350 facing) {
        if (this.isClient()) {
            return;
        }
        class_2350 newForward = facing;
        if (!this.omniDirectional && this.getForward() == facing.method_10153()) {
            newForward = facing;
        } else if (!(this.omniDirectional || this.getForward() != facing && this.getForward() != facing.method_10153())) {
            this.omniDirectional = true;
        } else if (this.omniDirectional) {
            newForward = facing.method_10153();
            this.omniDirectional = false;
        } else {
            newForward = Platform.rotateAround(this.getForward(), facing);
        }
        if (this.omniDirectional) {
            this.setOrientation(class_2350.field_11043, class_2350.field_11036);
        } else {
            class_2350 newUp = class_2350.field_11036;
            if (newForward == class_2350.field_11036 || newForward == class_2350.field_11033) {
                newUp = class_2350.field_11043;
            }
            this.setOrientation(newForward, newUp);
        }
        this.configureNodeSides();
        this.markForUpdate();
        this.saveChanges();
    }

    private void configureNodeSides() {
        if (this.omniDirectional) {
            this.getProxy().setValidSides(EnumSet.allOf(class_2350.class));
        } else {
            this.getProxy().setValidSides(EnumSet.complementOf(EnumSet.of(this.getForward())));
        }
    }

    @Override
    public void getDrops(class_1937 w, class_2338 pos, List<class_1799> drops) {
        this.duality.addDrops(drops);
    }

    @Override
    public void gridChanged() {
        this.duality.gridChanged();
    }

    @Override
    public void onReady() {
        this.configureNodeSides();
        super.onReady();
        this.duality.initialize();
    }

    @Override
    public class_2487 method_11007(class_2487 data) {
        super.method_11007(data);
        data.method_10556("omniDirectional", this.omniDirectional);
        this.duality.writeToNBT(data);
        return data;
    }

    @Override
    public void method_11014(class_2680 state, class_2487 data) {
        super.method_11014(state, data);
        this.omniDirectional = data.method_10577("omniDirectional");
        this.duality.readFromNBT(data);
    }

    @Override
    protected boolean readFromStream(class_2540 data) throws IOException {
        boolean c = super.readFromStream(data);
        boolean oldOmniDirectional = this.omniDirectional;
        this.omniDirectional = data.readBoolean();
        return oldOmniDirectional != this.omniDirectional || c;
    }

    @Override
    protected void writeToStream(class_2540 data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.omniDirectional);
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return this.duality.getCableConnectionType(dir);
    }

    @Override
    public DimensionalCoord getLocation() {
        return this.duality.getLocation();
    }

    @Override
    public boolean canInsert(class_1799 stack) {
        return this.duality.canInsert(stack);
    }

    @Override
    public FixedItemInv getInventoryByName(String name) {
        return this.duality.getInventoryByName(name);
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return this.duality.getTickingRequest(node);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        return this.duality.tickingRequest(node, ticksSinceLastCall);
    }

    @Override
    public FixedItemInv getInternalInventory() {
        return this.duality.getInternalInventory();
    }

    @Override
    public void onChangeInventory(FixedItemInv inv, int slot, InvOperation mc, class_1799 removed, class_1799 added) {
        this.duality.onChangeInventory(inv, slot, mc, removed, added);
    }

    @Override
    public DualityInterface getInterfaceDuality() {
        return this.duality;
    }

    @Override
    public EnumSet<class_2350> getTargets() {
        if (this.omniDirectional) {
            return EnumSet.allOf(class_2350.class);
        }
        return EnumSet.of(this.getForward());
    }

    @Override
    public class_2586 getBlockEntity() {
        return this;
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.duality.getConfigManager();
    }

    @Override
    public boolean pushPattern(ICraftingPatternDetails patternDetails, class_1715 table) {
        return this.duality.pushPattern(patternDetails, table);
    }

    @Override
    public boolean isBusy() {
        return this.duality.isBusy();
    }

    @Override
    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        this.duality.provideCrafting(craftingTracker);
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        return this.duality.getInstalledUpgrades(u);
    }

    @Override
    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return this.duality.getRequestedJobs();
    }

    @Override
    public IAEItemStack injectCraftedItems(ICraftingLink link, IAEItemStack items, Actionable mode) {
        return this.duality.injectCraftedItems(link, items, mode);
    }

    @Override
    public void jobStateChange(ICraftingLink link) {
        this.duality.jobStateChange(link);
    }

    @Override
    public int getPriority() {
        return this.duality.getPriority();
    }

    @Override
    public void setPriority(int newValue) {
        this.duality.setPriority(newValue);
    }

    public boolean isOmniDirectional() {
        return this.omniDirectional;
    }

    @Override
    public void addAllAttributes(class_1937 world, class_2338 pos, class_2680 state, AttributeList<?> to) {
        this.duality.addAllAttributes(to);
    }

    @Override
    public class_1799 getItemStackRepresentation() {
        return Api.instance().definitions().blocks().iface().maybeStack(1).orElse(class_1799.field_8037);
    }

    @Override
    public class_3917<?> getContainerType() {
        return InterfaceContainer.TYPE;
    }
}

