/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.tiles.ICrystalGrowthAccelerator;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.me.GridAccessException;
import appeng.tile.grid.AENetworkBlockEntity;
import appeng.util.Platform;
import java.io.IOException;
import java.util.EnumSet;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2591;

public class QuartzGrowthAcceleratorBlockEntity
extends AENetworkBlockEntity
implements IPowerChannelState,
ICrystalGrowthAccelerator {
    private boolean hasPower = false;

    public QuartzGrowthAcceleratorBlockEntity(class_2591<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.getProxy().setValidSides(EnumSet.noneOf(class_2350.class));
        this.getProxy().setFlags(new GridFlags[0]);
        this.getProxy().setIdlePowerUsage(8.0);
    }

    @MENetworkEventSubscribe
    public void onPower(MENetworkPowerStatusChange ch) {
        this.markForUpdate();
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.COVERED;
    }

    @Override
    public boolean readFromStream(class_2540 data) throws IOException {
        boolean c = super.readFromStream(data);
        boolean hadPower = this.isPowered();
        this.setPowered(data.readBoolean());
        return this.isPowered() != hadPower || c;
    }

    @Override
    public void writeToStream(class_2540 data) throws IOException {
        super.writeToStream(data);
        try {
            data.writeBoolean(this.getProxy().getEnergy().isNetworkPowered());
        }
        catch (GridAccessException e) {
            data.writeBoolean(false);
        }
    }

    @Override
    public void setOrientation(class_2350 inForward, class_2350 inUp) {
        super.setOrientation(inForward, inUp);
        this.getProxy().setValidSides(EnumSet.of(this.getUp(), this.getUp().method_10153()));
    }

    @Override
    public boolean isPowered() {
        if (Platform.isServer()) {
            try {
                return this.getProxy().getEnergy().isNetworkPowered();
            }
            catch (GridAccessException e) {
                return false;
            }
        }
        return this.hasPower;
    }

    @Override
    public boolean isActive() {
        return this.isPowered();
    }

    private void setPowered(boolean hasPower) {
        this.hasPower = hasPower;
    }
}

