/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.events.LocatableEventAnnounce;
import appeng.api.features.ILocatable;
import appeng.api.features.IPlayerRegistry;
import appeng.api.implementations.items.IBiometricCard;
import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.events.MENetworkSecurityChange;
import appeng.api.networking.security.ISecurityProvider;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.core.Api;
import appeng.helpers.PlayerSecurityWrapper;
import appeng.me.GridAccessException;
import appeng.me.helpers.MEMonitorHandler;
import appeng.me.storage.SecurityStationInventory;
import appeng.tile.grid.AENetworkBlockEntity;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import appeng.util.item.AEItemStack;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class SecurityStationBlockEntity
extends AENetworkBlockEntity
implements ITerminalHost,
IAEAppEngInventory,
ILocatable,
IConfigManagerHost,
ISecurityProvider,
IColorableTile {
    private static int difference = 0;
    private final AppEngInternalInventory configSlot = new AppEngInternalInventory(this, 1);
    private final IConfigManager cm = new ConfigManager(this);
    private final SecurityStationInventory inventory = new SecurityStationInventory(this);
    private final MEMonitorHandler<IAEItemStack> securityMonitor = new MEMonitorHandler<IAEItemStack>(this.inventory);
    private long securityKey;
    private AEColor paintedColor = AEColor.TRANSPARENT;
    private boolean isActive = false;

    public SecurityStationBlockEntity(class_2591<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.getProxy().setFlags(GridFlags.REQUIRE_CHANNEL);
        this.getProxy().setIdlePowerUsage(2.0);
        this.securityKey = System.currentTimeMillis() * 10L + (long)(++difference);
        if (difference > 10) {
            difference = 0;
        }
        this.cm.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        this.cm.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        this.cm.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
    }

    @Override
    public void onChangeInventory(FixedItemInv inv, int slot, InvOperation mc, class_1799 removedStack, class_1799 newStack) {
    }

    @Override
    public void getDrops(class_1937 w, class_2338 pos, List<class_1799> drops) {
        if (!ItemHandlerUtil.isEmpty((FixedItemInv)this.getConfigSlot())) {
            drops.add(this.getConfigSlot().getInvStack(0));
        }
        for (IAEItemStack ais : this.inventory.getStoredItems()) {
            drops.add(ais.createItemStack());
        }
    }

    IMEInventoryHandler<IAEItemStack> getSecurityInventory() {
        return this.inventory;
    }

    @Override
    protected boolean readFromStream(class_2540 data) throws IOException {
        boolean c = super.readFromStream(data);
        boolean wasActive = this.isActive;
        this.isActive = data.readBoolean();
        AEColor oldPaintedColor = this.paintedColor;
        this.paintedColor = AEColor.values()[data.readByte()];
        return oldPaintedColor != this.paintedColor || wasActive != this.isActive || c;
    }

    @Override
    protected void writeToStream(class_2540 data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.getProxy().isActive());
        data.writeByte(this.paintedColor.ordinal());
    }

    @Override
    public class_2487 method_11007(class_2487 data) {
        super.method_11007(data);
        this.cm.writeToNBT(data);
        data.method_10567("paintedColor", (byte)this.paintedColor.ordinal());
        data.method_10544("securityKey", this.securityKey);
        this.getConfigSlot().writeToNBT(data, "config");
        class_2487 storedItems = new class_2487();
        int offset = 0;
        for (IAEItemStack ais : this.inventory.getStoredItems()) {
            class_2487 it = new class_2487();
            ais.createItemStack().method_7953(it);
            storedItems.method_10566(String.valueOf(offset), (class_2520)it);
            ++offset;
        }
        data.method_10566("storedItems", (class_2520)storedItems);
        return data;
    }

    @Override
    public void method_11014(class_2680 state, class_2487 data) {
        super.method_11014(state, data);
        this.cm.readFromNBT(data);
        if (data.method_10545("paintedColor")) {
            this.paintedColor = AEColor.values()[data.method_10571("paintedColor")];
        }
        this.securityKey = data.method_10537("securityKey");
        this.getConfigSlot().readFromNBT(data, "config");
        class_2487 storedItems = data.method_10562("storedItems");
        for (Object key : storedItems.method_10541()) {
            class_2520 obj = storedItems.method_10580((String)key);
            if (!(obj instanceof class_2487)) continue;
            this.inventory.getStoredItems().add(AEItemStack.fromItemStack(class_1799.method_7915((class_2487)((class_2487)obj))));
        }
    }

    public void inventoryChanged() {
        try {
            this.saveChanges();
            this.getProxy().getGrid().postEvent(new MENetworkSecurityChange());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @MENetworkEventSubscribe
    public void bootUpdate(MENetworkChannelsChanged changed) {
        this.markForUpdate();
    }

    @MENetworkEventSubscribe
    public void powerUpdate(MENetworkPowerStatusChange changed) {
        this.markForUpdate();
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Override
    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        ((LocatableEventAnnounce)LocatableEventAnnounce.EVENT.invoker()).onLocatableAnnounce(this, LocatableEventAnnounce.LocatableEvent.UNREGISTER);
        this.isActive = false;
    }

    @Override
    public void onReady() {
        super.onReady();
        if (Platform.isServer()) {
            this.isActive = true;
            ((LocatableEventAnnounce)LocatableEventAnnounce.EVENT.invoker()).onLocatableAnnounce(this, LocatableEventAnnounce.LocatableEvent.REGISTER);
        }
    }

    @Override
    public void method_11012() {
        super.method_11012();
        ((LocatableEventAnnounce)LocatableEventAnnounce.EVENT.invoker()).onLocatableAnnounce(this, LocatableEventAnnounce.LocatableEvent.UNREGISTER);
        this.isActive = false;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    public boolean isActive() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            return this.isPowered();
        }
        return this.isActive;
    }

    @Override
    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
        if (channel == Api.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
            return this.securityMonitor;
        }
        return null;
    }

    @Override
    public long getLocatableSerial() {
        return this.securityKey;
    }

    public boolean isPowered() {
        return this.getProxy().isActive();
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.cm;
    }

    @Override
    public void updateSetting(IConfigManager manager, Settings settingName, Enum<?> newValue) {
    }

    @Override
    public long getSecurityKey() {
        return this.securityKey;
    }

    @Override
    public void readPermissions(Map<Integer, EnumSet<SecurityPermissions>> playerPerms) {
        IPlayerRegistry pr = Api.instance().registries().players();
        for (IAEItemStack ais : this.inventory.getStoredItems()) {
            class_1799 is = ais.createItemStack();
            class_1792 i = is.method_7909();
            if (!(i instanceof IBiometricCard)) continue;
            IBiometricCard bc = (IBiometricCard)i;
            bc.registerPermissions(new PlayerSecurityWrapper(playerPerms), pr, is);
        }
        playerPerms.put(this.getProxy().getNode().getPlayerID(), EnumSet.allOf(SecurityPermissions.class));
    }

    @Override
    public boolean isSecurityEnabled() {
        return this.isActive && this.getProxy().isActive();
    }

    @Override
    public int getOwner() {
        return this.getProxy().getNode().getPlayerID();
    }

    @Override
    public AEColor getColor() {
        return this.paintedColor;
    }

    @Override
    public boolean recolourBlock(class_2350 side, AEColor newPaintedColor, class_1657 who) {
        if (this.paintedColor == newPaintedColor) {
            return false;
        }
        this.paintedColor = newPaintedColor;
        this.saveChanges();
        this.markForUpdate();
        return true;
    }

    public AppEngInternalInventory getConfigSlot() {
        return this.configSlot;
    }
}

