/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.LimitedFixedItemInv;
import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.core.settings.TickRates;
import appeng.me.GridAccessException;
import appeng.tile.grid.AENetworkInvBlockEntity;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import appeng.util.inv.InvOperation;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class VibrationChamberBlockEntity
extends AENetworkInvBlockEntity
implements IGridTickable {
    public static final double POWER_PER_TICK = 5.0;
    public static final int MIN_BURN_SPEED = 20;
    public static final int MAX_BURN_SPEED = 200;
    public static final double DILATION_SCALING = 25.0;
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 1);
    private final LimitedFixedItemInv invExt;
    private int burnSpeed = 100;
    private double burnTime = 0.0;
    private double maxBurnTime = 0.0;
    public boolean isOn;

    public VibrationChamberBlockEntity(class_2591<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.getProxy().setIdlePowerUsage(0.0);
        this.getProxy().setFlags(new GridFlags[0]);
        this.invExt = this.inv.createLimitedFixedInv();
        this.invExt.getAllRule().filterInserts(stack -> FuelRegistry.INSTANCE.get((class_1935)stack.method_7909()) != null).filterExtracts(stack -> FuelRegistry.INSTANCE.get((class_1935)stack.method_7909()) == null);
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.COVERED;
    }

    @Override
    protected boolean readFromStream(class_2540 data) throws IOException {
        boolean c = super.readFromStream(data);
        boolean wasOn = this.isOn;
        this.isOn = data.readBoolean();
        return wasOn != this.isOn || c;
    }

    @Override
    protected void writeToStream(class_2540 data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.getBurnTime() > 0.0);
    }

    @Override
    public class_2487 method_11007(class_2487 data) {
        super.method_11007(data);
        data.method_10549("burnTime", this.getBurnTime());
        data.method_10549("maxBurnTime", this.getMaxBurnTime());
        data.method_10569("burnSpeed", this.getBurnSpeed());
        return data;
    }

    @Override
    public void method_11014(class_2680 state, class_2487 data) {
        super.method_11014(state, data);
        this.setBurnTime(data.method_10574("burnTime"));
        this.setMaxBurnTime(data.method_10574("maxBurnTime"));
        this.setBurnSpeed(data.method_10550("burnSpeed"));
    }

    @Override
    protected FixedItemInv getItemHandlerForSide(@Nonnull class_2350 facing) {
        return this.invExt;
    }

    @Override
    public FixedItemInv getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onChangeInventory(FixedItemInv inv, int slot, InvOperation mc, class_1799 removed, class_1799 added) {
        if (this.getBurnTime() <= 0.0 && this.canEatFuel()) {
            try {
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    private boolean canEatFuel() {
        Integer newBurnTime;
        class_1799 is = this.inv.getInvStack(0);
        return !is.method_7960() && (newBurnTime = (Integer)FuelRegistry.INSTANCE.get((class_1935)is.method_7909())) != null && is.method_7947() > 0;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        if (this.getBurnTime() <= 0.0) {
            this.eatFuel();
        }
        return new TickingRequest(TickRates.VibrationChamber.getMin(), TickRates.VibrationChamber.getMax(), this.getBurnTime() <= 0.0, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.getBurnTime() <= 0.0) {
            this.eatFuel();
            if (this.getBurnTime() > 0.0) {
                return TickRateModulation.URGENT;
            }
            this.setBurnSpeed(100);
            return TickRateModulation.SLEEP;
        }
        this.setBurnSpeed(Math.max(20, Math.min(this.getBurnSpeed(), 200)));
        double dilation = (double)this.getBurnSpeed() / 25.0;
        double timePassed = (double)ticksSinceLastCall * dilation;
        this.setBurnTime(this.getBurnTime() - timePassed);
        if (this.getBurnTime() < 0.0) {
            timePassed += this.getBurnTime();
            this.setBurnTime(0.0);
        }
        try {
            IEnergyGrid grid = this.getProxy().getEnergy();
            double newPower = timePassed * 5.0;
            double overFlow = grid.injectPower(newPower, Actionable.SIMULATE);
            grid.injectPower(Math.max(0.0, newPower - overFlow), Actionable.MODULATE);
            if (overFlow > 0.0) {
                this.setBurnSpeed(this.getBurnSpeed() - ticksSinceLastCall);
            } else {
                this.setBurnSpeed(this.getBurnSpeed() + ticksSinceLastCall);
            }
            this.setBurnSpeed(Math.max(20, Math.min(this.getBurnSpeed(), 200)));
            return overFlow > 0.0 ? TickRateModulation.SLOWER : TickRateModulation.FASTER;
        }
        catch (GridAccessException e) {
            this.setBurnSpeed(this.getBurnSpeed() - ticksSinceLastCall);
            this.setBurnSpeed(Math.max(20, Math.min(this.getBurnSpeed(), 200)));
            return TickRateModulation.SLOWER;
        }
    }

    private void eatFuel() {
        Integer newBurnTime;
        class_1799 is = this.inv.getInvStack(0);
        if (!is.method_7960() && (newBurnTime = (Integer)FuelRegistry.INSTANCE.get((class_1935)is.method_7909())) != null && is.method_7947() > 0) {
            this.setBurnTime(this.getBurnTime() + (double)newBurnTime.intValue());
            this.setMaxBurnTime(this.getBurnTime());
            class_1792 fuelItem = is.method_7909();
            is.method_7934(1);
            if (is.method_7960()) {
                this.inv.setInvStack(0, new class_1799((class_1935)fuelItem.method_7858()), Simulation.ACTION);
            } else {
                this.inv.setInvStack(0, is, Simulation.ACTION);
            }
            this.saveChanges();
        }
        if (this.getBurnTime() > 0.0) {
            try {
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        if (!this.isOn && this.getBurnTime() > 0.0 || this.isOn && this.getBurnTime() <= 0.0) {
            this.isOn = this.getBurnTime() > 0.0;
            this.markForUpdate();
            if (this.method_11002()) {
                Platform.notifyBlocksOfNeighbors(this.field_11863, this.field_11867);
            }
        }
    }

    public int getBurnSpeed() {
        return this.burnSpeed;
    }

    private void setBurnSpeed(int burnSpeed) {
        this.burnSpeed = burnSpeed;
    }

    public double getMaxBurnTime() {
        return this.maxBurnTime;
    }

    private void setMaxBurnTime(double maxBurnTime) {
        this.maxBurnTime = maxBurnTime;
    }

    public double getBurnTime() {
        return this.burnTime;
    }

    private void setBurnTime(double burnTime) {
        this.burnTime = burnTime;
    }
}

