/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.networking;

import alexiil.mc.lib.attributes.AttributeList;
import appeng.api.networking.IGridNode;
import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IPart;
import appeng.api.parts.LayerFlags;
import appeng.api.parts.SelectedPart;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.client.render.cablebus.CableBusRenderState;
import appeng.helpers.AEMultiTile;
import appeng.hooks.TickHandler;
import appeng.parts.CableBusContainer;
import appeng.tile.AEBaseBlockEntity;
import appeng.util.Platform;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class CableBusBlockEntity
extends AEBaseBlockEntity
implements AEMultiTile {
    private CableBusContainer cb = new CableBusContainer(this);
    private int oldLV = -1;

    public CableBusBlockEntity(class_2591<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public void method_11014(class_2680 state, class_2487 data) {
        super.method_11014(state, data);
        this.getCableBus().readFromNBT(data);
    }

    @Override
    public class_2487 method_11007(class_2487 data) {
        super.method_11007(data);
        this.getCableBus().writeToNBT(data);
        return data;
    }

    @Override
    protected boolean readFromStream(class_2540 data) throws IOException {
        boolean c = super.readFromStream(data);
        boolean ret = this.getCableBus().readFromStream(data);
        int newLV = this.getCableBus().getLightValue();
        if (newLV != this.oldLV) {
            this.oldLV = newLV;
            this.field_11863.method_22336().method_15559(this.field_11867);
            ret = true;
        }
        this.updateTileSetting();
        return ret || c;
    }

    @Override
    protected void writeToStream(class_2540 data) throws IOException {
        super.writeToStream(data);
        this.getCableBus().writeToStream(data);
    }

    protected void updateTileSetting() {
    }

    public double method_11006() {
        return 900.0;
    }

    public void method_11012() {
        super.method_11012();
        this.getCableBus().removeFromWorld();
    }

    public void method_10996() {
        super.method_10996();
        TickHandler.instance().addInit(this);
    }

    @Override
    public IGridNode getGridNode(AEPartLocation dir) {
        return this.getCableBus().getGridNode(dir);
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation side) {
        return this.getCableBus().getCableConnectionType(side);
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return this.getCableBus().getCableConnectionLength(cable);
    }

    @Override
    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.getCableBus().removeFromWorld();
    }

    @Override
    public void markForUpdate() {
        if (this.field_11863 == null) {
            return;
        }
        int newLV = this.getCableBus().getLightValue();
        if (newLV != this.oldLV) {
            this.oldLV = newLV;
            this.field_11863.method_22336().method_15559(this.field_11867);
        }
        super.markForUpdate();
    }

    @Override
    public boolean canBeRotated() {
        return false;
    }

    public void getDrops(class_1937 w, class_2338 pos, List drops) {
        this.getCableBus().getDrops(drops);
    }

    @Override
    public void getNoDrops(class_1937 w, class_2338 pos, List<class_1799> drops) {
        this.getCableBus().getNoDrops(drops);
    }

    @Override
    public void onReady() {
        super.onReady();
        if (this.getCableBus().isEmpty()) {
            if (this.field_11863.method_8321(this.field_11867) == this) {
                this.field_11863.method_22352(this.field_11867, true);
            }
        } else {
            this.getCableBus().addToWorld();
        }
    }

    @Override
    public IFacadeContainer getFacadeContainer() {
        return this.getCableBus().getFacadeContainer();
    }

    @Override
    public boolean canAddPart(class_1799 is, AEPartLocation side) {
        return this.getCableBus().canAddPart(is, side);
    }

    @Override
    public AEPartLocation addPart(class_1799 is, AEPartLocation side, class_1657 player, class_1268 hand) {
        return this.getCableBus().addPart(is, side, player, hand);
    }

    @Override
    public IPart getPart(AEPartLocation side) {
        return this.cb.getPart(side);
    }

    @Override
    public IPart getPart(class_2350 side) {
        return this.getCableBus().getPart(side);
    }

    @Override
    public void removePart(AEPartLocation side, boolean suppressUpdate) {
        this.getCableBus().removePart(side, suppressUpdate);
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    public AEColor getColor() {
        return this.getCableBus().getColor();
    }

    @Override
    public void clearContainer() {
        this.setCableBus(new CableBusContainer(this));
    }

    @Override
    public boolean isBlocked(class_2350 side) {
        return false;
    }

    @Override
    public SelectedPart selectPart(class_243 pos) {
        return this.getCableBus().selectPart(pos);
    }

    @Override
    public void markForSave() {
        this.saveChanges();
    }

    @Override
    public void partChanged() {
        this.notifyNeighbors();
    }

    @Override
    public boolean hasRedstone(AEPartLocation side) {
        return this.getCableBus().hasRedstone(side);
    }

    @Override
    public boolean isEmpty() {
        return this.getCableBus().isEmpty();
    }

    @Override
    public Set<LayerFlags> getLayerFlags() {
        return this.getCableBus().getLayerFlags();
    }

    @Override
    public void cleanup() {
        this.method_10997().method_8650(this.field_11867, false);
    }

    @Override
    public void notifyNeighbors() {
        if (this.field_11863 != null && this.field_11863.method_22340(this.field_11867) && !CableBusContainer.isLoading()) {
            Platform.notifyBlocksOfNeighbors(this.field_11863, this.field_11867);
        }
    }

    @Override
    public boolean isInWorld() {
        return this.getCableBus().isInWorld();
    }

    @Override
    public boolean recolourBlock(class_2350 side, AEColor colour, class_1657 who) {
        return this.getCableBus().recolourBlock(side, colour, who);
    }

    public CableBusContainer getCableBus() {
        return this.cb;
    }

    private void setCableBus(CableBusContainer cb) {
        this.cb = cb;
    }

    @Override
    public void addAllAttributes(class_1937 world, class_2338 pos, class_2680 state, AttributeList<?> to) {
        super.addAllAttributes(world, pos, state, to);
        class_2350 direction = to.getSearchDirection();
        if (direction == null) {
            return;
        }
        AEPartLocation partLocation = AEPartLocation.fromFacing(direction.method_10153());
        IPart part = this.cb.getPart(partLocation);
        if (part != null) {
            part.addAllAttributes(to);
        }
    }

    @Override
    public CableBusRenderState getRenderAttachmentData() {
        class_1937 world = this.method_10997();
        if (world == null) {
            return null;
        }
        CableBusRenderState renderState = this.cb.getRenderState();
        renderState.setWorld((class_1920)world);
        renderState.setPos(this.field_11867);
        return renderState;
    }
}

