/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.networking;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.impl.EmptyFixedItemInv;
import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkControllerChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.events.MENetworkPowerStorage;
import appeng.api.networking.pathing.ControllerState;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.block.networking.ControllerBlock;
import appeng.me.GridAccessException;
import appeng.tile.grid.AENetworkPowerBlockEntity;
import appeng.util.inv.InvOperation;
import java.util.EnumSet;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class ControllerBlockEntity
extends AENetworkPowerBlockEntity {
    private boolean isValid = false;

    public ControllerBlockEntity(class_2591<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.setInternalMaxPower(8000.0);
        this.setInternalPublicPowerStorage(true);
        this.getProxy().setIdlePowerUsage(3.0);
        this.getProxy().setFlags(GridFlags.CANNOT_CARRY, GridFlags.DENSE_CAPACITY);
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.DENSE_SMART;
    }

    @Override
    public void onReady() {
        this.onNeighborChange(true);
        super.onReady();
    }

    public void onNeighborChange(boolean force) {
        boolean xx = this.checkController(this.field_11867.method_10093(class_2350.field_11034)) && this.checkController(this.field_11867.method_10093(class_2350.field_11039));
        boolean yy = this.checkController(this.field_11867.method_10093(class_2350.field_11036)) && this.checkController(this.field_11867.method_10093(class_2350.field_11033));
        boolean zz = this.checkController(this.field_11867.method_10093(class_2350.field_11043)) && this.checkController(this.field_11867.method_10093(class_2350.field_11035));
        boolean oldValid = this.isValid;
        boolean bl = xx && !yy && !zz || !xx && yy && !zz || !xx && !yy && zz || (xx ? 1 : 0) + (yy ? 1 : 0) + (zz ? 1 : 0) <= 1 ? true : (this.isValid = false);
        if (oldValid != this.isValid || force) {
            if (this.isValid) {
                this.getProxy().setValidSides(EnumSet.allOf(class_2350.class));
            } else {
                this.getProxy().setValidSides(EnumSet.noneOf(class_2350.class));
            }
            this.updateMeta();
        }
    }

    private void updateMeta() {
        if (!this.getProxy().isReady()) {
            return;
        }
        ControllerBlock.ControllerBlockState metaState = ControllerBlock.ControllerBlockState.offline;
        try {
            if (this.getProxy().getEnergy().isNetworkPowered()) {
                metaState = ControllerBlock.ControllerBlockState.online;
                if (this.getProxy().getPath().getControllerState() == ControllerState.CONTROLLER_CONFLICT) {
                    metaState = ControllerBlock.ControllerBlockState.conflicted;
                }
            }
        }
        catch (GridAccessException e) {
            metaState = ControllerBlock.ControllerBlockState.offline;
        }
        if (this.checkController(this.field_11867) && this.field_11863.method_8320(this.field_11867).method_11654(ControllerBlock.CONTROLLER_STATE) != metaState) {
            this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657(ControllerBlock.CONTROLLER_STATE, (Comparable)((Object)metaState)));
        }
    }

    @Override
    protected double getFunnelPowerDemand(double maxReceived) {
        try {
            IEnergyGrid grid = this.getProxy().getEnergy();
            return grid.getEnergyDemand(maxReceived);
        }
        catch (GridAccessException e) {
            return super.getFunnelPowerDemand(maxReceived);
        }
    }

    @Override
    protected double funnelPowerIntoStorage(double power, Actionable mode) {
        try {
            IEnergyGrid grid = this.getProxy().getEnergy();
            double leftOver = grid.injectPower(power, mode);
            return leftOver;
        }
        catch (GridAccessException e) {
            return super.funnelPowerIntoStorage(power, mode);
        }
    }

    @Override
    protected void PowerEvent(MENetworkPowerStorage.PowerEventType x) {
        try {
            this.getProxy().getGrid().postEvent(new MENetworkPowerStorage(this, x));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @MENetworkEventSubscribe
    public void onControllerChange(MENetworkControllerChange status) {
        this.updateMeta();
    }

    @MENetworkEventSubscribe
    public void onPowerChange(MENetworkPowerStatusChange status) {
        this.updateMeta();
    }

    @Override
    public FixedItemInv getInternalInventory() {
        return EmptyFixedItemInv.INSTANCE;
    }

    @Override
    public void onChangeInventory(FixedItemInv inv, int slot, InvOperation mc, class_1799 removed, class_1799 added) {
    }

    private boolean checkController(class_2338 pos) {
        if (this.field_11863.method_8398().method_20529(pos)) {
            return this.field_11863.method_8321(pos) instanceof ControllerBlockEntity;
        }
        return false;
    }
}

