/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.networking;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.impl.EmptyFixedItemInv;
import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.me.GridAccessException;
import appeng.tile.grid.AENetworkPowerBlockEntity;
import appeng.util.inv.InvOperation;
import net.minecraft.class_1799;
import net.minecraft.class_2591;

public class EnergyAcceptorBlockEntity
extends AENetworkPowerBlockEntity {
    public EnergyAcceptorBlockEntity(class_2591<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.getProxy().setIdlePowerUsage(0.0);
        this.setInternalMaxPower(0.0);
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.COVERED;
    }

    @Override
    protected double getFunnelPowerDemand(double maxRequired) {
        try {
            IEnergyGrid grid = this.getProxy().getEnergy();
            return grid.getEnergyDemand(maxRequired);
        }
        catch (GridAccessException e) {
            return this.getInternalMaxPower();
        }
    }

    @Override
    protected double funnelPowerIntoStorage(double power, Actionable mode) {
        try {
            IEnergyGrid grid = this.getProxy().getEnergy();
            double leftOver = grid.injectPower(power, mode);
            return leftOver;
        }
        catch (GridAccessException e) {
            return super.funnelPowerIntoStorage(power, mode);
        }
    }

    @Override
    public FixedItemInv getInternalInventory() {
        return EmptyFixedItemInv.INSTANCE;
    }

    @Override
    public void onChangeInventory(FixedItemInv inv, int slot, InvOperation mc, class_1799 removed, class_1799 added) {
    }
}

