/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.networking;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.events.MENetworkPowerStorage;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.block.networking.EnergyCellBlock;
import appeng.me.GridAccessException;
import appeng.tile.grid.AENetworkBlockEntity;
import appeng.util.SettingsFrom;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;

public class EnergyCellBlockEntity
extends AENetworkBlockEntity
implements IAEPowerStorage {
    private static final double MAX_STORED = 200000.0;
    private double internalCurrentPower = 0.0;
    private double internalMaxPower = 200000.0;
    private byte currentMeta = (byte)-1;

    public EnergyCellBlockEntity(class_2591<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.getProxy().setIdlePowerUsage(0.0);
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.COVERED;
    }

    @Override
    public void onReady() {
        super.onReady();
        int value = (Integer)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)EnergyCellBlock.ENERGY_STORAGE);
        this.currentMeta = (byte)value;
        this.changePowerLevel();
    }

    public static int getStorageLevelFromFillFactor(double fillFactor) {
        byte factor = (byte)(8.0 * fillFactor);
        return class_3532.method_15340((int)factor, (int)0, (int)4);
    }

    private void changePowerLevel() {
        if (this.notLoaded() || this.method_11015()) {
            return;
        }
        int storageLevel = EnergyCellBlockEntity.getStorageLevelFromFillFactor(this.internalCurrentPower / this.getInternalMaxPower());
        if (this.currentMeta != storageLevel) {
            this.currentMeta = (byte)storageLevel;
            this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)EnergyCellBlock.ENERGY_STORAGE, (Comparable)Integer.valueOf(storageLevel)));
        }
    }

    @Override
    public class_2487 method_11007(class_2487 data) {
        super.method_11007(data);
        data.method_10549("internalCurrentPower", this.internalCurrentPower);
        return data;
    }

    @Override
    public void method_11014(class_2680 state, class_2487 data) {
        super.method_11014(state, data);
        this.internalCurrentPower = data.method_10574("internalCurrentPower");
    }

    @Override
    public boolean canBeRotated() {
        return false;
    }

    @Override
    public void uploadSettings(SettingsFrom from, class_2487 compound) {
        if (from == SettingsFrom.DISMANTLE_ITEM) {
            this.internalCurrentPower = compound.method_10574("internalCurrentPower");
        }
    }

    @Override
    public class_2487 downloadSettings(SettingsFrom from) {
        if (from == SettingsFrom.DISMANTLE_ITEM) {
            class_2487 tag = new class_2487();
            tag.method_10549("internalCurrentPower", this.internalCurrentPower);
            tag.method_10549("internalMaxPower", this.getInternalMaxPower());
            return tag;
        }
        return null;
    }

    @Override
    public final double injectAEPower(double amt, Actionable mode) {
        if (mode == Actionable.SIMULATE) {
            double fakeBattery = this.internalCurrentPower + amt;
            if (fakeBattery > this.getInternalMaxPower()) {
                return fakeBattery - this.getInternalMaxPower();
            }
            return 0.0;
        }
        if (this.internalCurrentPower < 0.01 && amt > 0.01) {
            this.getProxy().getNode().getGrid().postEvent(new MENetworkPowerStorage(this, MENetworkPowerStorage.PowerEventType.PROVIDE_POWER));
        }
        this.internalCurrentPower += amt;
        if (this.internalCurrentPower > this.getInternalMaxPower()) {
            amt = this.internalCurrentPower - this.getInternalMaxPower();
            this.internalCurrentPower = this.getInternalMaxPower();
            this.changePowerLevel();
            return amt;
        }
        this.changePowerLevel();
        return 0.0;
    }

    @Override
    public double getAEMaxPower() {
        return this.getInternalMaxPower();
    }

    @Override
    public double getAECurrentPower() {
        return this.internalCurrentPower;
    }

    @Override
    public boolean isAEPublicPowerStorage() {
        return true;
    }

    @Override
    public AccessRestriction getPowerFlow() {
        return AccessRestriction.READ_WRITE;
    }

    @Override
    public final double extractAEPower(double amt, Actionable mode, PowerMultiplier pm) {
        return pm.divide(this.extractAEPower(pm.multiply(amt), mode));
    }

    @Override
    public int getPriority() {
        return 200;
    }

    private double extractAEPower(double amt, Actionable mode) {
        boolean wasFull;
        if (mode == Actionable.SIMULATE) {
            if (this.internalCurrentPower > amt) {
                return amt;
            }
            return this.internalCurrentPower;
        }
        boolean bl = wasFull = this.internalCurrentPower >= this.getInternalMaxPower() - 0.001;
        if (wasFull && amt > 0.001) {
            try {
                this.getProxy().getGrid().postEvent(new MENetworkPowerStorage(this, MENetworkPowerStorage.PowerEventType.REQUEST_POWER));
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        if (this.internalCurrentPower > amt) {
            this.internalCurrentPower -= amt;
            this.changePowerLevel();
            return amt;
        }
        amt = this.internalCurrentPower;
        this.internalCurrentPower = 0.0;
        this.changePowerLevel();
        return amt;
    }

    private double getInternalMaxPower() {
        return this.internalMaxPower;
    }

    void setInternalMaxPower(double internalMaxPower) {
        this.internalMaxPower = internalMaxPower;
    }
}

