/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.powersink;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.events.MENetworkPowerStorage;
import appeng.core.AEConfig;
import appeng.tile.AEBaseInvBlockEntity;
import appeng.tile.powersink.IExternalPowerSink;
import com.google.common.collect.ImmutableSet;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import team.reborn.energy.EnergySide;
import team.reborn.energy.EnergyStorage;
import team.reborn.energy.EnergyTier;

public abstract class AEBasePoweredBlockEntity
extends AEBaseInvBlockEntity
implements IAEPowerStorage,
IExternalPowerSink,
EnergyStorage {
    private double internalMaxPower = 10000.0;
    private boolean internalPublicPowerStorage = false;
    private AccessRestriction internalPowerFlow = AccessRestriction.READ_WRITE;
    private double internalCurrentPower = 0.0;
    private static final Set<class_2350> ALL_SIDES = ImmutableSet.copyOf(EnumSet.allOf(class_2350.class));
    private Set<class_2350> internalPowerSides = ALL_SIDES;

    public AEBasePoweredBlockEntity(class_2591<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    protected final Set<class_2350> getPowerSides() {
        return this.internalPowerSides;
    }

    protected void setPowerSides(Set<class_2350> sides) {
        this.internalPowerSides = ImmutableSet.copyOf(sides);
    }

    @Override
    public class_2487 method_11007(class_2487 data) {
        super.method_11007(data);
        data.method_10549("internalCurrentPower", this.getInternalCurrentPower());
        return data;
    }

    @Override
    public void method_11014(class_2680 state, class_2487 data) {
        super.method_11014(state, data);
        this.setInternalCurrentPower(data.method_10574("internalCurrentPower"));
    }

    @Override
    public final double getExternalPowerDemand(PowerUnits externalUnit, double maxPowerRequired) {
        return PowerUnits.AE.convertTo(externalUnit, Math.max(0.0, this.getFunnelPowerDemand(externalUnit.convertTo(PowerUnits.AE, maxPowerRequired))));
    }

    protected double getFunnelPowerDemand(double maxRequired) {
        return this.getInternalMaxPower() - this.getInternalCurrentPower();
    }

    @Override
    public final double injectExternalPower(PowerUnits input, double amt, Actionable mode) {
        return PowerUnits.AE.convertTo(input, this.funnelPowerIntoStorage(input.convertTo(PowerUnits.AE, amt), mode));
    }

    protected double funnelPowerIntoStorage(double power, Actionable mode) {
        return this.injectAEPower(power, mode);
    }

    @Override
    public final double injectAEPower(double amt, Actionable mode) {
        if (amt < 1.0E-6) {
            return 0.0;
        }
        double required = this.getAEMaxPower() - this.getAECurrentPower();
        double insertable = Math.min(required, amt);
        if (mode == Actionable.MODULATE) {
            if (this.getInternalCurrentPower() < 0.01 && insertable > 0.01) {
                this.PowerEvent(MENetworkPowerStorage.PowerEventType.PROVIDE_POWER);
            }
            this.setInternalCurrentPower(this.getInternalCurrentPower() + insertable);
        }
        return amt - insertable;
    }

    protected void PowerEvent(MENetworkPowerStorage.PowerEventType x) {
    }

    @Override
    public final double getAEMaxPower() {
        return this.getInternalMaxPower();
    }

    @Override
    public final double getAECurrentPower() {
        return this.getInternalCurrentPower();
    }

    @Override
    public final boolean isAEPublicPowerStorage() {
        return this.isInternalPublicPowerStorage();
    }

    @Override
    public final AccessRestriction getPowerFlow() {
        return this.getInternalPowerFlow();
    }

    @Override
    public final double extractAEPower(double amt, Actionable mode, PowerMultiplier multiplier) {
        return multiplier.divide(this.extractAEPower(multiplier.multiply(amt), mode));
    }

    protected double extractAEPower(double amt, Actionable mode) {
        boolean wasFull;
        if (mode == Actionable.SIMULATE) {
            if (this.getInternalCurrentPower() > amt) {
                return amt;
            }
            return this.getInternalCurrentPower();
        }
        boolean bl = wasFull = this.getInternalCurrentPower() >= this.getInternalMaxPower() - 0.001;
        if (wasFull && amt > 0.001) {
            this.PowerEvent(MENetworkPowerStorage.PowerEventType.REQUEST_POWER);
        }
        if (this.getInternalCurrentPower() > amt) {
            this.setInternalCurrentPower(this.getInternalCurrentPower() - amt);
            return amt;
        }
        amt = this.getInternalCurrentPower();
        this.setInternalCurrentPower(0.0);
        return amt;
    }

    public double getInternalCurrentPower() {
        return this.internalCurrentPower;
    }

    public void setInternalCurrentPower(double internalCurrentPower) {
        this.internalCurrentPower = internalCurrentPower;
    }

    public double getInternalMaxPower() {
        return this.internalMaxPower;
    }

    public void setInternalMaxPower(double internalMaxPower) {
        this.internalMaxPower = internalMaxPower;
    }

    private boolean isInternalPublicPowerStorage() {
        return this.internalPublicPowerStorage;
    }

    public void setInternalPublicPowerStorage(boolean internalPublicPowerStorage) {
        this.internalPublicPowerStorage = internalPublicPowerStorage;
    }

    private AccessRestriction getInternalPowerFlow() {
        return this.internalPowerFlow;
    }

    public void setInternalPowerFlow(AccessRestriction internalPowerFlow) {
        this.internalPowerFlow = internalPowerFlow;
    }

    @Override
    public void onReady() {
        super.onReady();
    }

    @Override
    public void onChunkUnloaded() {
        super.onChunkUnloaded();
    }

    public void method_11012() {
        super.method_11012();
    }

    public double getMaxInput(EnergySide side) {
        double overflow;
        double attemptedInsert = AEConfig.instance().getPowerTransactionLimitTechReborn();
        double couldInsert = attemptedInsert - (overflow = this.injectExternalPower(PowerUnits.TR, attemptedInsert, Actionable.SIMULATE));
        if (couldInsert < 0.001) {
            return 0.0;
        }
        return PowerUnits.AE.convertTo(PowerUnits.TR, couldInsert);
    }

    public double getStored(EnergySide energySide) {
        return 0.0;
    }

    public void setStored(double v) {
        v = class_3532.method_15350((double)v, (double)0.001, (double)this.getMaxStoredPower());
        this.injectExternalPower(PowerUnits.TR, v, Actionable.MODULATE);
    }

    public double getMaxStoredPower() {
        return AEConfig.instance().getPowerTransactionLimitTechReborn();
    }

    public EnergyTier getTier() {
        return EnergyTier.INFINITE;
    }
}

