/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.qnb;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.impl.EmptyFixedItemInv;
import appeng.api.definitions.ITileDefinition;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.block.qnb.QnbFormedState;
import appeng.core.Api;
import appeng.me.GridAccessException;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.implementations.QuantumCalculator;
import appeng.me.cluster.implementations.QuantumCluster;
import appeng.tile.grid.AENetworkInvBlockEntity;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.inv.InvOperation;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_3000;

public class QuantumBridgeBlockEntity
extends AENetworkInvBlockEntity
implements IAEMultiBlock<QuantumCluster>,
class_3000 {
    private final byte corner = (byte)16;
    private final AppEngInternalInventory internalInventory = new AppEngInternalInventory(this, 1, 1);
    private final byte hasSingularity = (byte)32;
    private final byte powered = (byte)64;
    private final QuantumCalculator calc = new QuantumCalculator(this);
    private byte constructed = (byte)-1;
    private QuantumCluster cluster;
    private boolean updateStatus = false;

    public QuantumBridgeBlockEntity(class_2591<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.getProxy().setValidSides(EnumSet.noneOf(class_2350.class));
        this.getProxy().setFlags(GridFlags.DENSE_CAPACITY);
        this.getProxy().setIdlePowerUsage(22.0);
    }

    public void method_16896() {
        if (this.updateStatus) {
            this.updateStatus = false;
            if (this.cluster != null) {
                this.cluster.updateStatus(true);
            }
            this.markForUpdate();
        }
    }

    @Override
    protected void writeToStream(class_2540 data) throws IOException {
        super.writeToStream(data);
        int out = this.constructed;
        if (!this.internalInventory.getInvStack(0).method_7960() && this.constructed != -1) {
            out |= this.hasSingularity;
        }
        if (this.getProxy().isActive() && this.constructed != -1) {
            out |= this.powered;
        }
        data.writeByte((int)((byte)out));
    }

    @Override
    protected boolean readFromStream(class_2540 data) throws IOException {
        boolean c = super.readFromStream(data);
        byte oldValue = this.constructed;
        this.constructed = data.readByte();
        return this.constructed != oldValue || c;
    }

    @Override
    public FixedItemInv getInternalInventory() {
        return this.internalInventory;
    }

    @Override
    public void onChangeInventory(FixedItemInv inv, int slot, InvOperation mc, class_1799 removed, class_1799 added) {
        if (this.cluster != null) {
            this.cluster.updateStatus(true);
        }
    }

    @Override
    protected FixedItemInv getItemHandlerForSide(class_2350 side) {
        if (this.isCenter()) {
            return this.internalInventory;
        }
        return EmptyFixedItemInv.INSTANCE;
    }

    private boolean isCenter() {
        return Api.instance().definitions().blocks().quantumLink().maybeBlock().map(link -> this.method_11010().method_26204() == link).orElse(false);
    }

    @MENetworkEventSubscribe
    public void onPowerStatusChange(MENetworkPowerStatusChange c) {
        this.updateStatus = true;
    }

    @Override
    public void onChunkUnloaded() {
        this.disconnect(false);
        super.onChunkUnloaded();
    }

    @Override
    public void onReady() {
        boolean isPresent;
        super.onReady();
        ITileDefinition quantumRing = Api.instance().definitions().blocks().quantumRing();
        Optional<class_2248> maybeLinkBlock = quantumRing.maybeBlock();
        Optional<class_1799> maybeLinkStack = quantumRing.maybeStack(1);
        boolean bl = isPresent = maybeLinkBlock.isPresent() && maybeLinkStack.isPresent();
        if (isPresent && this.method_11010().method_26204() == maybeLinkBlock.get()) {
            class_1799 linkStack = maybeLinkStack.get();
            this.getProxy().setVisualRepresentation(linkStack);
        }
    }

    @Override
    public void method_11012() {
        this.disconnect(false);
        super.method_11012();
    }

    @Override
    public void disconnect(boolean affectWorld) {
        if (this.cluster != null) {
            if (!affectWorld) {
                this.cluster.setUpdateStatus(false);
            }
            this.cluster.destroy();
        }
        this.cluster = null;
        if (affectWorld) {
            this.getProxy().setValidSides(EnumSet.noneOf(class_2350.class));
        }
    }

    @Override
    public QuantumCluster getCluster() {
        return this.cluster;
    }

    @Override
    public boolean isValid() {
        return !this.method_11015();
    }

    public void updateStatus(QuantumCluster c, byte flags, boolean affectWorld) {
        this.cluster = c;
        if (affectWorld) {
            if (this.constructed != flags) {
                this.constructed = flags;
                this.markForUpdate();
            }
            if (this.isCorner() || this.isCenter()) {
                EnumSet<class_2350> sides = EnumSet.copyOf(this.getAdjacentQuantumBridges());
                this.getProxy().setValidSides(sides);
            } else {
                this.getProxy().setValidSides(EnumSet.allOf(class_2350.class));
            }
        }
    }

    public boolean isCorner() {
        return (this.constructed & this.getCorner()) == this.getCorner() && this.constructed != -1;
    }

    public EnumSet<class_2350> getAdjacentQuantumBridges() {
        EnumSet<class_2350> set = EnumSet.noneOf(class_2350.class);
        for (class_2350 d : class_2350.values()) {
            class_2586 te = this.field_11863.method_8321(this.field_11867.method_10093(d));
            if (!(te instanceof QuantumBridgeBlockEntity)) continue;
            set.add(d);
        }
        return set;
    }

    public long getQEFrequency() {
        class_2487 c;
        class_1799 is = this.internalInventory.getInvStack(0);
        if (!is.method_7960() && (c = is.method_7969()) != null) {
            return c.method_10537("freq");
        }
        return 0L;
    }

    public boolean isPowered() {
        if (this.isClient()) {
            return (this.constructed & this.powered) == this.powered && this.constructed != -1;
        }
        try {
            return this.getProxy().getEnergy().isNetworkPowered();
        }
        catch (GridAccessException gridAccessException) {
            return false;
        }
    }

    public boolean isFormed() {
        return this.constructed != -1;
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.DENSE_SMART;
    }

    public void neighborUpdate(class_2338 fromPos) {
        this.calc.updateMultiblockAfterNeighborUpdate(this.field_11863, this.field_11867, fromPos);
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    public boolean hasQES() {
        if (this.constructed == -1) {
            return false;
        }
        return (this.constructed & this.hasSingularity) == this.hasSingularity;
    }

    public void breakCluster() {
        this.method_11000();
        if (this.cluster != null) {
            this.cluster.destroy();
        }
    }

    public byte getCorner() {
        return this.corner;
    }

    @Override
    public QnbFormedState getRenderAttachmentData() {
        return new QnbFormedState(this.getAdjacentQuantumBridges(), this.isCorner(), this.isPowered());
    }
}

