/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.spatial;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.LimitedFixedItemInv;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.YesNo;
import appeng.api.implementations.items.ISpatialStorageCell;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkSpatialEvent;
import appeng.api.networking.spatial.ISpatialCache;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.hooks.TickHandler;
import appeng.me.cache.SpatialPylonCache;
import appeng.tile.grid.AENetworkInvBlockEntity;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.IWorldCallable;
import appeng.util.Platform;
import appeng.util.inv.InvOperation;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class SpatialIOPortBlockEntity
extends AENetworkInvBlockEntity
implements IWorldCallable<Void> {
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 2);
    private final LimitedFixedItemInv invExt;
    private YesNo lastRedstoneState = YesNo.UNDECIDED;

    public SpatialIOPortBlockEntity(class_2591<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.getProxy().setFlags(GridFlags.REQUIRE_CHANNEL);
        this.invExt = this.inv.createLimitedFixedInv();
        this.invExt.getRule(0).disallowExtraction().allowInsertion().filterInserts(this::isSpatialCell);
        this.invExt.getRule(1).disallowInsertion().allowExtraction();
    }

    @Override
    public class_2487 method_11007(class_2487 data) {
        super.method_11007(data);
        data.method_10569("lastRedstoneState", this.lastRedstoneState.ordinal());
        return data;
    }

    @Override
    public void method_11014(class_2680 state, class_2487 data) {
        super.method_11014(state, data);
        if (data.method_10545("lastRedstoneState")) {
            this.lastRedstoneState = YesNo.values()[data.method_10550("lastRedstoneState")];
        }
    }

    public boolean getRedstoneState() {
        if (this.lastRedstoneState == YesNo.UNDECIDED) {
            this.updateRedstoneState();
        }
        return this.lastRedstoneState == YesNo.YES;
    }

    public void updateRedstoneState() {
        YesNo currentState;
        YesNo yesNo = currentState = this.field_11863.method_8482(this.field_11867) != 0 ? YesNo.YES : YesNo.NO;
        if (this.lastRedstoneState != currentState) {
            this.lastRedstoneState = currentState;
            if (this.lastRedstoneState == YesNo.YES) {
                this.triggerTransition();
            }
        }
    }

    private void triggerTransition() {
        class_1799 cell;
        if (Platform.isServer() && this.isSpatialCell(cell = this.inv.getInvStack(0))) {
            TickHandler.instance().addCallable(null, this);
        }
    }

    private boolean isSpatialCell(class_1799 cell) {
        if (!cell.method_7960() && cell.method_7909() instanceof ISpatialStorageCell) {
            ISpatialStorageCell sc = (ISpatialStorageCell)cell.method_7909();
            return sc != null && sc.isSpatialStorage(cell);
        }
        return false;
    }

    @Override
    public Void call(class_1937 world) throws Exception {
        if (!(this.field_11863 instanceof class_3218)) {
            return null;
        }
        class_3218 serverWorld = (class_3218)this.field_11863;
        class_1799 cell = this.inv.getInvStack(0);
        if (this.isSpatialCell(cell) && this.inv.getInvStack(1).method_7960()) {
            MENetworkEvent res;
            double req;
            double pr;
            IGrid gi = this.getProxy().getGrid();
            IEnergyGrid energy = this.getProxy().getEnergy();
            ISpatialStorageCell sc = (ISpatialStorageCell)cell.method_7909();
            SpatialPylonCache spc = (SpatialPylonCache)gi.getCache(ISpatialCache.class);
            if (spc.hasRegion() && spc.isValidRegion() && Math.abs((pr = energy.extractAEPower(req = (double)spc.requiredPower(), Actionable.SIMULATE, PowerMultiplier.CONFIG)) - req) < req * 0.001 && !(res = gi.postEvent(new MENetworkSpatialEvent(this, req))).isCanceled()) {
                int playerId = this.getProxy().getSecurity().isAvailable() ? this.getProxy().getSecurity().getOwner() : this.getProxy().getNode().getPlayerID();
                boolean success = sc.doSpatialTransition(cell, serverWorld, spc.getMin(), spc.getMax(), playerId);
                if (success) {
                    energy.extractAEPower(req, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    this.inv.setInvStack(0, class_1799.field_8037, Simulation.ACTION);
                    this.inv.setInvStack(1, cell, Simulation.ACTION);
                }
            }
        }
        return null;
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    @Nonnull
    protected FixedItemInv getItemHandlerForSide(@Nonnull class_2350 side) {
        return this.invExt;
    }

    @Override
    public FixedItemInv getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onChangeInventory(FixedItemInv inv, int slot, InvOperation mc, class_1799 removed, class_1799 added) {
    }
}

