/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.storage;

import alexiil.mc.lib.attributes.AttributeList;
import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FluidInsertable;
import alexiil.mc.lib.attributes.fluid.FluidVolumeUtil;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.ConstantFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.LimitedFixedItemInv;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.implementations.tiles.IMEChest;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.events.MENetworkPowerStorage;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ICellGuiHandler;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.ICellInventory;
import appeng.api.storage.cells.ICellInventoryHandler;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AEColor;
import appeng.api.util.IConfigManager;
import appeng.container.implementations.MEMonitorableContainer;
import appeng.core.Api;
import appeng.fluids.container.FluidTerminalContainer;
import appeng.fluids.util.AEFluidStack;
import appeng.helpers.IPriorityHost;
import appeng.me.GridAccessException;
import appeng.me.helpers.MEMonitorHandler;
import appeng.me.helpers.MachineSource;
import appeng.me.storage.MEInventoryHandler;
import appeng.tile.grid.AENetworkPowerBlockEntity;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.InvOperation;
import appeng.util.inv.WrapperChainedItemHandler;
import appeng.util.item.AEItemStack;
import java.io.IOException;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3000;
import net.minecraft.class_3917;

public class ChestBlockEntity
extends AENetworkPowerBlockEntity
implements IMEChest,
ITerminalHost,
IPriorityHost,
IConfigManagerHost,
IColorableTile,
class_3000 {
    private static final int BIT_POWER_MASK = -128;
    private static final int BIT_STATE_MASK = 7;
    private static final int BIT_CELL_STATE_MASK = 7;
    private static final int BIT_CELL_STATE_BITS = 3;
    private final AppEngInternalInventory inputInventory = new AppEngInternalInventory(this, 1);
    private final LimitedFixedItemInv externalInputInventory;
    private final AppEngInternalInventory cellInventory = new AppEngInternalInventory(this, 1);
    private final LimitedFixedItemInv externalCellInventory;
    private final FixedItemInv internalInventory = new WrapperChainedItemHandler(new FixedItemInv[]{this.inputInventory, this.cellInventory});
    private final IActionSource mySrc = new MachineSource(this);
    private final IConfigManager config = new ConfigManager(this);
    private long lastStateChange = 0L;
    private int priority = 0;
    private int state = 0;
    private boolean wasActive = false;
    private AEColor paintedColor = AEColor.TRANSPARENT;
    private boolean isCached = false;
    private ChestMonitorHandler cellHandler;
    private Accessor accessor;
    private FluidInsertable fluidInsertable;
    private class_1792 cellItem = class_1802.field_8162;

    public ChestBlockEntity(class_2591<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.setInternalMaxPower(PowerMultiplier.CONFIG.multiply(40.0));
        this.getProxy().setFlags(GridFlags.REQUIRE_CHANNEL);
        this.config.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        this.config.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        this.config.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
        this.setInternalPublicPowerStorage(true);
        this.setInternalPowerFlow(AccessRestriction.WRITE);
        this.externalInputInventory = this.inputInventory.createLimitedFixedInv();
        this.externalInputInventory.getAllRule().disallowExtraction().filterInserts(this::canInsertItemsExternally);
        this.externalCellInventory = this.cellInventory.createLimitedFixedInv();
        this.externalCellInventory.getAllRule().filterInserts(ChestBlockEntity::canInsertCell);
    }

    private static boolean canInsertCell(class_1799 stack) {
        return Api.instance().registries().cell().getHandler(stack) != null;
    }

    public class_1799 getCell() {
        return this.cellInventory.getInvStack(0);
    }

    private boolean canInsertItemsExternally(class_1799 stack) {
        if (this.isPowered()) {
            this.updateHandler();
            if (this.cellHandler == null) {
                return false;
            }
            IItemStorageChannel itemChannel = Api.instance().storage().getStorageChannel(IItemStorageChannel.class);
            return this.cellHandler.getChannel() == itemChannel && this.cellHandler.canAccept(AEItemStack.fromItemStack(stack));
        }
        return false;
    }

    @Override
    protected void PowerEvent(MENetworkPowerStorage.PowerEventType x) {
        if (x == MENetworkPowerStorage.PowerEventType.REQUEST_POWER) {
            try {
                this.getProxy().getGrid().postEvent(new MENetworkPowerStorage(this, MENetworkPowerStorage.PowerEventType.REQUEST_POWER));
            }
            catch (GridAccessException gridAccessException) {}
        } else {
            this.recalculateDisplay();
        }
    }

    private void recalculateDisplay() {
        int oldState = this.state;
        for (int x = 0; x < this.getCellCount(); ++x) {
            this.state |= this.getCellStatus(x).ordinal() << 3 * x;
        }
        this.state = this.isPowered() ? (this.state |= 0xFFFFFF80) : (this.state &= 0x7F);
        boolean currentActive = this.getProxy().isActive();
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            try {
                this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        if (oldState != this.state) {
            this.markForUpdate();
        }
    }

    @Override
    public int getCellCount() {
        return 1;
    }

    private void updateHandler() {
        if (!this.isCached) {
            this.cellHandler = null;
            this.accessor = null;
            this.fluidInsertable = null;
            class_1799 is = this.getCell();
            if (!is.method_7960()) {
                this.isCached = true;
                ICellHandler cellHandler = Api.instance().registries().cell().getHandler(is);
                if (cellHandler != null) {
                    double power = 1.0;
                    for (IStorageChannel<? extends IAEStack<?>> iStorageChannel : Api.instance().storage().storageChannels()) {
                        ICellInventoryHandler<? extends IAEStack<?>> newCell = cellHandler.getCellInventory(is, this, iStorageChannel);
                        if (newCell == null) continue;
                        power += cellHandler.cellIdleDrain(is, newCell);
                        this.cellHandler = this.wrap(newCell);
                        break;
                    }
                    this.getProxy().setIdlePowerUsage(power);
                    this.accessor = new Accessor();
                    if (this.cellHandler != null && this.cellHandler.getChannel() == Api.instance().storage().getStorageChannel(IFluidStorageChannel.class)) {
                        this.fluidInsertable = new FluidHandler();
                    }
                }
            }
        }
    }

    private <T extends IAEStack<T>> ChestMonitorHandler<T> wrap(IMEInventoryHandler<T> h) {
        if (h == null) {
            return null;
        }
        MEInventoryHandler<T> ih = new MEInventoryHandler<T>(h, h.getChannel());
        ih.setPriority(this.priority);
        ChestMonitorHandler g = new ChestMonitorHandler(ih);
        g.addListener(new ChestNetNotifier(h.getChannel()), g);
        return g;
    }

    @Override
    public CellState getCellStatus(int slot) {
        if (this.isClient()) {
            return CellState.values()[this.state >> slot * 3 & 7];
        }
        this.updateHandler();
        class_1799 cell = this.getCell();
        ICellHandler ch = Api.instance().registries().cell().getHandler(cell);
        if (this.cellHandler != null && ch != null) {
            return ch.getStatusForCell(cell, this.cellHandler.getInternalHandler());
        }
        return CellState.ABSENT;
    }

    @Override
    @Nullable
    public class_1792 getCellItem(int slot) {
        if (slot != 0) {
            return null;
        }
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return this.cellItem;
        }
        class_1799 cell = this.getCell();
        return cell.method_7960() ? null : cell.method_7909();
    }

    @Override
    public boolean isPowered() {
        boolean gridPowered;
        if (this.isClient()) {
            return (this.state & 0xFFFFFF80) == -128;
        }
        boolean bl = gridPowered = this.getAECurrentPower() > 64.0;
        if (!gridPowered) {
            try {
                gridPowered = this.getProxy().getEnergy().isNetworkPowered();
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return super.getAECurrentPower() > 1.0 || gridPowered;
    }

    @Override
    public boolean isCellBlinking(int slot) {
        return false;
    }

    @Override
    protected double extractAEPower(double amt, Actionable mode) {
        double stash = 0.0;
        try {
            IEnergyGrid eg = this.getProxy().getEnergy();
            stash = eg.extractAEPower(amt, mode, PowerMultiplier.ONE);
            if (stash >= amt) {
                return stash;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return super.extractAEPower(amt - stash, mode) + stash;
    }

    public void method_16896() {
        block5: {
            if (this.field_11863.field_9236) {
                return;
            }
            double idleUsage = this.getProxy().getIdlePowerUsage();
            try {
                double powerUsed;
                if (!this.getProxy().getEnergy().isNetworkPowered() && (powerUsed = this.extractAEPower(idleUsage, Actionable.MODULATE, PowerMultiplier.CONFIG)) + 0.1 >= idleUsage != (this.state & 0xFFFFFF80) > 0) {
                    this.recalculateDisplay();
                }
            }
            catch (GridAccessException e) {
                double powerUsed = this.extractAEPower(this.getProxy().getIdlePowerUsage(), Actionable.MODULATE, PowerMultiplier.CONFIG);
                if (powerUsed + 0.1 >= idleUsage == (this.state & 0xFFFFFF80) > 0) break block5;
                this.recalculateDisplay();
            }
        }
        if (!ItemHandlerUtil.isEmpty((FixedItemInv)this.inputInventory)) {
            this.tryToStoreContents();
        }
    }

    @Override
    protected void writeToStream(class_2540 data) throws IOException {
        super.writeToStream(data);
        this.state = 0;
        for (int x = 0; x < this.getCellCount(); ++x) {
            this.state |= this.getCellStatus(x).ordinal() << 3 * x;
        }
        this.state = this.isPowered() ? (this.state |= 0xFFFFFF80) : (this.state &= 0x7F);
        data.writeByte(this.state);
        data.writeByte(this.paintedColor.ordinal());
        data.method_10804(class_1792.method_7880((class_1792)this.getCell().method_7909()));
    }

    @Override
    protected boolean readFromStream(class_2540 data) throws IOException {
        boolean c = super.readFromStream(data);
        int oldState = this.state;
        this.state = data.readByte();
        AEColor oldPaintedColor = this.paintedColor;
        this.paintedColor = AEColor.values()[data.readByte()];
        this.cellItem = class_1792.method_7875((int)data.method_10816());
        this.lastStateChange = this.field_11863.method_8510();
        return oldPaintedColor != this.paintedColor || (this.state & 0xDB6DB6DB) != (oldState & 0xDB6DB6DB) || c;
    }

    @Override
    public void method_11014(class_2680 state, class_2487 data) {
        super.method_11014(state, data);
        this.config.readFromNBT(data);
        this.priority = data.method_10550("priority");
        if (data.method_10545("paintedColor")) {
            this.paintedColor = AEColor.values()[data.method_10571("paintedColor")];
        }
    }

    @Override
    public class_2487 method_11007(class_2487 data) {
        super.method_11007(data);
        this.config.writeToNBT(data);
        data.method_10569("priority", this.priority);
        data.method_10567("paintedColor", (byte)this.paintedColor.ordinal());
        return data;
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.recalculateDisplay();
    }

    @MENetworkEventSubscribe
    public void channelRender(MENetworkChannelsChanged c) {
        this.recalculateDisplay();
    }

    @Override
    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
        this.updateHandler();
        if (this.cellHandler != null && this.cellHandler.getChannel() == channel) {
            return this.cellHandler;
        }
        return null;
    }

    @Override
    public FixedItemInv getInternalInventory() {
        return this.internalInventory;
    }

    @Override
    public void onChangeInventory(FixedItemInv inv, int slot, InvOperation mc, class_1799 removed, class_1799 added) {
        if (inv == this.cellInventory) {
            this.cellHandler = null;
            this.isCached = false;
            try {
                this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
                IStorageGrid gs = this.getProxy().getStorage();
                Platform.postChanges(gs, removed, added, this.mySrc);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            if (this.field_11863 != null) {
                Platform.notifyBlocksOfNeighbors(this.field_11863, this.field_11867);
                this.markForUpdate();
            }
        }
        if (inv == this.inputInventory && mc == InvOperation.INSERT) {
            this.tryToStoreContents();
        }
    }

    @Override
    protected FixedItemInv getItemHandlerForSide(@Nonnull class_2350 side) {
        if (side == this.getForward()) {
            return this.externalCellInventory;
        }
        return this.externalInputInventory;
    }

    private void tryToStoreContents() {
        if (!ItemHandlerUtil.isEmpty((FixedItemInv)this.inputInventory)) {
            this.updateHandler();
            if (this.cellHandler != null && this.cellHandler.getChannel() == Api.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
                IAEItemStack returns = Platform.poweredInsert(this, this.cellHandler, AEItemStack.fromItemStack(this.inputInventory.getInvStack(0)), this.mySrc);
                if (returns == null) {
                    this.inputInventory.forceSetInvStack(0, class_1799.field_8037);
                } else {
                    this.inputInventory.forceSetInvStack(0, returns.createItemStack());
                }
            }
        }
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel channel) {
        if (this.getProxy().isActive()) {
            this.updateHandler();
            if (this.cellHandler != null && this.cellHandler.getChannel() == channel) {
                return Collections.singletonList(this.cellHandler);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newValue) {
        this.priority = newValue;
        this.cellHandler = null;
        this.isCached = false;
        try {
            this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public void blinkCell(int slot) {
        long now = this.field_11863.method_8510();
        if (now - this.lastStateChange > 8L) {
            this.state = 0;
        }
        this.lastStateChange = now;
        this.state |= 1 << slot * 3 + 2;
        this.recalculateDisplay();
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.config;
    }

    @Override
    public void updateSetting(IConfigManager manager, Settings settingName, Enum<?> newValue) {
    }

    public boolean openGui(class_1657 p) {
        ICellGuiHandler chg;
        ICellHandler ch;
        this.updateHandler();
        if (this.cellHandler != null && (ch = Api.instance().registries().cell().getHandler(this.getCell())) != null && (chg = Api.instance().registries().cell().getGuiHandler(this.cellHandler.getChannel(), this.getCell())) != null) {
            chg.openChestGui(p, this, ch, this.cellHandler, this.getCell(), this.cellHandler.getChannel());
            return true;
        }
        return false;
    }

    @Override
    public AEColor getColor() {
        return this.paintedColor;
    }

    @Override
    public boolean recolourBlock(class_2350 side, AEColor newPaintedColor, class_1657 who) {
        if (this.paintedColor == newPaintedColor) {
            return false;
        }
        this.paintedColor = newPaintedColor;
        this.saveChanges();
        this.markForUpdate();
        return true;
    }

    @Override
    public void saveChanges(ICellInventory<?> cellInventory) {
        if (cellInventory != null) {
            cellInventory.persist();
        }
        this.field_11863.method_8524(this.field_11867, (class_2586)this);
    }

    @Override
    public void addAllAttributes(class_1937 world, class_2338 pos, class_2680 state, AttributeList<?> to) {
        super.addAllAttributes(world, pos, state, to);
        if (this.fluidInsertable != null && to.getSearchDirection() != this.getForward().method_10153()) {
            to.offer((Object)this.fluidInsertable);
        }
        if (this.accessor != null && to.getSearchDirection() != this.getForward().method_10153()) {
            to.offer((Object)this.accessor);
        }
    }

    @Override
    public class_1799 getItemStackRepresentation() {
        return Api.instance().definitions().blocks().chest().maybeStack(1).orElse(class_1799.field_8037);
    }

    @Override
    public class_3917<?> getContainerType() {
        this.updateHandler();
        if (this.cellHandler != null) {
            if (this.cellHandler.getChannel() == Api.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
                return MEMonitorableContainer.TYPE;
            }
            if (this.cellHandler.getChannel() == Api.instance().storage().getStorageChannel(IFluidStorageChannel.class)) {
                return FluidTerminalContainer.TYPE;
            }
        }
        return null;
    }

    private class FluidHandler
    implements FluidInsertable {
        private FluidHandler() {
        }

        private boolean canAcceptLiquids() {
            return ChestBlockEntity.this.cellHandler != null && ChestBlockEntity.this.cellHandler.getChannel() == Api.instance().storage().getStorageChannel(IFluidStorageChannel.class);
        }

        public FluidVolume attemptInsertion(FluidVolume fluidVolume, Simulation simulation) {
            ChestBlockEntity.this.updateHandler();
            if (!this.canAcceptLiquids()) {
                return fluidVolume;
            }
            AEFluidStack toInsert = AEFluidStack.fromFluidVolume(fluidVolume, RoundingMode.DOWN);
            if (toInsert == null) {
                return fluidVolume;
            }
            IAEFluidStack remaining = Platform.poweredInsert(ChestBlockEntity.this, ChestBlockEntity.this.cellHandler, toInsert, ChestBlockEntity.this.mySrc, simulation == Simulation.ACTION ? Actionable.MODULATE : Actionable.SIMULATE);
            FluidAmount filledAmt = remaining != null ? remaining.getAmount() : toInsert.getAmount();
            FluidAmount remainingAmt = fluidVolume.amount().roundedSub(filledAmt, RoundingMode.DOWN);
            if (remainingAmt.isZero()) {
                return FluidVolumeUtil.EMPTY;
            }
            return fluidVolume.withAmount(remainingAmt);
        }

        public FluidFilter getInsertionFilter() {
            ChestBlockEntity.this.updateHandler();
            return this.canAcceptLiquids() ? ConstantFluidFilter.ANYTHING : ConstantFluidFilter.NOTHING;
        }
    }

    private class Accessor
    implements IStorageMonitorableAccessor {
        private Accessor() {
        }

        @Override
        @Nullable
        public IStorageMonitorable getInventory(IActionSource src) {
            if (Platform.canAccess(ChestBlockEntity.this.getProxy(), src)) {
                return ChestBlockEntity.this;
            }
            return null;
        }
    }

    private class ChestMonitorHandler<T extends IAEStack<T>>
    extends MEMonitorHandler<T> {
        public ChestMonitorHandler(IMEInventoryHandler<T> t) {
            super(t);
        }

        private ICellInventoryHandler<T> getInternalHandler() {
            IMEInventoryHandler h = this.getHandler();
            if (h instanceof MEInventoryHandler) {
                return (ICellInventoryHandler)((MEInventoryHandler)h).getInternal();
            }
            return (ICellInventoryHandler)this.getHandler();
        }

        @Override
        public T injectItems(T input, Actionable mode, IActionSource src) {
            if (src.player().map(player -> !this.securityCheck((class_1657)player, SecurityPermissions.INJECT)).orElse(false).booleanValue()) {
                return input;
            }
            return super.injectItems(input, mode, src);
        }

        private boolean securityCheck(class_1657 player, SecurityPermissions requiredPermission) {
            if (ChestBlockEntity.this.getTile() instanceof IActionHost && requiredPermission != null) {
                IGrid g;
                IGridNode gn = ((IActionHost)ChestBlockEntity.this.getTile()).getActionableNode();
                if (gn != null && (g = gn.getGrid()) != null) {
                    boolean requirePower = false;
                    ISecurityGrid sg = (ISecurityGrid)g.getCache(ISecurityGrid.class);
                    if (sg.hasPermission(player, requiredPermission)) {
                        return true;
                    }
                }
                return false;
            }
            return true;
        }

        @Override
        public T extractItems(T request, Actionable mode, IActionSource src) {
            if (src.player().map(player -> !this.securityCheck((class_1657)player, SecurityPermissions.EXTRACT)).orElse(false).booleanValue()) {
                return null;
            }
            return super.extractItems(request, mode, src);
        }
    }

    private class ChestNetNotifier<T extends IAEStack<T>>
    implements IMEMonitorHandlerReceiver<T> {
        private final IStorageChannel<T> chan;

        public ChestNetNotifier(IStorageChannel<T> chan) {
            this.chan = chan;
        }

        @Override
        public boolean isValid(Object verificationToken) {
            ChestBlockEntity.this.updateHandler();
            if (ChestBlockEntity.this.cellHandler != null && this.chan == ChestBlockEntity.this.cellHandler.getChannel()) {
                return verificationToken == ChestBlockEntity.this.cellHandler;
            }
            return false;
        }

        @Override
        public void postChange(IBaseMonitor<T> monitor, Iterable<T> change, IActionSource source) {
            if (source == ChestBlockEntity.this.mySrc || source.machine().map(machine -> machine == ChestBlockEntity.this).orElse(false).booleanValue()) {
                try {
                    if (ChestBlockEntity.this.getProxy().isActive()) {
                        ChestBlockEntity.this.getProxy().getStorage().postAlterationOfStoredItems(this.chan, change, ChestBlockEntity.this.mySrc);
                    }
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
            }
            ChestBlockEntity.this.blinkCell(0);
        }

        @Override
        public void onListUpdate() {
        }
    }
}

