/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.storage;

import alexiil.mc.lib.attributes.item.FixedItemInv;
import appeng.api.implementations.tiles.IChestOrDrive;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.ICellInventory;
import appeng.api.storage.cells.ICellInventoryHandler;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.block.storage.DriveSlotsState;
import appeng.client.render.model.DriveModelData;
import appeng.container.implementations.DriveContainer;
import appeng.core.Api;
import appeng.helpers.IPriorityHost;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.me.storage.DriveWatcher;
import appeng.tile.grid.AENetworkInvBlockEntity;
import appeng.tile.inventory.AppEngCellInventory;
import appeng.util.Platform;
import appeng.util.inv.InvOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3917;

public class DriveBlockEntity
extends AENetworkInvBlockEntity
implements IChestOrDrive,
IPriorityHost {
    private static final int BIT_POWER_MASK = Integer.MIN_VALUE;
    private static final int BIT_STATE_MASK = 0x3FFFFFFF;
    private static final int BIT_CELL_STATE_MASK = 7;
    private static final int BIT_CELL_STATE_BITS = 3;
    private final AppEngCellInventory inv = new AppEngCellInventory(this, 10);
    private final ICellHandler[] handlersBySlot = new ICellHandler[10];
    private final DriveWatcher<IAEItemStack>[] invBySlot = new DriveWatcher[10];
    private final IActionSource mySrc;
    private boolean isCached = false;
    private Map<IStorageChannel<? extends IAEStack<?>>, List<IMEInventoryHandler>> inventoryHandlers;
    private int priority = 0;
    private boolean wasActive = false;
    private final class_1792[] cellItems = new class_1792[10];
    private int state = 0;

    public DriveBlockEntity(class_2591<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.mySrc = new MachineSource(this);
        this.getProxy().setFlags(GridFlags.REQUIRE_CHANNEL);
        this.inventoryHandlers = new IdentityHashMap();
    }

    @Override
    public void setOrientation(class_2350 inForward, class_2350 inUp) {
        super.setOrientation(inForward, inUp);
        this.getProxy().setValidSides(EnumSet.complementOf(EnumSet.of(inForward)));
    }

    @Override
    protected void writeToStream(class_2540 data) throws IOException {
        super.writeToStream(data);
        int newState = 0;
        if (this.getProxy().isActive()) {
            newState |= Integer.MIN_VALUE;
        }
        for (int x = 0; x < this.getCellCount(); ++x) {
            int o = this.getCellStatus(x).ordinal();
            int i = o << 3 * x;
            newState |= i;
        }
        data.writeInt(newState);
        this.writeCellItemIds(data);
    }

    private void writeCellItemIds(class_2540 data) {
        ArrayList<Integer> cellItemIds = new ArrayList<Integer>(this.getCellCount());
        byte[] bm = new byte[this.getCellCount()];
        for (int x = 0; x < this.getCellCount(); ++x) {
            class_1792 item = this.getCellItem(x);
            if (item == null) continue;
            int itemId = class_1792.method_7880((class_1792)item);
            int idx = cellItemIds.indexOf(itemId);
            if (idx == -1) {
                cellItemIds.add(itemId);
                bm[x] = (byte)cellItemIds.size();
                continue;
            }
            bm[x] = (byte)(1 + idx);
        }
        data.writeByte(cellItemIds.size());
        Iterator x = cellItemIds.iterator();
        while (x.hasNext()) {
            int itemId = (Integer)x.next();
            data.method_10804(itemId);
        }
        for (int i = 0; i < this.getCellCount(); ++i) {
            data.writeByte((int)bm[i]);
        }
    }

    @Override
    protected boolean readFromStream(class_2540 data) throws IOException {
        boolean c = super.readFromStream(data);
        int oldState = this.state;
        this.state = data.readInt();
        return (this.state & 0x3FFFFFFF) != (oldState & 0x3FFFFFFF) || (c |= this.readCellItemIDs(data));
    }

    private boolean readCellItemIDs(class_2540 data) {
        int uniqueIdCount = data.readByte();
        int[] uniqueIds = new int[uniqueIdCount];
        for (int i = 0; i < uniqueIdCount; ++i) {
            uniqueIds[i] = data.method_10816();
        }
        boolean changed = false;
        for (int i = 0; i < this.getCellCount(); ++i) {
            byte idx = data.readByte();
            class_1792 item = null;
            if (idx > 0) {
                idx = (byte)(idx - 1);
                int itemId = uniqueIds[idx];
                item = class_1792.method_7875((int)itemId);
            }
            if (this.cellItems[i] == item) continue;
            changed = true;
            this.cellItems[i] = item;
        }
        return changed;
    }

    @Override
    public int getCellCount() {
        return 10;
    }

    @Override
    @Nullable
    public class_1792 getCellItem(int slot) {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return this.cellItems[slot];
        }
        class_1799 stackInSlot = this.inv.getInvStack(slot);
        if (!stackInSlot.method_7960()) {
            return stackInSlot.method_7909();
        }
        return null;
    }

    @Override
    public CellState getCellStatus(int slot) {
        if (Platform.isClient()) {
            int cellState = this.state >> slot * 3 & 7;
            return CellState.values()[cellState];
        }
        DriveWatcher<IAEItemStack> handler = this.invBySlot[slot];
        if (handler == null) {
            return CellState.ABSENT;
        }
        return handler.getStatus();
    }

    @Override
    public boolean isPowered() {
        if (this.isClient()) {
            return (this.state & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        }
        return this.getProxy().isActive();
    }

    @Override
    public boolean isCellBlinking(int slot) {
        return false;
    }

    @Override
    public void method_11014(class_2680 state, class_2487 data) {
        super.method_11014(state, data);
        this.isCached = false;
        this.priority = data.method_10550("priority");
    }

    @Override
    public class_2487 method_11007(class_2487 data) {
        super.method_11007(data);
        data.method_10569("priority", this.priority);
        return data;
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.recalculateDisplay();
    }

    private void recalculateDisplay() {
        boolean currentActive = this.getProxy().isActive();
        int newState = 0;
        if (currentActive) {
            newState |= Integer.MIN_VALUE;
        }
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            try {
                this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        for (int x = 0; x < this.getCellCount(); ++x) {
            newState |= this.getCellStatus(x).ordinal() << 3 * x;
        }
        if (newState != this.state) {
            this.state = newState;
            this.markForUpdate();
        }
    }

    @MENetworkEventSubscribe
    public void channelRender(MENetworkChannelsChanged c) {
        this.recalculateDisplay();
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    public FixedItemInv getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onChangeInventory(FixedItemInv inv, int slot, InvOperation mc, class_1799 removed, class_1799 added) {
        if (this.isCached) {
            this.isCached = false;
            this.updateState();
        }
        try {
            this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
            IStorageGrid gs = this.getProxy().getStorage();
            Platform.postChanges(gs, removed, added, this.mySrc);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        this.markForUpdate();
    }

    private void updateState() {
        if (!this.isCached) {
            Collection<IStorageChannel<IAEStack<?>>> storageChannels = Api.instance().storage().storageChannels();
            storageChannels.forEach(channel -> {
                List cfr_ignored_0 = this.inventoryHandlers.put((IStorageChannel<IAEStack<?>>)channel, new ArrayList(10));
            });
            double power = 2.0;
            block0: for (int x = 0; x < this.inv.getSlotCount(); ++x) {
                class_1799 is = this.inv.getInvStack(x);
                this.invBySlot[x] = null;
                this.handlersBySlot[x] = null;
                if (is.method_7960()) continue;
                this.handlersBySlot[x] = Api.instance().registries().cell().getHandler(is);
                if (this.handlersBySlot[x] == null) continue;
                for (IStorageChannel<? extends IAEStack<?>> iStorageChannel : storageChannels) {
                    ICellInventoryHandler<? extends IAEStack<?>> cell = this.handlersBySlot[x].getCellInventory(is, this, iStorageChannel);
                    if (cell == null) continue;
                    this.inv.setHandler(x, cell);
                    power += this.handlersBySlot[x].cellIdleDrain(is, cell);
                    DriveWatcher ih = new DriveWatcher(cell, is, this.handlersBySlot[x], this);
                    ih.setPriority(this.priority);
                    this.invBySlot[x] = ih;
                    this.inventoryHandlers.get(iStorageChannel).add(ih);
                    continue block0;
                }
            }
            this.getProxy().setIdlePowerUsage(power);
            this.isCached = true;
        }
    }

    @Override
    public void onReady() {
        super.onReady();
        this.updateState();
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel channel) {
        if (this.getProxy().isActive()) {
            this.updateState();
            return this.inventoryHandlers.get(channel);
        }
        return Collections.emptyList();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newValue) {
        this.priority = newValue;
        this.saveChanges();
        this.isCached = false;
        this.updateState();
        try {
            this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public void blinkCell(int slot) {
        this.recalculateDisplay();
    }

    @Override
    public void saveChanges(ICellInventory<?> cellInventory) {
        this.field_11863.method_8524(this.field_11867, (class_2586)this);
    }

    @Override
    public class_1799 getItemStackRepresentation() {
        return Api.instance().definitions().blocks().drive().maybeStack(1).orElse(class_1799.field_8037);
    }

    @Override
    public DriveModelData getRenderAttachmentData() {
        return new DriveModelData(this.getUp(), this.getForward(), DriveSlotsState.fromChestOrDrive(this));
    }

    @Override
    public class_3917<?> getContainerType() {
        return DriveContainer.TYPE;
    }
}

