/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.storage;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.LimitedFixedItemInv;
import appeng.api.config.Actionable;
import appeng.api.config.FullnessMode;
import appeng.api.config.OperationMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.core.Api;
import appeng.core.settings.TickRates;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.parts.automation.BlockUpgradeInventory;
import appeng.parts.automation.UpgradeInventory;
import appeng.tile.grid.AENetworkInvBlockEntity;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.AdaptorFixedInv;
import appeng.util.inv.InvOperation;
import appeng.util.inv.WrapperChainedItemHandler;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class IOPortBlockEntity
extends AENetworkInvBlockEntity
implements IUpgradeableHost,
IConfigManagerHost,
IGridTickable {
    private static final int NUMBER_OF_CELL_SLOTS = 6;
    private static final int NUMBER_OF_UPGRADE_SLOTS = 3;
    private final ConfigManager manager;
    private final AppEngInternalInventory inputCells = new AppEngInternalInventory(this, 6);
    private final AppEngInternalInventory outputCells = new AppEngInternalInventory(this, 6);
    private final FixedItemInv combinedInventory = new WrapperChainedItemHandler(new FixedItemInv[]{this.inputCells, this.outputCells});
    private final LimitedFixedItemInv inputCellsExt;
    private final LimitedFixedItemInv outputCellsExt;
    private final UpgradeInventory upgrades;
    private final IActionSource mySrc;
    private YesNo lastRedstoneState;
    private class_1799 currentCell;
    private Map<IStorageChannel<?>, IMEInventory<?>> cachedInventories;

    public IOPortBlockEntity(class_2591<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.getProxy().setFlags(GridFlags.REQUIRE_CHANNEL);
        this.manager = new ConfigManager(this);
        this.manager.registerSetting(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
        this.manager.registerSetting(Settings.FULLNESS_MODE, (Enum)FullnessMode.EMPTY);
        this.manager.registerSetting(Settings.OPERATION_MODE, (Enum)OperationMode.EMPTY);
        this.mySrc = new MachineSource(this);
        this.lastRedstoneState = YesNo.UNDECIDED;
        class_2248 ioPortBlock = Api.instance().definitions().blocks().iOPort().maybeBlock().get();
        this.upgrades = new BlockUpgradeInventory(ioPortBlock, this, 3);
        this.inputCellsExt = this.inputCells.createLimitedFixedInv();
        this.inputCellsExt.getAllRule().disallowExtraction();
        this.outputCellsExt = this.outputCells.createLimitedFixedInv();
        this.outputCellsExt.getAllRule().disallowInsertion();
    }

    @Override
    public class_2487 method_11007(class_2487 data) {
        super.method_11007(data);
        this.manager.writeToNBT(data);
        this.upgrades.writeToNBT(data, "upgrades");
        data.method_10569("lastRedstoneState", this.lastRedstoneState.ordinal());
        return data;
    }

    @Override
    public void method_11014(class_2680 state, class_2487 data) {
        super.method_11014(state, data);
        this.manager.readFromNBT(data);
        this.upgrades.readFromNBT(data, "upgrades");
        if (data.method_10545("lastRedstoneState")) {
            this.lastRedstoneState = YesNo.values()[data.method_10550("lastRedstoneState")];
        }
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    private void updateTask() {
        try {
            if (this.hasWork()) {
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            } else {
                this.getProxy().getTick().sleepDevice(this.getProxy().getNode());
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public void updateRedstoneState() {
        YesNo currentState;
        YesNo yesNo = currentState = this.field_11863.method_8482(this.field_11867) != 0 ? YesNo.YES : YesNo.NO;
        if (this.lastRedstoneState != currentState) {
            this.lastRedstoneState = currentState;
            this.updateTask();
        }
    }

    private boolean getRedstoneState() {
        if (this.lastRedstoneState == YesNo.UNDECIDED) {
            this.updateRedstoneState();
        }
        return this.lastRedstoneState == YesNo.YES;
    }

    private boolean isEnabled() {
        if (this.getInstalledUpgrades(Upgrades.REDSTONE) == 0) {
            return true;
        }
        RedstoneMode rs = (RedstoneMode)this.manager.getSetting(Settings.REDSTONE_CONTROLLED);
        if (rs == RedstoneMode.HIGH_SIGNAL) {
            return this.getRedstoneState();
        }
        return !this.getRedstoneState();
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.manager;
    }

    @Override
    public FixedItemInv getInventoryByName(String name) {
        if (name.equals("upgrades")) {
            return this.upgrades;
        }
        if (name.equals("cells")) {
            return this.combinedInventory;
        }
        return null;
    }

    @Override
    public void updateSetting(IConfigManager manager, Settings settingName, Enum<?> newValue) {
        this.updateTask();
    }

    private boolean hasWork() {
        if (this.isEnabled()) {
            return !ItemHandlerUtil.isEmpty((FixedItemInv)this.inputCells);
        }
        return false;
    }

    @Override
    public FixedItemInv getInternalInventory() {
        return this.combinedInventory;
    }

    @Override
    public void onChangeInventory(FixedItemInv inv, int slot, InvOperation mc, class_1799 removed, class_1799 added) {
        if (this.inputCells == inv) {
            this.updateTask();
        }
    }

    @Override
    protected FixedItemInv getItemHandlerForSide(class_2350 facing) {
        if (facing == this.getUp() || facing == this.getUp().method_10153()) {
            return this.inputCellsExt;
        }
        return this.outputCellsExt;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.IOPort.getMin(), TickRates.IOPort.getMax(), !this.hasWork(), false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (!this.getProxy().isActive()) {
            return TickRateModulation.IDLE;
        }
        TickRateModulation ret = TickRateModulation.SLEEP;
        long itemsToMove = 256L;
        switch (this.getInstalledUpgrades(Upgrades.SPEED)) {
            case 1: {
                itemsToMove *= 2L;
                break;
            }
            case 2: {
                itemsToMove *= 4L;
                break;
            }
            case 3: {
                itemsToMove *= 8L;
            }
        }
        try {
            IEnergyGrid energy = this.getProxy().getEnergy();
            for (int x = 0; x < 6; ++x) {
                class_1799 is = this.inputCells.getInvStack(x);
                if (is.method_7960()) continue;
                boolean shouldMove = true;
                for (IStorageChannel<? extends IAEStack<?>> iStorageChannel : Api.instance().storage().storageChannels()) {
                    if (itemsToMove <= 0L) continue;
                    IMEMonitor<? extends IAEStack<?>> network = this.getProxy().getStorage().getInventory(iStorageChannel);
                    IMEInventory<?> inv = this.getInv(is, iStorageChannel);
                    if (inv == null) continue;
                    itemsToMove = this.manager.getSetting(Settings.OPERATION_MODE) == OperationMode.EMPTY ? this.transferContents(energy, inv, network, itemsToMove, iStorageChannel) : this.transferContents(energy, network, inv, itemsToMove, iStorageChannel);
                    shouldMove &= this.shouldMove(inv);
                    if (itemsToMove > 0L) {
                        ret = TickRateModulation.IDLE;
                        continue;
                    }
                    ret = TickRateModulation.URGENT;
                }
                ret = itemsToMove > 0L && shouldMove && this.moveSlot(x) ? TickRateModulation.URGENT : TickRateModulation.URGENT;
            }
        }
        catch (GridAccessException e) {
            ret = TickRateModulation.IDLE;
        }
        return ret;
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        return this.upgrades.getInstalledUpgrades(u);
    }

    private IMEInventory<?> getInv(class_1799 is, IStorageChannel<?> chan) {
        if (this.currentCell != is) {
            this.currentCell = is;
            this.cachedInventories = new IdentityHashMap();
            for (IStorageChannel<? extends IAEStack<?>> iStorageChannel : Api.instance().storage().storageChannels()) {
                this.cachedInventories.put(iStorageChannel, Api.instance().registries().cell().getCellInventory(is, null, iStorageChannel));
            }
        }
        return this.cachedInventories.get(chan);
    }

    private long transferContents(IEnergySource energy, IMEInventory src, IMEInventory destination, long itemsToMove, IStorageChannel chan) {
        boolean didStuff;
        IItemList myList = src instanceof IMEMonitor ? ((IMEMonitor)src).getStorageList() : src.getAvailableItems(src.getChannel().createList());
        itemsToMove *= (long)chan.transferFactor();
        block0: do {
            didStuff = false;
            for (IAEStack s : myList) {
                long totalStackSize = s.getStackSize();
                if (totalStackSize <= 0L) continue;
                IAEStack stack = destination.injectItems(s, Actionable.SIMULATE, this.mySrc);
                long possible = 0L;
                possible = stack == null ? totalStackSize : totalStackSize - stack.getStackSize();
                if (possible <= 0L) continue;
                possible = Math.min(possible, itemsToMove);
                s.setStackSize(possible);
                IAEStack extracted = src.extractItems(s, Actionable.MODULATE, this.mySrc);
                if (extracted == null) continue;
                possible = extracted.getStackSize();
                IAEStack failed = Platform.poweredInsert(energy, destination, extracted, this.mySrc);
                if (failed != null) {
                    possible -= failed.getStackSize();
                    src.injectItems(failed, Actionable.MODULATE, this.mySrc);
                }
                if (possible <= 0L) continue block0;
                itemsToMove -= possible;
                didStuff = true;
                continue block0;
            }
        } while (itemsToMove > 0L && didStuff);
        return itemsToMove / (long)chan.transferFactor();
    }

    private boolean shouldMove(IMEInventory<?> inv) {
        FullnessMode fm = (FullnessMode)this.manager.getSetting(Settings.FULLNESS_MODE);
        if (inv != null) {
            return this.matches(fm, inv);
        }
        return true;
    }

    private boolean moveSlot(int x) {
        AdaptorFixedInv ad = new AdaptorFixedInv((FixedItemInv)this.outputCells);
        if (((InventoryAdaptor)ad).addItems(this.inputCells.getInvStack(x)).method_7960()) {
            this.inputCells.setInvStack(x, class_1799.field_8037, Simulation.ACTION);
            return true;
        }
        return false;
    }

    private boolean matches(FullnessMode fm, IMEInventory src) {
        if (fm == FullnessMode.HALF) {
            return true;
        }
        IItemList myList = src instanceof IMEMonitor ? ((IMEMonitor)src).getStorageList() : src.getAvailableItems(src.getChannel().createList());
        if (fm == FullnessMode.EMPTY) {
            return myList.isEmpty();
        }
        Object test = myList.getFirstItem();
        if (test != null) {
            test.setStackSize(1L);
            return src.injectItems(test, Actionable.SIMULATE, this.mySrc) != null;
        }
        return false;
    }

    @Override
    public void getDrops(class_1937 w, class_2338 pos, List<class_1799> drops) {
        super.getDrops(w, pos, drops);
        for (int upgradeIndex = 0; upgradeIndex < this.upgrades.getSlotCount(); ++upgradeIndex) {
            class_1799 stackInSlot = this.upgrades.getInvStack(upgradeIndex);
            if (stackInSlot.method_7960()) continue;
            drops.add(stackInSlot);
        }
    }
}

