/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.config.SearchBoxMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.SortOrder;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IMaterials;
import appeng.api.features.AEFeature;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.implementations.items.IAEWrench;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.cells.ICellInventoryHandler;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.core.AppEng;
import appeng.core.stats.AeStats;
import appeng.fluids.util.AEFluidStack;
import appeng.hooks.TickHandler;
import appeng.integration.abstraction.ReiFacade;
import appeng.me.GridAccessException;
import appeng.me.GridNode;
import appeng.me.helpers.AENetworkProxy;
import appeng.util.BlockUpdate;
import appeng.util.LookDirection;
import appeng.util.helpers.ItemComparisonHelper;
import appeng.util.helpers.P2PHelper;
import appeng.util.item.AEItemStack;
import appeng.util.prioritylist.IPartitionList;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1715;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3966;

public class Platform {
    public static final int DEF_OFFSET = 16;
    private static final FabricLoader FABRIC = FabricLoader.getInstance();
    private static final boolean CLIENT_INSTALL = FABRIC.getEnvironmentType() == EnvType.CLIENT;
    private static final Random RANDOM_GENERATOR = new Random();
    private static final ItemComparisonHelper ITEM_COMPARISON_HELPER = new ItemComparisonHelper();
    private static final P2PHelper P2P_HELPER = new P2PHelper();

    public static ItemComparisonHelper itemComparisons() {
        return ITEM_COMPARISON_HELPER;
    }

    public static P2PHelper p2p() {
        return P2P_HELPER;
    }

    public static Random getRandom() {
        return RANDOM_GENERATOR;
    }

    public static float getRandomFloat() {
        return RANDOM_GENERATOR.nextFloat();
    }

    public static String formatPowerLong(long n, boolean isRate) {
        double p = (double)n / 100.0;
        PowerUnits displayUnits = AEConfig.instance().getSelectedPowerUnit();
        p = PowerUnits.AE.convertTo(displayUnits, p);
        String[] preFixes = new String[]{"k", "M", "G", "T", "P", "T", "P", "E", "Z", "Y"};
        String unitName = displayUnits.getSymbolName();
        String level = "";
        for (int offset = 0; p > 1000.0 && offset < preFixes.length; p /= 1000.0, ++offset) {
            level = preFixes[offset];
        }
        DecimalFormat df = new DecimalFormat("#.##");
        return df.format(p) + ' ' + level + unitName + (isRate ? "/t" : "");
    }

    public static class_2350 crossProduct(class_2350 forward, class_2350 up) {
        int west_x = forward.method_10164() * up.method_10165() - forward.method_10165() * up.method_10164();
        int west_y = forward.method_10165() * up.method_10148() - forward.method_10148() * up.method_10165();
        int west_z = forward.method_10148() * up.method_10164() - forward.method_10164() * up.method_10148();
        switch (west_x + west_y * 2 + west_z * 3) {
            case 1: {
                return class_2350.field_11034;
            }
            case -1: {
                return class_2350.field_11039;
            }
            case 2: {
                return class_2350.field_11036;
            }
            case -2: {
                return class_2350.field_11033;
            }
            case 3: {
                return class_2350.field_11035;
            }
            case -3: {
                return class_2350.field_11043;
            }
        }
        return class_2350.field_11043;
    }

    public static boolean hasClientClasses() {
        return FABRIC.getEnvironmentType() == EnvType.CLIENT;
    }

    public static boolean isClient() {
        return AppEng.instance() != null && !AppEng.instance().isOnServerThread();
    }

    public static boolean hasPermissions(DimensionalCoord dc, class_1657 player) {
        if (!dc.isInWorld((class_1936)player.field_6002)) {
            return false;
        }
        return player.field_6002.method_8505(player, dc.getPos());
    }

    public static boolean checkPermissions(class_1657 player, Object accessInterface, SecurityPermissions requiredPermission, boolean notifyPlayer) {
        IGrid g;
        IGridNode gn;
        if (requiredPermission != null && accessInterface instanceof IActionHost && (gn = ((IActionHost)accessInterface).getActionableNode()) != null && (g = gn.getGrid()) != null) {
            boolean requirePower = false;
            ISecurityGrid sg = (ISecurityGrid)g.getCache(ISecurityGrid.class);
            if (!sg.hasPermission(player, requiredPermission)) {
                player.method_9203((class_2561)new class_2588("appliedenergistics2.permission_denied").method_27692(class_124.field_1061), class_156.field_25140);
                return false;
            }
        }
        return true;
    }

    public static class_1799[] getBlockDrops(class_1937 w, class_2338 pos) {
        if (!(w instanceof class_3218)) {
            return new class_1799[0];
        }
        class_3218 serverWorld = (class_3218)w;
        class_2680 state = w.method_8320(pos);
        class_2586 tileEntity = w.method_8321(pos);
        List out = class_2248.method_9562((class_2680)state, (class_3218)serverWorld, (class_2338)pos, (class_2586)tileEntity);
        return out.toArray(new class_1799[0]);
    }

    public static void spawnDrops(class_1937 w, class_2338 pos, List<class_1799> drops) {
        if (Platform.isServer()) {
            for (class_1799 i : drops) {
                if (i.method_7960() || i.method_7947() <= 0) continue;
                double offset_x = (Platform.getRandomInt() % 32 - 16) / 82;
                double offset_y = (Platform.getRandomInt() % 32 - 16) / 82;
                double offset_z = (Platform.getRandomInt() % 32 - 16) / 82;
                class_1542 ei = new class_1542(w, 0.5 + offset_x + (double)pos.method_10263(), 0.5 + offset_y + (double)pos.method_10264(), 0.2 + offset_z + (double)pos.method_10260(), i.method_7972());
                w.method_8649((class_1297)ei);
            }
        }
    }

    public static boolean isServer() {
        return !Platform.isClient();
    }

    public static int getRandomInt() {
        return Math.abs(RANDOM_GENERATOR.nextInt());
    }

    @Environment(value=EnvType.CLIENT)
    public static List<class_2561> getTooltip(Object o) {
        if (o == null) {
            return Collections.emptyList();
        }
        class_1799 itemStack = class_1799.field_8037;
        if (o instanceof AEItemStack) {
            AEItemStack ais = (AEItemStack)o;
            return ais.getToolTip();
        }
        if (!(o instanceof class_1799)) {
            return Collections.emptyList();
        }
        itemStack = (class_1799)o;
        try {
            class_1836.class_1837 tooltipFlag = class_310.method_1551().field_1690.field_1827 ? class_1836.class_1837.field_8935 : class_1836.class_1837.field_8934;
            return itemStack.method_7950((class_1657)class_310.method_1551().field_1724, (class_1836)tooltipFlag);
        }
        catch (Exception errB) {
            return Collections.emptyList();
        }
    }

    public static String getModId(IAEItemStack is) {
        if (is == null) {
            return "** Null";
        }
        String n = ((AEItemStack)is).getModID();
        return n == null ? "** Null" : n;
    }

    public static String getModId(IAEFluidStack fs) {
        if (fs == null || fs.getFluidStack().isEmpty()) {
            return "** Null";
        }
        class_2960 n = class_2378.field_11154.method_10221((Object)fs.getFluidStack().getRawFluid());
        return n == class_2378.field_11154.method_10137() ? "** Null" : n.method_12836();
    }

    public static String getModName(String modId) {
        return "" + class_124.field_1078 + class_124.field_1056 + (String)FABRIC.getModContainer(modId).map(mc -> mc.getMetadata().getName()).orElse(null);
    }

    public static class_2561 getItemDisplayName(Object o) {
        if (o == null) {
            return new class_2585("** Null");
        }
        class_1799 itemStack = class_1799.field_8037;
        if (o instanceof AEItemStack) {
            class_2561 n = ((AEItemStack)o).getDisplayName();
            return n == null ? new class_2585("** Null") : n;
        }
        if (!(o instanceof class_1799)) {
            return new class_2585("**Invalid Object");
        }
        itemStack = (class_1799)o;
        try {
            return itemStack.method_7964();
        }
        catch (Exception errA) {
            try {
                return new class_2588(itemStack.method_7922());
            }
            catch (Exception errB) {
                return new class_2585("** Exception");
            }
        }
    }

    public static class_2561 getFluidDisplayName(Object o) {
        if (o == null) {
            return new class_2585("** Null");
        }
        FluidVolume fluidStack = null;
        if (o instanceof AEFluidStack) {
            fluidStack = ((AEFluidStack)o).getFluidStack();
        } else if (o instanceof FluidVolume) {
            fluidStack = (FluidVolume)o;
        } else {
            return new class_2585("**Invalid Object");
        }
        return fluidStack.getName();
    }

    public static boolean isWrench(class_1657 player, class_1799 eq, class_2338 pos) {
        if (!eq.method_7960() && eq.method_7909() instanceof IAEWrench) {
            IAEWrench wrench = (IAEWrench)eq.method_7909();
            return wrench.canWrench(eq, player, pos);
        }
        return false;
    }

    public static boolean isChargeable(class_1799 i) {
        if (i.method_7960()) {
            return false;
        }
        class_1792 it = i.method_7909();
        if (it instanceof IAEItemPowerStorage) {
            return ((IAEItemPowerStorage)it).getPowerFlow(i) != AccessRestriction.READ;
        }
        return false;
    }

    @Nullable
    public static <T> T pickRandom(Collection<T> outs) {
        if (outs.isEmpty()) {
            return null;
        }
        int index = RANDOM_GENERATOR.nextInt(outs.size());
        return (T)Iterables.get(outs, (int)index, null);
    }

    public static AEPartLocation rotateAround(AEPartLocation forward, AEPartLocation axis) {
        if (axis == AEPartLocation.INTERNAL || forward == AEPartLocation.INTERNAL) {
            return forward;
        }
        switch (forward) {
            case DOWN: {
                switch (axis) {
                    case DOWN: {
                        return forward;
                    }
                    case UP: {
                        return forward;
                    }
                    case NORTH: {
                        return AEPartLocation.EAST;
                    }
                    case SOUTH: {
                        return AEPartLocation.WEST;
                    }
                    case EAST: {
                        return AEPartLocation.NORTH;
                    }
                    case WEST: {
                        return AEPartLocation.SOUTH;
                    }
                }
                break;
            }
            case UP: {
                switch (axis) {
                    case NORTH: {
                        return AEPartLocation.WEST;
                    }
                    case SOUTH: {
                        return AEPartLocation.EAST;
                    }
                    case EAST: {
                        return AEPartLocation.SOUTH;
                    }
                    case WEST: {
                        return AEPartLocation.NORTH;
                    }
                }
                break;
            }
            case NORTH: {
                switch (axis) {
                    case UP: {
                        return AEPartLocation.WEST;
                    }
                    case DOWN: {
                        return AEPartLocation.EAST;
                    }
                    case EAST: {
                        return AEPartLocation.UP;
                    }
                    case WEST: {
                        return AEPartLocation.DOWN;
                    }
                }
                break;
            }
            case SOUTH: {
                switch (axis) {
                    case UP: {
                        return AEPartLocation.EAST;
                    }
                    case DOWN: {
                        return AEPartLocation.WEST;
                    }
                    case EAST: {
                        return AEPartLocation.DOWN;
                    }
                    case WEST: {
                        return AEPartLocation.UP;
                    }
                }
                break;
            }
            case EAST: {
                switch (axis) {
                    case UP: {
                        return AEPartLocation.NORTH;
                    }
                    case DOWN: {
                        return AEPartLocation.SOUTH;
                    }
                    case NORTH: {
                        return AEPartLocation.UP;
                    }
                    case SOUTH: {
                        return AEPartLocation.DOWN;
                    }
                }
            }
            case WEST: {
                switch (axis) {
                    case UP: {
                        return AEPartLocation.SOUTH;
                    }
                    case DOWN: {
                        return AEPartLocation.NORTH;
                    }
                    case NORTH: {
                        return AEPartLocation.DOWN;
                    }
                    case SOUTH: {
                        return AEPartLocation.UP;
                    }
                }
            }
        }
        return forward;
    }

    public static class_2350 rotateAround(class_2350 forward, class_2350 axis) {
        switch (forward) {
            case field_11033: {
                switch (axis) {
                    case field_11033: {
                        return forward;
                    }
                    case field_11036: {
                        return forward;
                    }
                    case field_11043: {
                        return class_2350.field_11034;
                    }
                    case field_11035: {
                        return class_2350.field_11039;
                    }
                    case field_11034: {
                        return class_2350.field_11043;
                    }
                    case field_11039: {
                        return class_2350.field_11035;
                    }
                }
                break;
            }
            case field_11036: {
                switch (axis) {
                    case field_11043: {
                        return class_2350.field_11039;
                    }
                    case field_11035: {
                        return class_2350.field_11034;
                    }
                    case field_11034: {
                        return class_2350.field_11035;
                    }
                    case field_11039: {
                        return class_2350.field_11043;
                    }
                }
                break;
            }
            case field_11043: {
                switch (axis) {
                    case field_11036: {
                        return class_2350.field_11039;
                    }
                    case field_11033: {
                        return class_2350.field_11034;
                    }
                    case field_11034: {
                        return class_2350.field_11036;
                    }
                    case field_11039: {
                        return class_2350.field_11033;
                    }
                }
                break;
            }
            case field_11035: {
                switch (axis) {
                    case field_11036: {
                        return class_2350.field_11034;
                    }
                    case field_11033: {
                        return class_2350.field_11039;
                    }
                    case field_11034: {
                        return class_2350.field_11033;
                    }
                    case field_11039: {
                        return class_2350.field_11036;
                    }
                }
                break;
            }
            case field_11034: {
                switch (axis) {
                    case field_11036: {
                        return class_2350.field_11043;
                    }
                    case field_11033: {
                        return class_2350.field_11035;
                    }
                    case field_11043: {
                        return class_2350.field_11036;
                    }
                    case field_11035: {
                        return class_2350.field_11033;
                    }
                }
            }
            case field_11039: {
                switch (axis) {
                    case field_11036: {
                        return class_2350.field_11035;
                    }
                    case field_11033: {
                        return class_2350.field_11043;
                    }
                    case field_11043: {
                        return class_2350.field_11033;
                    }
                    case field_11035: {
                        return class_2350.field_11036;
                    }
                }
            }
        }
        return forward;
    }

    public static LookDirection getPlayerRay(class_1657 playerIn) {
        double reachDistance = 36.0;
        return Platform.getPlayerRay(playerIn, reachDistance);
    }

    public static LookDirection getPlayerRay(class_1657 playerIn, double reachDistance) {
        double x = playerIn.field_6014 + (playerIn.method_23317() - playerIn.field_6014);
        double y = playerIn.field_6036 + (playerIn.method_23318() - playerIn.field_6036) + (double)playerIn.method_5751();
        double z = playerIn.field_5969 + (playerIn.method_23321() - playerIn.field_5969);
        float playerPitch = playerIn.field_6004 + (playerIn.field_5965 - playerIn.field_6004);
        float playerYaw = playerIn.field_5982 + (playerIn.field_6031 - playerIn.field_5982);
        float yawRayX = class_3532.method_15374((float)(-playerYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float yawRayZ = class_3532.method_15362((float)(-playerYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float pitchMultiplier = -class_3532.method_15362((float)(-playerPitch * ((float)Math.PI / 180)));
        float eyeRayY = class_3532.method_15374((float)(-playerPitch * ((float)Math.PI / 180)));
        float eyeRayX = yawRayX * pitchMultiplier;
        float eyeRayZ = yawRayZ * pitchMultiplier;
        class_243 from = new class_243(x, y, z);
        class_243 to = from.method_1031((double)eyeRayX * reachDistance, (double)eyeRayY * reachDistance, (double)eyeRayZ * reachDistance);
        return new LookDirection(from, to);
    }

    public static class_239 rayTrace(class_1657 p, boolean hitBlocks, boolean hitEntities) {
        class_1937 w = p.method_5770();
        float f = 1.0f;
        float f1 = p.field_6004 + (p.field_5965 - p.field_6004) * 1.0f;
        float f2 = p.field_5982 + (p.field_6031 - p.field_5982) * 1.0f;
        double d0 = p.field_6014 + (p.method_23317() - p.field_6014) * 1.0;
        double d1 = p.field_6036 + (p.method_23318() - p.field_6036) * 1.0 + 1.62 - p.method_5678();
        double d2 = p.field_5969 + (p.method_23321() - p.field_5969) * 1.0;
        class_243 vec3 = new class_243(d0, d1, d2);
        float f3 = class_3532.method_15362((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = class_3532.method_15374((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -class_3532.method_15362((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = class_3532.method_15374((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = 32.0;
        class_243 vec31 = vec3.method_1031((double)f7 * 32.0, (double)f6 * 32.0, (double)f8 * 32.0);
        class_238 bb = new class_238(Math.min(vec3.field_1352, vec31.field_1352), Math.min(vec3.field_1351, vec31.field_1351), Math.min(vec3.field_1350, vec31.field_1350), Math.max(vec3.field_1352, vec31.field_1352), Math.max(vec3.field_1351, vec31.field_1351), Math.max(vec3.field_1350, vec31.field_1350)).method_1009(16.0, 16.0, 16.0);
        class_1297 entity = null;
        double closest = 9999999.0;
        if (hitEntities) {
            List list = w.method_8335((class_1297)p, bb);
            for (class_1297 entity1 : list) {
                double nd;
                if (!entity1.method_5805() || entity1 == p || entity1 instanceof class_1542 || entity1.method_5794((class_1297)p)) continue;
                f1 = 0.3f;
                class_238 boundingBox = entity1.method_5829().method_1009((double)f1, (double)f1, (double)f1);
                class_243 rtResult = boundingBox.method_992(vec3, vec31).orElse(null);
                if (rtResult == null || !((nd = vec3.method_1025(rtResult)) < closest)) continue;
                entity = entity1;
                closest = nd;
            }
        }
        class_3966 pos = null;
        class_243 vec = null;
        if (hitBlocks) {
            vec = new class_243(d0, d1, d2);
            pos = w.method_17742(new class_3959(vec3, vec31, class_3959.class_3960.field_17558, class_3959.class_242.field_1347, (class_1297)p));
        }
        if (entity != null && pos != null && pos.method_17784().method_1025(vec) > closest) {
            pos = new class_3966(entity);
        } else if (entity != null && pos == null) {
            pos = new class_3966(entity);
        }
        return pos;
    }

    public static <T extends IAEStack<T>> T poweredExtraction(IEnergySource energy, IMEInventory<T> cell, T request, IActionSource src) {
        return Platform.poweredExtraction(energy, cell, request, src, Actionable.MODULATE);
    }

    public static <T extends IAEStack<T>> T poweredExtraction(IEnergySource energy, IMEInventory<T> cell, T request, IActionSource src, Actionable mode) {
        double energyFactor;
        double availablePower;
        long itemToExtract;
        Preconditions.checkNotNull((Object)energy);
        Preconditions.checkNotNull(cell);
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull((Object)src);
        Preconditions.checkNotNull((Object)((Object)mode));
        T possible = cell.extractItems(request.copy(), Actionable.SIMULATE, src);
        long retrieved = 0L;
        if (possible != null) {
            retrieved = possible.getStackSize();
        }
        if ((itemToExtract = Math.min((long)((availablePower = energy.extractAEPower((double)retrieved / (energyFactor = Math.max(1.0, (double)cell.getChannel().transferFactor())), Actionable.SIMULATE, PowerMultiplier.CONFIG)) * energyFactor + 0.9), retrieved)) > 0L) {
            if (mode == Actionable.MODULATE) {
                energy.extractAEPower((double)retrieved / energyFactor, Actionable.MODULATE, PowerMultiplier.CONFIG);
                possible.setStackSize(itemToExtract);
                Object ret = cell.extractItems(possible, Actionable.MODULATE, src);
                if (ret != null) {
                    src.player().ifPresent(player -> AeStats.ItemsExtracted.addToPlayer((class_1657)player, (int)ret.getStackSize()));
                }
                return ret;
            }
            return possible.setStackSize(itemToExtract);
        }
        return null;
    }

    public static <T extends IAEStack<T>> T poweredInsert(IEnergySource energy, IMEInventory<T> cell, T input, IActionSource src) {
        return Platform.poweredInsert(energy, cell, input, src, Actionable.MODULATE);
    }

    public static <T extends IAEStack<T>> T poweredInsert(IEnergySource energy, IMEInventory<T> cell, T input, IActionSource src, Actionable mode) {
        double energyFactor;
        double availablePower;
        long itemToAdd;
        Preconditions.checkNotNull((Object)energy);
        Preconditions.checkNotNull(cell);
        Preconditions.checkNotNull(input);
        Preconditions.checkNotNull((Object)src);
        Preconditions.checkNotNull((Object)((Object)mode));
        T overflow = cell.injectItems(input.copy(), Actionable.SIMULATE, src);
        long transferAmount = input.getStackSize();
        if (overflow != null) {
            transferAmount -= overflow.getStackSize();
        }
        if ((itemToAdd = Math.min((long)((availablePower = energy.extractAEPower((double)transferAmount / (energyFactor = Math.max(1.0, (double)cell.getChannel().transferFactor())), Actionable.SIMULATE, PowerMultiplier.CONFIG)) * energyFactor + 0.9), transferAmount)) > 0L) {
            if (mode == Actionable.MODULATE) {
                energy.extractAEPower((double)transferAmount / energyFactor, Actionable.MODULATE, PowerMultiplier.CONFIG);
                if (itemToAdd < input.getStackSize()) {
                    long original = input.getStackSize();
                    Object leftover = input.copy();
                    T split = input.copy();
                    leftover.decStackSize(itemToAdd);
                    split.setStackSize(itemToAdd);
                    leftover.add(cell.injectItems(split, Actionable.MODULATE, src));
                    src.player().ifPresent(player -> {
                        long diff = original - leftover.getStackSize();
                        AeStats.ItemsInserted.addToPlayer((class_1657)player, (int)diff);
                    });
                    return leftover;
                }
                Object ret = cell.injectItems(input, Actionable.MODULATE, src);
                src.player().ifPresent(player -> {
                    long diff = ret == null ? input.getStackSize() : input.getStackSize() - ret.getStackSize();
                    AeStats.ItemsInserted.addToPlayer((class_1657)player, (int)diff);
                });
                return ret;
            }
            T ret = input.copy().setStackSize(input.getStackSize() - itemToAdd);
            return ret != null && ret.getStackSize() > 0L ? (T)ret : null;
        }
        return input;
    }

    public static void postChanges(IStorageGrid gs, class_1799 removed, class_1799 added, IActionSource src) {
        for (IStorageChannel<IAEStack<?>> chan : Api.instance().storage().storageChannels()) {
            ICellInventoryHandler<IAEStack<?>> myInv;
            IItemList<IAEStack<?>> myChanges = chan.createList();
            if (!removed.method_7960() && (myInv = Api.instance().registries().cell().getCellInventory(removed, null, chan)) != null) {
                myInv.getAvailableItems(myChanges);
                for (IAEStack<?> is : myChanges) {
                    is.setStackSize(-is.getStackSize());
                }
            }
            if (!added.method_7960() && (myInv = Api.instance().registries().cell().getCellInventory(added, null, chan)) != null) {
                myInv.getAvailableItems(myChanges);
            }
            gs.postAlterationOfStoredItems(chan, myChanges, src);
        }
    }

    public static <T extends IAEStack<T>> void postListChanges(IItemList<T> before, IItemList<T> after, IMEMonitorHandlerReceiver<T> meMonitorPassthrough, IActionSource source) {
        ArrayList<IAEStack> changes = new ArrayList<IAEStack>();
        for (IAEStack is : before) {
            is.setStackSize(-is.getStackSize());
        }
        for (IAEStack is : after) {
            before.add(is);
        }
        for (IAEStack is : before) {
            if (is.getStackSize() == 0L) continue;
            changes.add(is);
        }
        if (!changes.isEmpty()) {
            meMonitorPassthrough.postChange(null, changes, source);
        }
    }

    public static boolean securityCheck(GridNode a, GridNode b) {
        boolean b_isSecure;
        if (a.getLastSecurityKey() == -1L && b.getLastSecurityKey() == -1L) {
            return true;
        }
        if (a.getLastSecurityKey() == b.getLastSecurityKey()) {
            return true;
        }
        boolean a_isSecure = Platform.isPowered(a.getGrid()) && a.getLastSecurityKey() != -1L;
        boolean bl = b_isSecure = Platform.isPowered(b.getGrid()) && b.getLastSecurityKey() != -1L;
        if (AEConfig.instance().isFeatureEnabled(AEFeature.LOG_SECURITY_AUDITS)) {
            String locationA = a.getGridBlock().isWorldAccessible() ? a.getGridBlock().getLocation().toString() : "notInWorld";
            String locationB = b.getGridBlock().isWorldAccessible() ? b.getGridBlock().getLocation().toString() : "notInWorld";
            AELog.info("Audit: Node A [isSecure=%b, key=%d, playerID=%d, location={%s}] vs Node B[isSecure=%b, key=%d, playerID=%d, location={%s}]", a_isSecure, a.getLastSecurityKey(), a.getPlayerID(), locationA, b_isSecure, b.getLastSecurityKey(), b.getPlayerID(), locationB);
        }
        if (a_isSecure && b_isSecure) {
            return false;
        }
        if (!a_isSecure && b_isSecure) {
            return Platform.checkPlayerPermissions(b.getGrid(), a.getPlayerID());
        }
        if (a_isSecure && !b_isSecure) {
            return Platform.checkPlayerPermissions(a.getGrid(), b.getPlayerID());
        }
        return true;
    }

    private static boolean isPowered(IGrid grid) {
        if (grid == null) {
            return false;
        }
        IEnergyGrid eg = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
        return eg.isNetworkPowered();
    }

    private static boolean checkPlayerPermissions(IGrid grid, int playerID) {
        if (grid == null) {
            return true;
        }
        ISecurityGrid gs = (ISecurityGrid)grid.getCache(ISecurityGrid.class);
        if (gs == null) {
            return true;
        }
        if (!gs.isAvailable()) {
            return true;
        }
        return gs.hasPermission(playerID, SecurityPermissions.BUILD);
    }

    public static void configurePlayer(class_1657 player, AEPartLocation side, class_2586 tile) {
        float pitch = 0.0f;
        float yaw = 0.0f;
        switch (side) {
            case DOWN: {
                pitch = 90.0f;
                break;
            }
            case EAST: {
                yaw = -90.0f;
                break;
            }
            case NORTH: {
                yaw = 180.0f;
                break;
            }
            case SOUTH: {
                yaw = 0.0f;
                break;
            }
            case INTERNAL: {
                break;
            }
            case UP: {
                pitch = 90.0f;
                break;
            }
            case WEST: {
                yaw = 90.0f;
            }
        }
        player.method_5808((double)tile.method_11016().method_10263() + 0.5, (double)tile.method_11016().method_10264() + 0.5, (double)tile.method_11016().method_10260() + 0.5, yaw, pitch);
    }

    public static boolean canAccess(AENetworkProxy gridProxy, IActionSource src) {
        try {
            if (src.player().isPresent()) {
                return gridProxy.getSecurity().hasPermission(src.player().get(), SecurityPermissions.BUILD);
            }
            if (src.machine().isPresent()) {
                IActionHost te = src.machine().get();
                IGridNode n = te.getActionableNode();
                if (n == null) {
                    return false;
                }
                int playerID = n.getPlayerID();
                return gridProxy.getSecurity().hasPermission(playerID, SecurityPermissions.BUILD);
            }
            return false;
        }
        catch (GridAccessException gae) {
            return false;
        }
    }

    public static class_1799 extractItemsByRecipe(IEnergySource energySrc, IActionSource mySrc, IMEMonitor<IAEItemStack> src, class_1937 w, class_1860<class_1715> r, class_1799 output, class_1715 ci, class_1799 providedTemplate, int slot, IItemList<IAEItemStack> items, Actionable realForFake, IPartitionList<IAEItemStack> filter) {
        if (energySrc.extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.9) {
            boolean checkFuzzy;
            class_1799 extracted;
            IAEItemStack ae_ext;
            if (providedTemplate == null) {
                return class_1799.field_8037;
            }
            AEItemStack ae_req = AEItemStack.fromItemStack(providedTemplate);
            ae_req.setStackSize(1L);
            if ((filter == null || filter.isListed(ae_req)) && (ae_ext = src.extractItems(ae_req, realForFake, mySrc)) != null && !(extracted = ae_ext.createItemStack()).method_7960()) {
                energySrc.extractAEPower(1.0, realForFake, PowerMultiplier.CONFIG);
                return extracted;
            }
            boolean bl = checkFuzzy = providedTemplate.method_7985() || providedTemplate.method_7963();
            if (items != null && checkFuzzy) {
                for (IAEItemStack x : items) {
                    class_1799 sh = x.getDefinition();
                    if (!Platform.itemComparisons().isEqualItemType(providedTemplate, sh) || class_1799.method_7987((class_1799)sh, (class_1799)output)) continue;
                    class_1799 cp = sh.method_7972();
                    cp.method_7939(1);
                    ci.method_5447(slot, cp);
                    if (r.method_8115((class_1263)ci, w) && class_1799.method_7987((class_1799)r.method_8116((class_1263)ci), (class_1799)output)) {
                        IAEItemStack ex;
                        IAEItemStack ax = x.copy();
                        ax.setStackSize(1L);
                        if ((filter == null || filter.isListed(ax)) && (ex = src.extractItems(ax, realForFake, mySrc)) != null) {
                            energySrc.extractAEPower(1.0, realForFake, PowerMultiplier.CONFIG);
                            return ex.createItemStack();
                        }
                    }
                    ci.method_5447(slot, providedTemplate);
                }
            }
        }
        return class_1799.field_8037;
    }

    public static class_1799 getRecipeRemainder(class_1799 stackInSlot) {
        if (stackInSlot == null) {
            return class_1799.field_8037;
        }
        class_1792 i = stackInSlot.method_7909();
        if (i == null || !i.method_7857()) {
            if (stackInSlot.method_7947() > 1) {
                stackInSlot.method_7939(stackInSlot.method_7947() - 1);
                return stackInSlot;
            }
            return class_1799.field_8037;
        }
        class_1799 ci = new class_1799((class_1935)i.method_7858());
        if (!ci.method_7960() && ci.method_7963() && ci.method_7919() == ci.method_7936()) {
            ci = class_1799.field_8037;
        }
        return ci;
    }

    public static void notifyBlocksOfNeighbors(class_1937 world, class_2338 pos) {
        if (!world.field_9236) {
            TickHandler.instance().addCallable((class_1936)world, new BlockUpdate(pos));
        }
    }

    public static boolean canRepair(AEFeature type, class_1799 a, class_1799 b) {
        if (b.method_7960() || a.method_7960()) {
            return false;
        }
        if (type == AEFeature.CERTUS_QUARTZ_TOOLS) {
            IItemDefinition certusQuartzCrystal = Api.instance().definitions().materials().certusQuartzCrystal();
            return certusQuartzCrystal.isSameAs(b);
        }
        if (type == AEFeature.NETHER_QUARTZ_TOOLS) {
            return class_1802.field_8155 == b.method_7909();
        }
        return false;
    }

    public static float getEyeOffset(class_1657 player) {
        assert (player.field_6002.field_9236) : "Valid only on client";
        return (float)player.method_23320() - 1.62f;
    }

    public static boolean isRecipePrioritized(class_1799 what) {
        IMaterials materials = Api.instance().definitions().materials();
        boolean isPurified = materials.purifiedCertusQuartzCrystal().isSameAs(what);
        isPurified |= materials.purifiedFluixCrystal().isSameAs(what);
        return isPurified |= materials.purifiedNetherQuartzCrystal().isSameAs(what);
    }

    public static boolean isSortOrderAvailable(SortOrder order) {
        return true;
    }

    public static boolean isSearchModeAvailable(SearchBoxMode mode) {
        if (mode.isRequiresJei()) {
            return ReiFacade.instance().isEnabled();
        }
        return true;
    }

    public static class_1799 copyStackWithSize(class_1799 stack, int size) {
        if (!stack.method_7960() && size > 0) {
            class_1799 copy = stack.method_7972();
            copy.method_7939(size);
            return copy;
        }
        return class_1799.field_8037;
    }

    public static boolean canStack(class_1799 a, class_1799 b) {
        return Platform.itemComparisons().isSameItem(a, b);
    }
}

