/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.item.FixedItemInv;
import alexiil.mc.lib.attributes.item.ItemTransferable;
import alexiil.mc.lib.attributes.item.filter.ItemFilter;
import appeng.api.config.FuzzyMode;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.ItemHandlerIterator;
import appeng.util.inv.ItemSlot;
import java.util.Iterator;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

public class AdaptorFixedInv
extends InventoryAdaptor {
    protected final FixedItemInv itemHandler;
    protected final ItemTransferable transferable;

    public AdaptorFixedInv(FixedItemInv itemHandler) {
        this.itemHandler = itemHandler;
        this.transferable = itemHandler.getTransferable();
    }

    @Override
    public boolean hasSlots() {
        return this.itemHandler.getSlotCount() > 0;
    }

    @Override
    public class_1799 removeItems(int amount, class_1799 filter, IInventoryDestination destination) {
        ItemFilter itemFilter = this.createExactFilter(filter, destination);
        return this.transferable.attemptExtraction(itemFilter, amount, Simulation.ACTION);
    }

    @Override
    public class_1799 simulateRemove(int amount, class_1799 filter, IInventoryDestination destination) {
        ItemFilter itemFilter = this.createExactFilter(filter, destination);
        return this.transferable.attemptExtraction(itemFilter, amount, Simulation.SIMULATE);
    }

    @NotNull
    private ItemFilter createExactFilter(class_1799 filter, IInventoryDestination destination) {
        ItemFilter itemFilter;
        ItemFilter itemFilter2 = destination != null ? destination::canInsert : (itemFilter = stack -> true);
        if (!filter.method_7960()) {
            itemFilter = destination != null ? stack -> Platform.itemComparisons().isSameItem(stack, filter) && destination.canInsert(stack) : stack -> Platform.itemComparisons().isSameItem(stack, filter);
        }
        return itemFilter;
    }

    @NotNull
    private ItemFilter createFuzzyFilter(class_1799 filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        ItemFilter itemFilter;
        ItemFilter itemFilter2 = destination != null ? destination::canInsert : (itemFilter = stack -> true);
        if (!filter.method_7960()) {
            itemFilter = destination != null ? stack -> Platform.itemComparisons().isFuzzyEqualItem(stack, filter, fuzzyMode) && destination.canInsert(stack) : stack -> Platform.itemComparisons().isFuzzyEqualItem(stack, filter, fuzzyMode);
        }
        return itemFilter;
    }

    @Override
    public class_1799 removeSimilarItems(int amount, class_1799 filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        ItemFilter itemFilter = this.createFuzzyFilter(filter, fuzzyMode, destination);
        return this.transferable.attemptExtraction(itemFilter, amount, Simulation.ACTION);
    }

    @Override
    public class_1799 simulateSimilarRemove(int amount, class_1799 filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        ItemFilter itemFilter = this.createFuzzyFilter(filter, fuzzyMode, destination);
        return this.transferable.attemptExtraction(itemFilter, amount, Simulation.SIMULATE);
    }

    @Override
    public class_1799 addItems(class_1799 toBeAdded) {
        return this.addItems(toBeAdded, false);
    }

    @Override
    public class_1799 simulateAdd(class_1799 toBeSimulated) {
        return this.addItems(toBeSimulated, true);
    }

    protected class_1799 addItems(class_1799 itemsToAdd, boolean simulate) {
        if (itemsToAdd.method_7960()) {
            return class_1799.field_8037;
        }
        return this.transferable.attemptInsertion(itemsToAdd, simulate ? Simulation.SIMULATE : Simulation.ACTION);
    }

    @Override
    public boolean containsItems() {
        return !this.transferable.attemptAnyExtraction(1, Simulation.SIMULATE).method_7960();
    }

    @Override
    public Iterator<ItemSlot> iterator() {
        return new ItemHandlerIterator(this.itemHandler);
    }
}

