/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.core.Api;
import appeng.util.InventoryAdaptor;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.IMEAdaptorIterator;
import appeng.util.inv.ItemSlot;
import appeng.util.item.AEItemStack;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import net.minecraft.class_1799;

public class IMEAdaptor
extends InventoryAdaptor {
    private final IMEInventory<IAEItemStack> target;
    private final IActionSource src;
    private int maxSlots = 0;

    public IMEAdaptor(IMEInventory<IAEItemStack> input, IActionSource src) {
        this.target = input;
        this.src = src;
    }

    @Override
    public boolean hasSlots() {
        return true;
    }

    @Override
    public Iterator<ItemSlot> iterator() {
        return new IMEAdaptorIterator(this, this.getList());
    }

    private IItemList<IAEItemStack> getList() {
        return this.target.getAvailableItems(Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList());
    }

    @Override
    public class_1799 removeItems(int amount, class_1799 filter, IInventoryDestination destination) {
        return this.doRemoveItems(amount, filter, destination, Actionable.MODULATE);
    }

    private class_1799 doRemoveItems(int amount, class_1799 filter, IInventoryDestination destination, Actionable type) {
        IAEItemStack req = null;
        if (filter.method_7960()) {
            IItemList<IAEItemStack> list = this.getList();
            if (!list.isEmpty()) {
                req = list.getFirstItem();
            }
        } else {
            req = AEItemStack.fromItemStack(filter);
        }
        IAEItemStack out = null;
        if (req != null) {
            req.setStackSize(amount);
            out = this.target.extractItems(req, type, this.src);
        }
        if (out != null) {
            return out.createItemStack();
        }
        return class_1799.field_8037;
    }

    @Override
    public class_1799 simulateRemove(int amount, class_1799 filter, IInventoryDestination destination) {
        return this.doRemoveItems(amount, filter, destination, Actionable.SIMULATE);
    }

    @Override
    public class_1799 removeSimilarItems(int amount, class_1799 filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        if (filter.method_7960()) {
            return this.doRemoveItems(amount, null, destination, Actionable.MODULATE);
        }
        return this.doRemoveItemsFuzzy(amount, filter, destination, Actionable.MODULATE, fuzzyMode);
    }

    private class_1799 doRemoveItemsFuzzy(int amount, class_1799 filter, IInventoryDestination destination, Actionable type, FuzzyMode fuzzyMode) {
        AEItemStack reqFilter = AEItemStack.fromItemStack(filter);
        if (reqFilter == null) {
            return class_1799.field_8037;
        }
        IAEItemStack out = null;
        for (IAEItemStack req : ImmutableList.copyOf(this.getList().findFuzzy(reqFilter, fuzzyMode))) {
            if (req == null) continue;
            req.setStackSize(amount);
            out = this.target.extractItems(req, type, this.src);
            if (out == null) continue;
            return out.createItemStack();
        }
        return class_1799.field_8037;
    }

    @Override
    public class_1799 simulateSimilarRemove(int amount, class_1799 filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        if (filter.method_7960()) {
            return this.doRemoveItems(amount, class_1799.field_8037, destination, Actionable.SIMULATE);
        }
        return this.doRemoveItemsFuzzy(amount, filter, destination, Actionable.SIMULATE, fuzzyMode);
    }

    @Override
    public class_1799 addItems(class_1799 toBeAdded) {
        IAEItemStack out;
        AEItemStack in = AEItemStack.fromItemStack(toBeAdded);
        if (in != null && (out = this.target.injectItems(in, Actionable.MODULATE, this.src)) != null) {
            return out.createItemStack();
        }
        return class_1799.field_8037;
    }

    @Override
    public class_1799 simulateAdd(class_1799 toBeSimulated) {
        IAEItemStack out;
        AEItemStack in = AEItemStack.fromItemStack(toBeSimulated);
        if (in != null && (out = this.target.injectItems(in, Actionable.SIMULATE, this.src)) != null) {
            return out.createItemStack();
        }
        return class_1799.field_8037;
    }

    @Override
    public boolean containsItems() {
        return !this.getList().isEmpty();
    }

    int getMaxSlots() {
        return this.maxSlots;
    }

    void setMaxSlots(int maxSlots) {
        this.maxSlots = maxSlots;
    }
}

