/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.Api;
import appeng.util.Platform;
import appeng.util.item.AEItemStackRegistry;
import appeng.util.item.AESharedItemStack;
import appeng.util.item.AEStack;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;

public final class AEItemStack
extends AEStack<IAEItemStack>
implements IAEItemStack {
    private static final String NBT_STACKSIZE = "cnt";
    private static final String NBT_REQUESTABLE = "req";
    private static final String NBT_CRAFTABLE = "craft";
    private static final String NBT_ITEMSTACK = "is";
    private final AESharedItemStack sharedStack;
    @Environment(value=EnvType.CLIENT)
    private class_2561 displayName;
    @Environment(value=EnvType.CLIENT)
    private List<class_2561> tooltip;

    private AEItemStack(AEItemStack is) {
        this.setStackSize(is.getStackSize());
        this.setCraftable(is.isCraftable());
        this.setCountRequestable(is.getCountRequestable());
        this.sharedStack = is.sharedStack;
    }

    private AEItemStack(AESharedItemStack is, long size) {
        this.sharedStack = is;
        this.setStackSize(size);
        this.setCraftable(false);
        this.setCountRequestable(0L);
    }

    @Nullable
    public static AEItemStack fromItemStack(@Nonnull class_1799 stack) {
        if (stack.method_7960()) {
            return null;
        }
        return new AEItemStack(AEItemStackRegistry.getRegisteredStack(stack), stack.method_7947());
    }

    public static IAEItemStack fromNBT(class_2487 i) {
        if (i == null) {
            return null;
        }
        class_1799 itemstack = class_1799.method_7915((class_2487)i.method_10562(NBT_ITEMSTACK));
        if (itemstack.method_7960()) {
            return null;
        }
        AEItemStack item = AEItemStack.fromItemStack(itemstack);
        item.setStackSize(i.method_10537(NBT_STACKSIZE));
        item.setCountRequestable(i.method_10537(NBT_REQUESTABLE));
        item.setCraftable(i.method_10577(NBT_CRAFTABLE));
        return item;
    }

    @Override
    public void writeToNBT(class_2487 i) {
        class_2487 itemStack = new class_2487();
        this.getDefinition().method_7953(itemStack);
        i.method_10566(NBT_ITEMSTACK, (class_2520)itemStack);
        i.method_10544(NBT_STACKSIZE, this.getStackSize());
        i.method_10544(NBT_REQUESTABLE, this.getCountRequestable());
        i.method_10556(NBT_CRAFTABLE, this.isCraftable());
    }

    public static AEItemStack fromPacket(class_2540 buffer) {
        boolean isCraftable = buffer.readBoolean();
        long stackSize = buffer.method_10792();
        long countRequestable = buffer.method_10792();
        class_1799 itemstack = buffer.method_10819();
        if (itemstack.method_7960()) {
            return null;
        }
        AEItemStack item = new AEItemStack(AEItemStackRegistry.getRegisteredStack(itemstack), stackSize);
        item.setCountRequestable(countRequestable);
        item.setCraftable(isCraftable);
        return item;
    }

    @Override
    public void writeToPacket(class_2540 buffer) {
        buffer.writeBoolean(this.isCraftable());
        buffer.method_10791(this.getStackSize());
        buffer.method_10791(this.getCountRequestable());
        buffer.method_10793(this.getDefinition());
    }

    @Override
    public void add(IAEItemStack option) {
        if (option == null) {
            return;
        }
        this.incStackSize(option.getStackSize());
        this.setCountRequestable(this.getCountRequestable() + option.getCountRequestable());
        this.setCraftable(this.isCraftable() || option.isCraftable());
    }

    @Override
    public boolean fuzzyComparison(IAEItemStack other, FuzzyMode mode) {
        class_1799 itemStack = this.getDefinition();
        class_1799 otherStack = other.getDefinition();
        return this.fuzzyItemStackComparison(itemStack, otherStack, mode);
    }

    @Override
    public IAEItemStack copy() {
        return new AEItemStack(this);
    }

    @Override
    public IStorageChannel<IAEItemStack> getChannel() {
        return Api.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    @Override
    public class_1799 createItemStack() {
        return Platform.copyStackWithSize(this.getDefinition(), (int)Math.min(Integer.MAX_VALUE, this.getStackSize()));
    }

    @Override
    public class_1792 getItem() {
        return this.getDefinition().method_7909();
    }

    @Override
    public int getItemDamage() {
        return this.sharedStack.getItemDamage();
    }

    @Override
    public boolean isSameType(IAEItemStack otherStack) {
        if (otherStack == null) {
            return false;
        }
        return Objects.equals(this.sharedStack, ((AEItemStack)otherStack).sharedStack);
    }

    @Override
    public boolean isSameType(class_1799 otherStack) {
        if (otherStack.method_7960()) {
            return false;
        }
        int oldSize = otherStack.method_7947();
        otherStack.method_7939(1);
        boolean ret = class_1799.method_7973((class_1799)this.getDefinition(), (class_1799)otherStack);
        otherStack.method_7939(oldSize);
        return ret;
    }

    public int hashCode() {
        return this.sharedStack.hashCode();
    }

    @Override
    public boolean equals(Object ia) {
        if (ia instanceof AEItemStack) {
            return this.isSameType((AEItemStack)ia);
        }
        if (ia instanceof class_1799) {
            return this.equals((class_1799)ia);
        }
        return false;
    }

    @Override
    public boolean equals(class_1799 is) {
        return this.isSameType(is);
    }

    public String toString() {
        return this.getStackSize() + "x" + class_2378.field_11142.method_10221((Object)this.getDefinition().method_7909());
    }

    @Environment(value=EnvType.CLIENT)
    public List<class_2561> getToolTip() {
        if (this.tooltip == null) {
            this.tooltip = Platform.getTooltip(this.asItemStackRepresentation());
        }
        return this.tooltip;
    }

    @Environment(value=EnvType.CLIENT)
    public class_2561 getDisplayName() {
        if (this.displayName == null) {
            this.displayName = Platform.getItemDisplayName(this.asItemStackRepresentation());
        }
        return this.displayName;
    }

    @Environment(value=EnvType.CLIENT)
    public String getModID() {
        return class_2378.field_11142.method_10221((Object)this.getDefinition().method_7909()).method_12836();
    }

    @Override
    public boolean hasTagCompound() {
        return this.getDefinition().method_7985();
    }

    @Override
    public class_1799 asItemStackRepresentation() {
        return this.getDefinition().method_7972();
    }

    @Override
    public class_1799 getDefinition() {
        return this.sharedStack.getDefinition();
    }

    AESharedItemStack getSharedStack() {
        return this.sharedStack;
    }

    private boolean fuzzyItemStackComparison(class_1799 a, class_1799 b, FuzzyMode mode) {
        if (a.method_7909() == b.method_7909() && a.method_7909().method_7846()) {
            if (mode == FuzzyMode.IGNORE_ALL) {
                return true;
            }
            if (mode == FuzzyMode.PERCENT_99) {
                return a.method_7919() > 1 == b.method_7919() > 1;
            }
            float percentDamageOfA = (float)a.method_7919() / (float)a.method_7936();
            float percentDamageOfB = (float)b.method_7919() / (float)b.method_7936();
            return percentDamageOfA > mode.breakPoint == percentDamageOfB > mode.breakPoint;
        }
        return false;
    }
}

