/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.config.FuzzyMode;
import com.google.common.base.Preconditions;
import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

final class AESharedItemStack
implements Comparable<AESharedItemStack> {
    private final class_1799 itemStack;
    private final int itemId;
    private final int itemDamage;
    private final int hashCode;

    public AESharedItemStack(class_1799 itemStack) {
        this.itemStack = itemStack;
        this.itemId = class_1792.method_7880((class_1792)itemStack.method_7909());
        this.itemDamage = itemStack.method_7919();
        this.hashCode = this.makeHashCode();
    }

    Bounds getBounds(FuzzyMode fuzzy) {
        return new Bounds(this.itemStack, fuzzy);
    }

    class_1799 getDefinition() {
        return this.itemStack;
    }

    int getItemDamage() {
        return this.itemDamage;
    }

    int getItemID() {
        return this.itemId;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AESharedItemStack) {
            AESharedItemStack other = (AESharedItemStack)obj;
            Preconditions.checkState((this.itemStack.method_7947() == 1 ? 1 : 0) != 0, (Object)"ItemStack#getCount() has to be 1");
            Preconditions.checkArgument((other.getDefinition().method_7947() == 1 ? 1 : 0) != 0, (Object)"ItemStack#getCount() has to be 1");
            if (this.itemStack == other.itemStack) {
                return true;
            }
            return class_1799.method_7973((class_1799)this.itemStack, (class_1799)other.itemStack);
        }
        return false;
    }

    @Override
    public int compareTo(AESharedItemStack b) {
        Preconditions.checkState((this.itemStack.method_7947() == 1 ? 1 : 0) != 0, (Object)"ItemStack#getCount() has to be 1");
        Preconditions.checkArgument((b.getDefinition().method_7947() == 1 ? 1 : 0) != 0, (Object)"ItemStack#getCount() has to be 1");
        if (this.itemStack == b.getDefinition()) {
            return 0;
        }
        int id = this.itemId - b.itemId;
        if (id != 0) {
            return id;
        }
        int damageValue = this.itemDamage - b.itemDamage;
        if (damageValue != 0) {
            return damageValue;
        }
        return System.identityHashCode(this.getDefinition().method_7969()) - System.identityHashCode(b.getDefinition().method_7969());
    }

    private int makeHashCode() {
        return Objects.hash(this.itemId, this.itemDamage, this.itemStack.method_7985() ? this.itemStack.method_7969() : Integer.valueOf(0));
    }

    public static final class Bounds {
        private static final int MIN_DAMAGE_VALUE = 0;
        private static final int MAX_DAMAGE_VALUE = Short.MAX_VALUE;
        private final AESharedItemStack lower;
        private final AESharedItemStack upper;

        public Bounds(class_1799 stack, FuzzyMode fuzzy) {
            Preconditions.checkState((!stack.method_7960() ? 1 : 0) != 0, (Object)"ItemStack#isEmpty() has to be false");
            Preconditions.checkState((stack.method_7947() == 1 ? 1 : 0) != 0, (Object)"ItemStack#getCount() has to be 1");
            class_2487 tag = stack.method_7985() ? stack.method_7969() : null;
            this.lower = this.makeLowerBound(stack, tag, fuzzy);
            this.upper = this.makeUpperBound(stack, tag, fuzzy);
        }

        public AESharedItemStack lower() {
            return this.lower;
        }

        public AESharedItemStack upper() {
            return this.upper;
        }

        private AESharedItemStack makeLowerBound(class_1799 itemStack, class_2487 tag, FuzzyMode fuzzy) {
            class_1799 newDef = itemStack.method_7972();
            if (newDef.method_7909().method_7846()) {
                if (fuzzy == FuzzyMode.IGNORE_ALL) {
                    newDef.method_7974(0);
                } else if (fuzzy == FuzzyMode.PERCENT_99) {
                    if (itemStack.method_7919() == 0) {
                        newDef.method_7974(0);
                    } else {
                        newDef.method_7974(1);
                    }
                } else {
                    int breakpoint = fuzzy.calculateBreakPoint(itemStack.method_7936());
                    int damage = breakpoint <= itemStack.method_7919() ? breakpoint : 0;
                    newDef.method_7974(damage);
                }
            }
            return new AESharedItemStack(newDef);
        }

        private AESharedItemStack makeUpperBound(class_1799 itemStack, class_2487 tag, FuzzyMode fuzzy) {
            class_1799 newDef = itemStack.method_7972();
            if (newDef.method_7909().method_7846()) {
                if (fuzzy == FuzzyMode.IGNORE_ALL) {
                    newDef.method_7974(itemStack.method_7936() + 1);
                } else if (fuzzy == FuzzyMode.PERCENT_99) {
                    if (itemStack.method_7919() == 0) {
                        newDef.method_7974(0);
                    } else {
                        newDef.method_7974(itemStack.method_7936() + 1);
                    }
                } else {
                    int breakpoint = fuzzy.calculateBreakPoint(itemStack.method_7936());
                    int damage = itemStack.method_7919() < breakpoint ? breakpoint - 1 : itemStack.method_7936() + 1;
                    newDef.method_7974(damage);
                }
            }
            return new AESharedItemStack(newDef);
        }
    }
}

