/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.util.item.FuzzyItemList;
import appeng.util.item.NullItemList;
import appeng.util.item.StrictItemList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.class_1792;

public final class ItemList
implements IItemList<IAEItemStack> {
    private static final IItemList<IAEItemStack> NULL_ITEMLIST = new NullItemList();
    private final Map<class_1792, IItemList<IAEItemStack>> records = new IdentityHashMap<class_1792, IItemList<IAEItemStack>>();

    @Override
    public IAEItemStack findPrecise(IAEItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        return this.getRecord(itemStack.getItem()).findPrecise(itemStack);
    }

    @Override
    public Collection<IAEItemStack> findFuzzy(IAEItemStack filter, FuzzyMode fuzzy) {
        if (filter == null) {
            return Collections.emptyList();
        }
        return this.getRecord(filter.getItem()).findFuzzy(filter, fuzzy);
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    public void add(IAEItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        this.getOrCreateRecord(itemStack.getItem()).add(itemStack);
    }

    @Override
    public void addStorage(IAEItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        this.getOrCreateRecord(itemStack.getItem()).addStorage(itemStack);
    }

    @Override
    public void addCrafting(IAEItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        this.getOrCreateRecord(itemStack.getItem()).addCrafting(itemStack);
    }

    @Override
    public void addRequestable(IAEItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        this.getOrCreateRecord(itemStack.getItem()).addRequestable(itemStack);
    }

    @Override
    public IAEItemStack getFirstItem() {
        Iterator<IAEItemStack> iterator = this.iterator();
        if (iterator.hasNext()) {
            IAEItemStack stackType = iterator.next();
            return stackType;
        }
        return null;
    }

    @Override
    public int size() {
        int size = 0;
        for (IItemList<IAEItemStack> entry : this.records.values()) {
            size += entry.size();
        }
        return size;
    }

    @Override
    public Iterator<IAEItemStack> iterator() {
        return new ChainedIterator(this.records.values().iterator());
    }

    @Override
    public void resetStatus() {
        for (IAEItemStack i : this) {
            i.reset();
        }
    }

    private IItemList<IAEItemStack> getRecord(class_1792 item) {
        return this.records.getOrDefault(item, NULL_ITEMLIST);
    }

    private IItemList<IAEItemStack> getOrCreateRecord(class_1792 item) {
        return this.records.computeIfAbsent(item, this::makeRecordMap);
    }

    private IItemList<IAEItemStack> makeRecordMap(class_1792 item) {
        if (item.method_7846()) {
            return new FuzzyItemList();
        }
        return new StrictItemList();
    }

    private class ChainedIterator
    implements Iterator<IAEItemStack> {
        private final Iterator<IItemList<IAEItemStack>> parent;
        private Iterator<IAEItemStack> next;

        public ChainedIterator(Iterator<IItemList<IAEItemStack>> iterator) {
            this.parent = iterator;
            if (this.parent.hasNext()) {
                this.next = this.parent.next().iterator();
            }
        }

        @Override
        public boolean hasNext() {
            while (this.next != null) {
                if (this.next.hasNext()) {
                    return true;
                }
                if (this.parent.hasNext()) {
                    this.next = this.parent.next().iterator();
                    continue;
                }
                this.next = null;
            }
            return false;
        }

        @Override
        public IAEItemStack next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            return this.next.next();
        }
    }
}

