/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen.meteorite;

import appeng.api.definitions.IBlockDefinition;
import appeng.api.definitions.IBlocks;
import appeng.api.definitions.IMaterials;
import appeng.api.features.AEFeature;
import appeng.core.AEConfig;
import appeng.core.Api;
import appeng.core.worlddata.WorldData;
import appeng.tile.storage.SkyChestBlockEntity;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorFixedInv;
import appeng.worldgen.meteorite.CraterType;
import appeng.worldgen.meteorite.MeteoriteBlockPutter;
import appeng.worldgen.meteorite.PlacedMeteoriteSettings;
import appeng.worldgen.meteorite.fallout.Fallout;
import appeng.worldgen.meteorite.fallout.FalloutCopy;
import appeng.worldgen.meteorite.fallout.FalloutMode;
import appeng.worldgen.meteorite.fallout.FalloutSand;
import appeng.worldgen.meteorite.fallout.FalloutSnow;
import java.util.ArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_3341;

public final class MeteoritePlacer {
    private static final double PRESSES_SPAWN_CHANCE = 0.7;
    private static final int SKYSTONE_SPAWN_LIMIT = 12;
    private final IBlockDefinition skyChestDefinition;
    private final class_2680 skyStone;
    private final class_1792 skyStoneItem;
    private final MeteoriteBlockPutter putter = new MeteoriteBlockPutter();
    private final class_1936 world;
    private final Fallout type;
    private final class_2338 pos;
    private final int x;
    private final int y;
    private final int z;
    private final double meteoriteSize;
    private final double realCrater;
    private final double squaredMeteoriteSize;
    private final double crater;
    private final boolean placeCrater;
    private final CraterType craterType;
    private final boolean pureCrater;
    private final boolean craterLake;
    private final class_3341 boundingBox;

    public MeteoritePlacer(class_1936 world, PlacedMeteoriteSettings settings, class_3341 boundingBox) {
        this.boundingBox = boundingBox;
        this.world = world;
        this.pos = settings.getPos();
        this.x = settings.getPos().method_10263();
        this.y = settings.getPos().method_10264();
        this.z = settings.getPos().method_10260();
        this.meteoriteSize = settings.getMeteoriteRadius();
        this.realCrater = this.meteoriteSize * 2.0 + 5.0;
        this.placeCrater = settings.shouldPlaceCrater();
        this.craterType = settings.getCraterType();
        this.pureCrater = settings.isPureCrater();
        this.craterLake = settings.isCraterLake();
        this.squaredMeteoriteSize = this.meteoriteSize * this.meteoriteSize;
        this.crater = this.realCrater * this.realCrater;
        IBlocks blocks = Api.instance().definitions().blocks();
        this.skyChestDefinition = blocks.skyStoneChest();
        this.skyStone = blocks.skyStoneBlock().block().method_9564();
        this.skyStoneItem = blocks.skyStoneBlock().item();
        this.type = this.getFallout(world, settings.getPos(), settings.getFallout());
    }

    public void place() {
        if (this.placeCrater) {
            this.placeCrater();
        }
        this.placeMeteorite();
        if (this.placeCrater) {
            this.decay();
        }
        if (this.craterLake) {
            this.placeCraterLake();
        }
    }

    private int minX(int x) {
        if (x < this.boundingBox.field_14381) {
            return this.boundingBox.field_14381;
        }
        if (x > this.boundingBox.field_14378) {
            return this.boundingBox.field_14378;
        }
        return x;
    }

    private int minZ(int x) {
        if (x < this.boundingBox.field_14379) {
            return this.boundingBox.field_14379;
        }
        if (x > this.boundingBox.field_14376) {
            return this.boundingBox.field_14376;
        }
        return x;
    }

    private int maxX(int x) {
        if (x < this.boundingBox.field_14381) {
            return this.boundingBox.field_14381;
        }
        if (x > this.boundingBox.field_14378) {
            return this.boundingBox.field_14378;
        }
        return x;
    }

    private int maxZ(int x) {
        if (x < this.boundingBox.field_14379) {
            return this.boundingBox.field_14379;
        }
        if (x > this.boundingBox.field_14376) {
            return this.boundingBox.field_14376;
        }
        return x;
    }

    private void placeCrater() {
        int maxY = 255;
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        class_2680 filler = this.craterType.getFiller().method_9564();
        for (int j = this.y - 5; j <= 255; ++j) {
            blockPos.method_10099(j);
            for (int i = this.boundingBox.field_14381; i <= this.boundingBox.field_14378; ++i) {
                blockPos.method_20787(i);
                for (int k = this.boundingBox.field_14379; k <= this.boundingBox.field_14376; ++k) {
                    blockPos.method_20788(k);
                    double dx = i - this.x;
                    double dz = k - this.z;
                    double h = (double)this.y - this.meteoriteSize + 1.0 + (double)this.type.adjustCrater();
                    double distanceFrom = dx * dx + dz * dz;
                    if (!((double)j > h + distanceFrom * 0.02)) continue;
                    class_2680 currentBlock = this.world.method_8320((class_2338)blockPos);
                    if (this.craterType != CraterType.NORMAL && j < this.y && currentBlock.method_26207().method_15799()) {
                        if (!((double)j > h + distanceFrom * 0.02)) continue;
                        this.putter.put(this.world, (class_2338)blockPos, filler);
                        continue;
                    }
                    this.putter.put(this.world, (class_2338)blockPos, class_2246.field_10124.method_9564());
                }
            }
        }
        for (Object o : this.world.method_8390(class_1542.class, new class_238((double)this.minX(this.x - 30), (double)(this.y - 5), (double)this.minZ(this.z - 30), (double)this.maxX(this.x + 30), (double)(this.y + 30), (double)this.maxZ(this.z + 30)), null)) {
            class_1297 e = (class_1297)o;
            e.method_5650();
        }
    }

    private void placeMeteorite() {
        this.placeMeteoriteSkyStone();
        this.placeChest();
    }

    private void placeChest() {
        if (AEConfig.instance().isFeatureEnabled(AEFeature.SPAWN_PRESSES_IN_METEORITES)) {
            this.putter.put(this.world, this.pos, this.skyChestDefinition.block().method_9564());
            SkyChestBlockEntity te = (SkyChestBlockEntity)this.world.method_8321(this.pos);
            InventoryAdaptor ap = null;
            if (te != null) {
                ap = new AdaptorFixedInv(te.getInternalInventory());
            }
            if (ap != null && !ap.containsItems()) {
                int primary = Math.max(1, (int)(Math.random() * 4.0));
                if (primary > 3) {
                    primary = 3;
                }
                for (int zz = 0; zz < primary; ++zz) {
                    boolean duplicate;
                    do {
                        duplicate = false;
                        int r = Math.random() > 0.7 ? WorldData.instance().storageData().getNextOrderedValue("presses", 0) : (int)(Math.random() * 1000.0);
                        class_1799 toAdd = class_1799.field_8037;
                        IMaterials materials = Api.instance().definitions().materials();
                        switch (r % 4) {
                            case 0: {
                                toAdd = materials.calcProcessorPress().maybeStack(1).orElse(class_1799.field_8037);
                                break;
                            }
                            case 1: {
                                toAdd = materials.engProcessorPress().maybeStack(1).orElse(class_1799.field_8037);
                                break;
                            }
                            case 2: {
                                toAdd = materials.logicProcessorPress().maybeStack(1).orElse(class_1799.field_8037);
                                break;
                            }
                            case 3: {
                                toAdd = materials.siliconPress().maybeStack(1).orElse(class_1799.field_8037);
                                break;
                            }
                        }
                        if (toAdd.method_7960()) continue;
                        if (ap.simulateRemove(1, toAdd, null).method_7960()) {
                            ap.addItems(toAdd);
                            continue;
                        }
                        duplicate = true;
                    } while (duplicate);
                }
                int secondary = Math.max(1, (int)(Math.random() * 3.0));
                block12: for (int zz = 0; zz < secondary; ++zz) {
                    switch ((int)(Math.random() * 1000.0) % 3) {
                        case 0: {
                            int amount = (int)(Math.random() * 12.0 + 1.0);
                            ap.addItems(new class_1799((class_1935)this.skyStoneItem, amount));
                            continue block12;
                        }
                        case 1: {
                            ArrayList<class_1799> possibles = new ArrayList<class_1799>();
                            possibles.add(new class_1799((class_1935)class_1802.field_8397));
                            class_1799 nugget = (class_1799)Platform.pickRandom(possibles);
                            if (nugget == null || nugget.method_7960()) continue block12;
                            nugget = nugget.method_7972();
                            nugget.method_7939((int)(Math.random() * 12.0) + 1);
                            ap.addItems(nugget);
                        }
                    }
                }
            }
        }
    }

    private void placeMeteoriteSkyStone() {
        int meteorXLength = this.minX(this.x - 8);
        int meteorXHeight = this.maxX(this.x + 8);
        int meteorZLength = this.minZ(this.z - 8);
        int meteorZHeight = this.maxZ(this.z + 8);
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int i = meteorXLength; i <= meteorXHeight; ++i) {
            pos.method_20787(i);
            for (int j = this.y - 8; j < this.y + 8; ++j) {
                pos.method_10099(j);
                for (int k = meteorZLength; k <= meteorZHeight; ++k) {
                    pos.method_20788(k);
                    double dx = i - this.x;
                    double dy = j - this.y;
                    double dz = k - this.z;
                    double d = j > this.y ? 1.4 : 0.8;
                    if (!(dx * dx * 0.7 + dy * dy * d + dz * dz * 0.7 < this.squaredMeteoriteSize)) continue;
                    this.putter.put(this.world, (class_2338)pos, this.skyStone);
                }
            }
        }
    }

    private void decay() {
        double randomShit = 0.0;
        int meteorXLength = this.minX(this.x - 30);
        int meteorXHeight = this.maxX(this.x + 30);
        int meteorZLength = this.minZ(this.z - 30);
        int meteorZHeight = this.maxZ(this.z + 30);
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        class_2338.class_2339 blockPosUp = new class_2338.class_2339();
        class_2338.class_2339 blockPosDown = new class_2338.class_2339();
        for (int i = meteorXLength; i <= meteorXHeight; ++i) {
            blockPos.method_20787(i);
            blockPosUp.method_20787(i);
            blockPosDown.method_20787(i);
            for (int k = meteorZLength; k <= meteorZHeight; ++k) {
                blockPos.method_20788(k);
                blockPosUp.method_20788(k);
                blockPosDown.method_20788(k);
                for (int j = this.y - 9; j < this.y + 30; ++j) {
                    double dx;
                    double dz;
                    double dy;
                    blockPos.method_10099(j);
                    blockPosUp.method_10099(j + 1);
                    blockPosDown.method_10099(j - 1);
                    class_2680 state = this.world.method_8320((class_2338)blockPos);
                    class_2248 blk = this.world.method_8320((class_2338)blockPos).method_26204();
                    if (this.pureCrater && blk == this.craterType.getFiller()) continue;
                    if (state.method_26207().method_15800()) {
                        if (!this.world.method_22347((class_2338)blockPosUp)) {
                            class_2680 stateUp = this.world.method_8320((class_2338)blockPosUp);
                            this.world.method_8652((class_2338)blockPos, stateUp, 3);
                            continue;
                        }
                        if (!(randomShit < 100.0 * this.crater)) continue;
                        double dx2 = i - this.x;
                        dy = j - this.y;
                        dz = k - this.z;
                        double dist = dx2 * dx2 + dy * dy + dz * dz;
                        class_2680 xf = this.world.method_8320((class_2338)blockPosDown);
                        if (xf.method_26207().method_15800()) continue;
                        double extraRange = Math.random() * 0.6;
                        double height = this.crater * (extraRange + 0.2) - Math.abs(dist - this.crater * 1.7);
                        if (xf.method_26215() || !(height > 0.0) || !(Math.random() > 0.6)) continue;
                        randomShit += 1.0;
                        this.type.getRandomFall(this.world, (class_2338)blockPos);
                        continue;
                    }
                    if (!this.world.method_22347((class_2338)blockPosUp) || !(Math.random() > 0.4) || !((dx = (double)(i - this.x)) * dx + (dy = (double)(j - this.y)) * dy + (dz = (double)(k - this.z)) * dz < this.crater * 1.6)) continue;
                    this.type.getRandomInset(this.world, (class_2338)blockPos);
                }
            }
        }
    }

    private void placeCraterLake() {
        int maxY = this.world.method_8615() - 1;
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        for (int j = this.y - 5; j <= maxY; ++j) {
            blockPos.method_10099(j);
            for (int i = this.boundingBox.field_14381; i <= this.boundingBox.field_14378; ++i) {
                blockPos.method_20787(i);
                for (int k = this.boundingBox.field_14379; k <= this.boundingBox.field_14376; ++k) {
                    class_2680 currentBlock;
                    blockPos.method_20788(k);
                    double dx = i - this.x;
                    double dz = k - this.z;
                    double h = (double)this.y - this.meteoriteSize + 1.0 + (double)this.type.adjustCrater();
                    double distanceFrom = dx * dx + dz * dz;
                    if (!((double)j > h + distanceFrom * 0.02) || (currentBlock = this.world.method_8320((class_2338)blockPos)).method_26204() != class_2246.field_10124) continue;
                    this.putter.put(this.world, (class_2338)blockPos, class_2246.field_10382.method_9564());
                }
            }
        }
    }

    private Fallout getFallout(class_1936 w, class_2338 pos, FalloutMode mode) {
        switch (mode) {
            case SAND: {
                return new FalloutSand(w, pos, this.putter, this.skyStone);
            }
            case TERRACOTTA: {
                return new FalloutCopy(w, pos, this.putter, this.skyStone);
            }
            case ICE_SNOW: {
                return new FalloutSnow(w, pos, this.putter, this.skyStone);
            }
        }
        return new Fallout(this.putter, this.skyStone);
    }
}

