/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen.meteorite;

import appeng.worldgen.meteorite.CraterType;
import appeng.worldgen.meteorite.MeteoriteStructurePiece;
import appeng.worldgen.meteorite.fallout.FalloutMode;
import com.google.common.math.StatsAccumulator;
import java.util.Set;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3449;
import net.minecraft.class_3481;
import net.minecraft.class_3485;
import net.minecraft.class_3494;
import net.minecraft.class_5455;

public class MeteoriteStructureStart
extends class_3449<class_3111> {
    private final class_3494<class_2248> sandTag = class_3481.method_15073().method_30213(new class_2960("minecraft:sand"));
    private final class_3494<class_2248> terracottaTag = class_3481.method_15073().method_30213(new class_2960("c:terracotta_blocks"));

    public MeteoriteStructureStart(class_3195<class_3111> feature, int chunkX, int chunkZ, class_3341 box, int references, long seed) {
        super(feature, chunkX, chunkZ, box, references, seed);
    }

    public void init(class_5455 dynamicRegistryManager, class_2794 generator, class_3485 structureManager, int chunkX, int chunkZ, class_1959 biome, class_3111 featureConfig) {
        int centerX = chunkX * 16 + this.field_16715.nextInt(16);
        int centerZ = chunkZ * 16 + this.field_16715.nextInt(16);
        float meteoriteRadius = this.field_16715.nextFloat() * 6.0f + 2.0f;
        int yOffset = (int)Math.ceil(meteoriteRadius) + 1;
        Set t2 = generator.method_12098().method_8763(centerX, 0, centerZ, 0);
        class_1959 spawnBiome = t2.stream().findFirst().orElse(biome);
        boolean isOcean = spawnBiome.method_8688() == class_1959.class_1961.field_9367;
        class_2902.class_2903 heightmapType = isOcean ? class_2902.class_2903.field_13195 : class_2902.class_2903.field_13194;
        StatsAccumulator stats = new StatsAccumulator();
        int scanRadius = (int)Math.max(1.0f, meteoriteRadius * 2.0f);
        for (int x = -scanRadius; x <= scanRadius; ++x) {
            for (int z = -scanRadius; z <= scanRadius; ++z) {
                int h = generator.method_16397(centerX + x, centerZ + z, heightmapType);
                stats.add((double)h);
            }
        }
        int centerY = (int)stats.mean();
        if (stats.populationVariance() > 5.0) {
            centerY = (int)((double)centerY - (stats.mean() - stats.min()) * 0.75);
        }
        centerY -= yOffset;
        centerY = Math.max(32, centerY);
        class_2338 actualPos = new class_2338(centerX, centerY, centerZ);
        boolean craterLake = this.locateWaterAroundTheCrater(generator, actualPos, meteoriteRadius);
        CraterType craterType = this.determineCraterType(spawnBiome);
        boolean pureCrater = this.field_16715.nextFloat() > 0.9f;
        FalloutMode fallout = this.getFalloutFromBaseBlock(spawnBiome.method_30970().method_30985().method_15337());
        this.field_15325.add(new MeteoriteStructurePiece(actualPos, meteoriteRadius, craterType, fallout, pureCrater, craterLake));
        this.method_14969();
    }

    private boolean locateWaterAroundTheCrater(class_2794 generator, class_2338 pos, float radius) {
        int seaLevel = generator.method_16398();
        int maxY = seaLevel - 1;
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        blockPos.method_10099(maxY);
        for (int i = pos.method_10263() - 32; i <= pos.method_10263() + 32; ++i) {
            blockPos.method_20787(i);
            for (int k = pos.method_10260() - 32; k <= pos.method_10260() + 32; ++k) {
                int heigth;
                blockPos.method_20788(k);
                double dx = i - pos.method_10263();
                double dz = k - pos.method_10260();
                double h = (float)pos.method_10264() - radius + 1.0f;
                double distanceFrom = dx * dx + dz * dz;
                if (!((double)maxY > h + distanceFrom * 0.0175) || !((double)maxY < h + distanceFrom * 0.02) || (heigth = generator.method_16397(blockPos.method_10263(), blockPos.method_10260(), class_2902.class_2903.field_13200)) >= seaLevel) continue;
                return true;
            }
        }
        return false;
    }

    private CraterType determineCraterType(class_1959 biome) {
        boolean lava;
        boolean lake;
        boolean specialMeteor;
        float temp = biome.method_8712();
        class_1959.class_1961 category = biome.method_8688();
        if (category == class_1959.class_1961.field_9367) {
            return CraterType.NONE;
        }
        boolean bl = specialMeteor = this.field_16715.nextFloat() > 0.5f;
        if (!specialMeteor) {
            return CraterType.NORMAL;
        }
        if (temp >= 1.0f) {
            boolean lava2 = this.field_16715.nextFloat() > 0.5f;
            switch (biome.method_8694()) {
                case field_9384: {
                    return lava2 ? CraterType.LAVA : CraterType.NORMAL;
                }
                case field_9382: {
                    boolean obsidian = this.field_16715.nextFloat() > 0.75f;
                    CraterType alternativObsidian = obsidian ? CraterType.OBSIDIAN : CraterType.LAVA;
                    return lava2 ? alternativObsidian : CraterType.NORMAL;
                }
            }
        }
        if (temp < 1.0f && (double)temp >= 0.2) {
            lake = this.field_16715.nextFloat() > 0.25f;
            lava = this.field_16715.nextFloat() > 0.8f;
            switch (biome.method_8694()) {
                case field_9384: {
                    return lava ? CraterType.LAVA : CraterType.NORMAL;
                }
                case field_9382: {
                    boolean obsidian = this.field_16715.nextFloat() > 0.75f;
                    CraterType alternativObsidian = obsidian ? CraterType.OBSIDIAN : CraterType.LAVA;
                    CraterType craterLake = lake ? CraterType.WATER : CraterType.NORMAL;
                    return lava ? alternativObsidian : craterLake;
                }
                case field_9383: {
                    boolean snow = this.field_16715.nextFloat() > 0.75f;
                    CraterType water = lake ? CraterType.WATER : CraterType.NORMAL;
                    return snow ? CraterType.SNOW : water;
                }
            }
        }
        if ((double)temp < 0.2) {
            lake = this.field_16715.nextFloat() > 0.25f;
            lava = this.field_16715.nextFloat() > 0.95f;
            boolean frozen = this.field_16715.nextFloat() > 0.25f;
            switch (biome.method_8694()) {
                case field_9384: {
                    return lava ? CraterType.LAVA : CraterType.NORMAL;
                }
                case field_9382: {
                    CraterType frozenLake = frozen ? CraterType.ICE : CraterType.WATER;
                    CraterType craterLake = lake ? frozenLake : CraterType.NORMAL;
                    return lava ? CraterType.LAVA : craterLake;
                }
                case field_9383: {
                    CraterType snowCovered = lake ? CraterType.SNOW : CraterType.NORMAL;
                    return lava ? CraterType.LAVA : snowCovered;
                }
            }
        }
        return CraterType.NORMAL;
    }

    private FalloutMode getFalloutFromBaseBlock(class_2680 blockState) {
        class_2248 block = blockState.method_26204();
        if (block.method_9525(this.sandTag)) {
            return FalloutMode.SAND;
        }
        if (block.method_9525(this.terracottaTag)) {
            return FalloutMode.TERRACOTTA;
        }
        if (block == class_2246.field_10477 || block == class_2246.field_10477 || block == class_2246.field_10491 || block == class_2246.field_10295 || block == class_2246.field_10225) {
            return FalloutMode.ICE_SNOW;
        }
        return FalloutMode.DEFAULT;
    }
}

