/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen.meteorite;

import appeng.worldgen.meteorite.CraterType;
import appeng.worldgen.meteorite.fallout.FalloutMode;
import net.minecraft.class_2338;
import net.minecraft.class_2487;

public final class PlacedMeteoriteSettings {
    private final class_2338 pos;
    private final float meteoriteRadius;
    private final CraterType craterType;
    private final FalloutMode fallout;
    private final boolean pureCrater;
    private final boolean craterLake;

    public PlacedMeteoriteSettings(class_2338 pos, float meteoriteRadius, CraterType craterType, FalloutMode fallout, boolean pureCrater, boolean craterLake) {
        this.pos = pos;
        this.craterType = craterType;
        this.meteoriteRadius = meteoriteRadius;
        this.fallout = fallout;
        this.pureCrater = pureCrater;
        this.craterLake = craterLake;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public CraterType getCraterType() {
        return this.craterType;
    }

    public float getMeteoriteRadius() {
        return this.meteoriteRadius;
    }

    public FalloutMode getFallout() {
        return this.fallout;
    }

    public boolean shouldPlaceCrater() {
        return this.craterType != CraterType.NONE;
    }

    public boolean isPureCrater() {
        return this.pureCrater;
    }

    public boolean isCraterLake() {
        return this.craterLake;
    }

    public class_2487 write(class_2487 tag) {
        tag.method_10544("c", this.pos.method_10063());
        tag.method_10548("r", this.meteoriteRadius);
        tag.method_10567("t", (byte)this.craterType.ordinal());
        tag.method_10567("f", (byte)this.fallout.ordinal());
        tag.method_10556("p", this.pureCrater);
        tag.method_10556("l", this.craterLake);
        return tag;
    }

    public static PlacedMeteoriteSettings read(class_2487 tag) {
        class_2338 pos = class_2338.method_10092((long)tag.method_10537("c"));
        float meteoriteRadius = tag.method_10583("r");
        CraterType craterType = CraterType.values()[tag.method_10571("t")];
        FalloutMode fallout = FalloutMode.values()[tag.method_10571("f")];
        boolean pureCrater = tag.method_10577("p");
        boolean craterLake = tag.method_10577("l");
        return new PlacedMeteoriteSettings(pos, meteoriteRadius, craterType, fallout, pureCrater, craterLake);
    }

    public String toString() {
        return "PlacedMeteoriteSettings [pos=" + this.pos + ", meteoriteRadius=" + this.meteoriteRadius + ", craterType=" + (Object)((Object)this.craterType) + ", fallout=" + (Object)((Object)this.fallout) + ", pureCrater=" + this.pureCrater + ", craterLake=" + this.craterLake + "]";
    }
}

