/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen.meteorite.debug;

import appeng.worldgen.meteorite.CraterType;
import appeng.worldgen.meteorite.PlacedMeteoriteSettings;
import javax.annotation.Nullable;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_4538;

public class MeteoriteSpawner {
    public PlacedMeteoriteSettings trySpawnMeteoriteAtSuitableHeight(class_4538 world, class_2338 startPos, float coreRadius, CraterType craterType, boolean pureCrater, boolean worldGen) {
        int stepSize = Math.min(5, (int)Math.ceil(coreRadius) + 1);
        int minY = 10 + stepSize;
        class_2338.class_2339 mutablePos = startPos.method_25503();
        mutablePos.method_10104(class_2350.field_11033, stepSize);
        while (mutablePos.method_10264() > minY) {
            PlacedMeteoriteSettings spawned = this.trySpawnMeteorite(world, (class_2338)mutablePos, coreRadius, craterType, pureCrater);
            if (spawned != null) {
                return spawned;
            }
            mutablePos.method_10099(mutablePos.method_10264() - stepSize);
        }
        return null;
    }

    @Nullable
    public PlacedMeteoriteSettings trySpawnMeteorite(class_4538 world, class_2338 pos, float coreRadius, CraterType craterType, boolean pureCrater) {
        boolean solid;
        if (!this.areSurroundingsSuitable(world, pos)) {
            return null;
        }
        int skyMode = this.countBlockWithSkyLight(world, pos);
        boolean placeCrater = skyMode > 10;
        boolean bl = solid = !MeteoriteSpawner.isAirBelowSpawnPoint(world, pos);
        if (!solid || placeCrater) {
            // empty if block
        }
        boolean craterLake = false;
        return new PlacedMeteoriteSettings(pos, coreRadius, craterType, null, pureCrater, craterLake);
    }

    private static boolean isAirBelowSpawnPoint(class_4538 w, class_2338 pos) {
        class_2338.class_2339 testPos = pos.method_25503();
        for (int j = pos.method_10264() - 15; j < pos.method_10264() - 1; ++j) {
            testPos.method_10099(j);
            if (!w.method_22347((class_2338)testPos)) continue;
            return true;
        }
        return false;
    }

    private int countBlockWithSkyLight(class_4538 w, class_2338 pos) {
        int skyMode = 0;
        class_2338.class_2339 testPos = new class_2338.class_2339();
        for (int i = pos.method_10263() - 15; i < pos.method_10263() + 15; ++i) {
            testPos.method_20787(i);
            for (int j = pos.method_10264() - 15; j < pos.method_10264() + 11; ++j) {
                testPos.method_10099(j);
                for (int k = pos.method_10260() - 15; k < pos.method_10260() + 15; ++k) {
                    testPos.method_20788(k);
                    if (!w.method_22348((class_2338)testPos)) continue;
                    ++skyMode;
                }
            }
        }
        return skyMode;
    }

    private boolean areSurroundingsSuitable(class_4538 w, class_2338 pos) {
        int realValidBlocks = 0;
        class_2338.class_2339 testPos = new class_2338.class_2339();
        for (int i = pos.method_10263() - 6; i < pos.method_10263() + 6; ++i) {
            testPos.method_20787(i);
            for (int j = pos.method_10264() - 6; j < pos.method_10264() + 6; ++j) {
                testPos.method_10099(j);
                for (int k = pos.method_10260() - 6; k < pos.method_10260() + 6; ++k) {
                    testPos.method_20788(k);
                    class_2248 block = w.method_8320((class_2338)testPos).method_26204();
                    ++realValidBlocks;
                }
            }
        }
        int validBlocks = 0;
        for (int i = pos.method_10263() - 15; i < pos.method_10263() + 15; ++i) {
            testPos.method_20787(i);
            for (int j = pos.method_10264() - 15; j < pos.method_10264() + 15; ++j) {
                testPos.method_10099(j);
                for (int k = pos.method_10260() - 15; k < pos.method_10260() + 15; ++k) {
                    testPos.method_20788(k);
                    class_2248 testBlk = w.method_8320((class_2338)testPos).method_26204();
                    ++validBlocks;
                }
            }
        }
        int minBlocks = 200;
        return validBlocks > 200 && realValidBlocks > 80;
    }
}

