/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft;

import bassebombecraft.client.particles.RegisteredParticles;
import bassebombecraft.client.proxy.ClientProxy;
import bassebombecraft.config.ModConfiguration;
import bassebombecraft.config.VersionUtils;
import bassebombecraft.entity.attribute.RegisteredAttributes;
import bassebombecraft.inventory.container.RegisteredContainers;
import bassebombecraft.item.RegisteredItems;
import bassebombecraft.potion.RegisteredPotions;
import bassebombecraft.potion.effect.RegisteredEffects;
import bassebombecraft.proxy.Proxy;
import bassebombecraft.proxy.ServerProxy;
import bassebombecraft.sound.RegisteredSounds;
import bassebombecraft.tab.ItemGroupFactory;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="bassebombecraft")
public class BassebombeCraft {
    static Logger logger = LogManager.getLogger();
    static BassebombeCraft instance;
    static Proxy proxy;
    static final ItemGroup MOD_ITEMGROUP;
    MinecraftServer server;
    static Random random;
    Consumer<FMLClientSetupEvent> clientSetupEventHandler = t -> {
        try {
            this.setupClient((FMLClientSetupEvent)t);
        }
        catch (Exception e) {
            this.reportAndLogException(e);
        }
    };

    public BassebombeCraft() {
        instance = this;
        try {
            MinecraftForge.EVENT_BUS.register((Object)this);
            ModConfiguration.loadConfig();
            IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
            modEventBus.addListener(this.clientSetupEventHandler);
            RegisteredParticles.PARTICLE_REGISTRY.register(modEventBus);
            RegisteredContainers.CONTAINER_REGISTRY.register(modEventBus);
            RegisteredAttributes.ATTRIBUTE_REGISTRY.register(modEventBus);
            RegisteredItems.ITEMS_REGISTRY.register(modEventBus);
            RegisteredSounds.SOUNDS_REGISTRY.register(modEventBus);
            RegisteredEffects.EFFECT_REGISTRY.register(modEventBus);
            RegisteredPotions.POTION_REGISTRY.register(modEventBus);
        }
        catch (ExceptionInInitializerError e) {
            this.reportAndLogException(e);
            throw e;
        }
        catch (Exception e) {
            this.reportAndLogException(e);
            throw e;
        }
    }

    @SubscribeEvent
    void serverAboutTostart(FMLServerAboutToStartEvent event) {
        this.server = event.getServer();
    }

    @SubscribeEvent
    void serverStarted(FMLServerStartedEvent event) {
        proxy.startAnalyticsSession();
    }

    @SubscribeEvent
    void serverStopped(FMLServerStoppedEvent event) {
        proxy.endAnalyticsSession();
        this.server = null;
    }

    @SubscribeEvent
    void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        VersionUtils.validateVersion(player);
    }

    @SubscribeEvent
    void setupClient(FMLClientSetupEvent event) throws Exception {
        proxy.setupClientSideRendering();
    }

    public static Proxy getProxy() {
        return proxy;
    }

    public UnmodifiableConfig getTomlConfiguration() {
        return ModConfiguration.COMMON_CONFIG.getValues();
    }

    public Item getCreativeTabItem() {
        return (Item)RegisteredItems.COMPOSITE.get();
    }

    public static BassebombeCraft getBassebombeCraft() {
        return instance;
    }

    public static ItemGroup getItemGroup() {
        return MOD_ITEMGROUP;
    }

    public Logger getLogger() {
        return logger;
    }

    public String getUser() {
        try {
            return proxy.getUser();
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
            throw new RuntimeException(e);
        }
    }

    public Optional<MinecraftServer> getServer() {
        return Optional.ofNullable(this.server);
    }

    public Random getRandom() {
        return random;
    }

    public void reportAndLogException(Throwable e) {
        Optional<String> nullableString = Optional.ofNullable(e.getMessage());
        nullableString.ifPresent(s -> logger.error(s));
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String stacktraceString = sw.toString();
        logger.error(stacktraceString);
        this.reportException(e);
    }

    public void reportException(Throwable e) {
        proxy.postException(e);
    }

    public void reportAndLogError(String msg) {
        proxy.postError(msg);
        logger.error(msg);
    }

    public void logStacktraceAsDebug() {
        StackTraceElement[] ste = Thread.currentThread().getStackTrace();
        Arrays.asList(ste).forEach(arg_0 -> ((Logger)logger).debug(arg_0));
    }

    static {
        proxy = (Proxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
        MOD_ITEMGROUP = ItemGroupFactory.createItemGroup("bassebombecraft");
        random = new Random();
    }
}

