/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.block;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.ModConstants;
import bassebombecraft.event.block.temporary.DefaultTemporaryBlock;
import bassebombecraft.event.block.temporary.TemporaryBlockRepository;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.world.WorldUtils;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;

public class BlockUtils {
    static final int SEND_CHANGE_CLIENTS = 2;
    static final int NUMBER_RAINBOW_COLORS = 8;
    static final int NUMBER_PINK_COLORS = 2;

    public static void createBlock(BlockDirective blockDirective) {
        World world = blockDirective.getWorld();
        if (WorldUtils.isLogicalClient(world)) {
            return;
        }
        BlockPos blockPosition = blockDirective.getBlockPosition();
        Block block = BlockUtils.getBlockFromPosition(blockDirective, world);
        if (blockDirective.harvestBlock()) {
            BlockState blockState = BlockUtils.getBlockStateFromPosition(blockPosition, world);
            ItemStack emptyItemStack = new ItemStack((IItemProvider)block);
            Optional<PlayerEntity> optPlayer = blockDirective.getPlayer();
            if (optPlayer.isPresent()) {
                block.func_180657_a(world, optPlayer.get(), blockPosition, blockState, ModConstants.NULL_TILE_ENTITY, emptyItemStack);
            } else {
                String msg = "Attempted to harvest block directive=" + blockDirective + "but player wasn't defined as expected";
                BassebombeCraft.getBassebombeCraft().reportAndLogError(msg);
            }
        }
        world.func_180501_a(blockPosition, blockDirective.getState(), 2);
    }

    public static Block getBlockFromPosition(BlockPos blockPosition, World world) {
        BlockState blockState = world.func_180495_p(blockPosition);
        return blockState.func_177230_c();
    }

    public static Block getBlockFromPosition(BlockDirective blockDirective, World world) {
        BlockPos blockPosition = blockDirective.getBlockPosition();
        return BlockUtils.getBlockFromPosition(blockPosition, world);
    }

    public static BlockState getBlockStateFromPosition(BlockPos blockPosition, World world) {
        return world.func_180495_p(blockPosition);
    }

    public static BlockState rotateBlockStateWithFacingProperty(BlockState sourceState, double orientation) {
        if (orientation == 0.0) {
            return sourceState;
        }
        if (BlockUtils.hasFacingProperty(sourceState)) {
            Direction direction = (Direction)sourceState.func_177229_b((Property)BlockStateProperties.field_208155_H);
            Direction newDirection = BlockUtils.calculateFacingProperty(direction, orientation);
            BlockState rotatedState = (BlockState)sourceState.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)newDirection);
            return rotatedState;
        }
        if (BlockUtils.hasHorizontalFacingProperty(sourceState)) {
            Direction direction = (Direction)sourceState.func_177229_b((Property)BlockStateProperties.field_208157_J);
            Direction newDirection = BlockUtils.calculateFacingProperty(direction, orientation);
            BlockState rotatedState = (BlockState)sourceState.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)newDirection);
            return rotatedState;
        }
        return sourceState;
    }

    public static Direction calculateFacingProperty(Direction direction, double orientation) {
        if (orientation == 0.0) {
            return direction;
        }
        if (orientation == 90.0) {
            return direction.func_176746_e();
        }
        if (orientation == 180.0) {
            Direction d0 = direction.func_176746_e();
            return d0.func_176746_e();
        }
        if (orientation == 270.0) {
            Direction d0 = direction.func_176746_e();
            Direction d1 = d0.func_176746_e();
            return d1.func_176746_e();
        }
        return direction;
    }

    public static boolean hasFacingProperty(BlockState state) {
        return state.func_235901_b_((Property)BlockStateProperties.field_208155_H);
    }

    public static boolean hasHorizontalFacingProperty(BlockState state) {
        return state.func_235901_b_((Property)BlockStateProperties.field_208157_J);
    }

    public static boolean containsNonAirBlocks(Stream<BlockPos> blocks, World world) {
        return blocks.map(bp -> BlockUtils.getBlockFromPosition(bp, world)).anyMatch(b -> b != Blocks.field_150350_a);
    }

    public static BlockPos calculatePosition(BlockRayTraceResult result) {
        switch (result.func_216354_b()) {
            case UP: {
                return result.func_216350_a().func_177984_a();
            }
            case DOWN: {
                return result.func_216350_a().func_177977_b();
            }
            case SOUTH: {
                return result.func_216350_a().func_177968_d();
            }
            case NORTH: {
                return result.func_216350_a().func_177978_c();
            }
            case EAST: {
                return result.func_216350_a().func_177974_f();
            }
            case WEST: {
                return result.func_216350_a().func_177976_e();
            }
        }
        return result.func_216350_a().func_177984_a();
    }

    public static void setTemporaryBlock(World world, BlockPos pos, Block tempBlock, int duration) {
        BlockDirective tempDirective = BlockDirective.getInstance(pos, tempBlock, false, world);
        BlockUtils.setTemporaryBlock(tempDirective, duration);
    }

    public static void setTemporaryBlock(BlockDirective tempDirective, int duration) {
        World world = tempDirective.getWorld();
        Block block = BlockUtils.getBlockFromPosition(tempDirective.getBlockPosition(), world);
        BlockDirective orgDirective = BlockDirective.getInstance(tempDirective.getBlockPosition(), block, false, world);
        DefaultTemporaryBlock temporaryBlock = DefaultTemporaryBlock.getInstance(duration, tempDirective, orgDirective);
        TemporaryBlockRepository repository = BassebombeCraft.getProxy().getServerTemporaryBlockRepository();
        repository.add(temporaryBlock);
    }

    public static BlockState selectRainbowColoredWool(int colorCounter) {
        int colorSelector = colorCounter % 8;
        switch (colorSelector) {
            case 0: {
                return Blocks.field_196558_aN.func_176223_P();
            }
            case 1: {
                return Blocks.field_196566_aV.func_176223_P();
            }
            case 2: {
                return Blocks.field_196567_aW.func_176223_P();
            }
            case 3: {
                return Blocks.field_196559_aO.func_176223_P();
            }
            case 4: {
                return Blocks.field_196561_aQ.func_176223_P();
            }
            case 5: {
                return Blocks.field_196560_aP.func_176223_P();
            }
            case 6: {
                return Blocks.field_196557_aM.func_176223_P();
            }
            case 7: {
                return Blocks.field_196570_aZ.func_176223_P();
            }
        }
        return Blocks.field_196556_aL.func_176223_P();
    }

    public static BlockState selectPinkColoredWool(int colorCounter) {
        int colorSelector = colorCounter % 8;
        switch (colorSelector) {
            case 0: {
                return Blocks.field_196562_aR.func_176223_P();
            }
            case 1: {
                return Blocks.field_196558_aN.func_176223_P();
            }
        }
        return Blocks.field_196562_aR.func_176223_P();
    }

    public static boolean isTypeBlockDirective(Object obj) {
        Optional<Object> oe = Optional.ofNullable(obj);
        if (oe.isPresent()) {
            return oe.get() instanceof BlockDirective;
        }
        return false;
    }

    public static boolean hasWater(BlockPos position, World world) {
        BlockState state = world.func_180495_p(position);
        return state.func_177230_c() == Blocks.field_150355_j;
    }
}

