/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.client.event.rendering;

import bassebombecraft.entity.EntityUtils;
import bassebombecraft.entity.attribute.RegisteredAttributes;
import bassebombecraft.geom.GeometryUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.event.RenderLivingEvent;

public class DecoyRenderer {
    static final float THIN_DEPTH = 0.02f;
    static final float DECOY_SCALE = 200.0f;

    public static void handleRenderLivingEventPre(RenderLivingEvent.Pre<PlayerEntity, PlayerModel<PlayerEntity>> event) {
        LivingEntity entity = event.getEntity();
        if (!EntityUtils.isEntityAttributeSet(entity, (Attribute)RegisteredAttributes.IS_DECOY_ATTRIBUTE.get())) {
            return;
        }
        float scale = DecoyRenderer.calculateSize(200.0f, entity);
        MatrixStack matrixStack = event.getMatrixStack();
        matrixStack.func_227860_a_();
        float partialTicks = event.getPartialRenderTick();
        float f = MathHelper.func_219805_h((float)partialTicks, (float)entity.field_70760_ar, (float)entity.field_70761_aq);
        double x = entity.func_226277_ct_();
        double z = entity.func_226281_cx_();
        double zxAngle = Math.atan2(z, x);
        double angle1 = zxAngle / Math.PI * 180.0;
        double angle2 = Math.floor(((double)f - angle1) / 45.0) * 45.0;
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)angle1));
        matrixStack.func_227862_a_(0.02f, scale, scale);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)angle2));
    }

    public static void handleRenderLivingEventPost(RenderLivingEvent.Post<PlayerEntity, PlayerModel<PlayerEntity>> event) {
        LivingEntity entity = event.getEntity();
        if (!EntityUtils.isEntityAttributeSet(entity, (Attribute)RegisteredAttributes.IS_DECOY_ATTRIBUTE.get())) {
            return;
        }
        MatrixStack matrixStack = event.getMatrixStack();
        matrixStack.func_227865_b_();
    }

    public static float calculateSize(float amplifier, LivingEntity entity) {
        float scaledSize = amplifier / 100.0f;
        float scaledSizeFraction = scaledSize * 0.25f;
        float sizeVariation = (float)GeometryUtils.oscillateWithDeltaTime(entity.hashCode(), 0.0f, scaledSizeFraction);
        return scaledSize + sizeVariation;
    }
}

