/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.client.event.rendering;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.ClientModConstants;
import bassebombecraft.client.operator.ClientPorts;
import bassebombecraft.client.operator.DefaultClientPorts;
import bassebombecraft.client.operator.rendering.RenderTextBillboard2;
import bassebombecraft.client.operator.rendering.RenderWireframeBoundingBox2;
import bassebombecraft.client.player.ClientPlayerUtils;
import bassebombecraft.client.rendering.rendertype.RenderTypes;
import bassebombecraft.item.RegisteredItems;
import bassebombecraft.operator.DefaultPorts;
import bassebombecraft.operator.Operator2;
import bassebombecraft.operator.Operators2;
import bassebombecraft.operator.Ports;
import bassebombecraft.operator.Sequence2;
import bassebombecraft.player.PlayerUtils;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawHighlightEvent;

public class HudItemHighlightedBlockRenderer {
    static final float AABB_OSCILLIATION = 0.025f;
    static final float TEXT_OSCILLIATION = 25.0f;
    static Supplier<Operator2> splOp = () -> new Sequence2(new RenderWireframeBoundingBox2(0.025f, ClientModConstants.HUD_LINE_COLOR, RenderTypes.OVERLAY_LINES), new RenderTextBillboard2(DefaultPorts.getFnGetString1(), -5, 0, 25.0f), new RenderTextBillboard2(DefaultPorts.getFnGetString2(), -5, -10, 25.0f));

    public static void handleHighlightBlockEvent(DrawHighlightEvent.HighlightBlock event) {
        try {
            if (!ClientPlayerUtils.isClientSidePlayerDefined()) {
                return;
            }
            PlayerEntity player = ClientPlayerUtils.getClientSidePlayer();
            if (!PlayerUtils.isItemInHotbar(player, (Item)RegisteredItems.HUD.get())) {
                return;
            }
            HudItemHighlightedBlockRenderer.render(event, player);
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    static void render(DrawHighlightEvent.HighlightBlock event, PlayerEntity player) {
        BlockRayTraceResult result = event.getTarget();
        if (result.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockPos blockPos = result.func_216350_a();
        AxisAlignedBB aabb = new AxisAlignedBB(blockPos);
        World world = player.func_130014_f_();
        BlockState blockstate = world.func_180495_p(blockPos);
        String message = blockstate.func_177230_c().func_235333_g_().func_150261_e();
        Vector3d aabbCenter = aabb.func_189972_c();
        ClientPorts ports = DefaultClientPorts.getInstance();
        ports.setAabb1(aabb);
        ports.setMatrixStack1(event.getMatrix());
        ports.setString1(message);
        ports.setString2(aabbCenter.toString());
        Operators2.run((Ports)ports, splOp.get());
    }
}

