/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.client.event.rendering;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.entity.EntityUtils;
import bassebombecraft.entity.attribute.RegisteredAttributes;
import bassebombecraft.geom.GeometryUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.OutlineLayerBuffer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraftforge.client.event.RenderLivingEvent;

public class RespawnedRenderer {
    static final int RGB_RED = 128;
    static final int RGB_GREEN = 192;
    static final int RGB_BLUE = 128;
    static final int ALPHA_OFFSET = 127;
    static ReentrantLock lock = new ReentrantLock();

    public static void handleRenderLivingEventPre(RenderLivingEvent.Pre<? super LivingEntity, ?> event) {
        if (!EntityUtils.isEntityAttributeSet(event.getEntity(), (Attribute)RegisteredAttributes.IS_RESPAWNED_ATTRIBUTE.get())) {
            return;
        }
        if (lock.isLocked()) {
            return;
        }
        try {
            lock.lock();
            RespawnedRenderer.doRender(event);
            event.setCanceled(true);
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
        finally {
            lock.unlock();
        }
    }

    static void doRender(RenderLivingEvent.Pre<? super LivingEntity, ?> event) {
        LivingEntity entity = event.getEntity();
        float oscValue = (float)GeometryUtils.oscillate(0.0f, 1.0f);
        int alpha = (int)(oscValue * 128.0f);
        Minecraft mcClient = Minecraft.func_71410_x();
        OutlineLayerBuffer buffer = mcClient.func_228019_au_().func_228490_d_();
        buffer.func_228472_a_(128, 192, 128, 127 + alpha);
        MatrixStack matrixStack = event.getMatrixStack();
        float partialTicks = event.getPartialRenderTick();
        float yaw = entity.func_195046_g(partialTicks);
        int packedLight = event.getLight();
        event.getRenderer().func_225623_a_(entity, yaw, partialTicks, matrixStack, (IRenderTypeBuffer)buffer, packedLight);
        buffer.func_228471_a_();
    }

    public static void handleRenderLivingEventPost(RenderLivingEvent.Post<?, PlayerModel<?>> event) {
        if (!EntityUtils.isEntityAttributeSet(event.getEntity(), (Attribute)RegisteredAttributes.IS_RESPAWNED_ATTRIBUTE.get())) {
            return;
        }
    }
}

