/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.client.event.rendering;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.client.player.ClientPlayerUtils;
import bassebombecraft.client.rendering.RenderingUtils;
import bassebombecraft.event.entity.target.TargetRepository;
import bassebombecraft.item.RegisteredItems;
import bassebombecraft.player.PlayerUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.RenderWorldLastEvent;

public class TargetInfoRenderer {
    public static void handleRenderWorldLastEvent(RenderWorldLastEvent event) {
        try {
            if (!ClientPlayerUtils.isClientSidePlayerDefined()) {
                return;
            }
            PlayerEntity player = ClientPlayerUtils.getClientSidePlayer();
            if (!PlayerUtils.isItemInHotbar(player, (Item)RegisteredItems.HUD.get())) {
                return;
            }
            TargetInfoRenderer.render(event.getMatrixStack(), player);
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    static void render(MatrixStack matrixStack, PlayerEntity player) {
        TargetRepository repository = BassebombeCraft.getProxy().getServerTargetRepository();
        Stream<LivingEntity> targets = repository.get(player);
        int targetsSize = repository.size(player);
        String commanderTargetName = TargetInfoRenderer.getCommanderTargetName(player);
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderingUtils.renderBillboardText(matrixStack, (IRenderTypeBuffer)buffer, 120.0f, -110.0f, "TARGETS");
        RenderingUtils.renderBillboardText(matrixStack, (IRenderTypeBuffer)buffer, 120.0f, -100.0f, "Commander target: " + commanderTargetName);
        RenderingUtils.renderBillboardText(matrixStack, (IRenderTypeBuffer)buffer, 120.0f, -90.0f, "Number targets: " + targetsSize);
        AtomicInteger count = new AtomicInteger();
        targets.forEach(m -> {
            int counter = count.incrementAndGet();
            if (counter > 7) {
                return;
            }
            String targetName = m.func_200200_C_().func_150261_e();
            String text = "Target: " + targetName;
            RenderingUtils.renderBillboardText(matrixStack, (IRenderTypeBuffer)buffer, 120.0f, -80 + counter * 10, text);
        });
    }

    static String getCommanderTargetName(PlayerEntity player) {
        TargetRepository repository = BassebombeCraft.getProxy().getServerTargetRepository();
        Optional<LivingEntity> optTarget = repository.getFirst(player);
        if (!optTarget.isPresent()) {
            return "N/A";
        }
        LivingEntity target = optTarget.get();
        return target.func_200200_C_().func_150261_e();
    }
}

