/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.client.event.rendering;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.client.player.ClientPlayerUtils;
import bassebombecraft.client.rendering.rendertype.RenderTypes;
import bassebombecraft.entity.ai.AiUtils;
import bassebombecraft.event.entity.team.TeamRepository;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.item.RegisteredItems;
import bassebombecraft.player.PlayerUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.event.RenderLivingEvent;

public class TeamEnityRenderer {
    public static void handleRenderLivingEvent(RenderLivingEvent.Pre<PlayerEntity, PlayerModel<PlayerEntity>> event) {
        try {
            if (!ClientPlayerUtils.isClientSidePlayerDefined()) {
                return;
            }
            PlayerEntity player = ClientPlayerUtils.getClientSidePlayer();
            if (!PlayerUtils.isItemInHotbar(player, (Item)RegisteredItems.HUD.get())) {
                return;
            }
            TeamRepository repository = BassebombeCraft.getProxy().getServerTeamRepository();
            if (!repository.isMember((LivingEntity)player, event.getEntity())) {
                return;
            }
            TeamEnityRenderer.render(event.getMatrixStack(), event.getEntity());
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    static void render(MatrixStack matrixStack, LivingEntity entity) {
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        float height = entity.func_213302_cg();
        TeamEnityRenderer.renderText(matrixStack, (IRenderTypeBuffer)buffer, 0.0f, 0.0f, "TEAM");
        TeamEnityRenderer.renderText(matrixStack, (IRenderTypeBuffer)buffer, 0.0f, -10.0f, AiUtils.getFirstRunningAiGoalName(entity));
        TeamEnityRenderer.renderText(matrixStack, (IRenderTypeBuffer)buffer, 0.0f, -20.0f, AiUtils.getFirstRunningAiTargetGoalName(entity));
        float w = (float)GeometryUtils.oscillate(-10.0f, 10.0f);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, (double)height, 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        Matrix4f positionMatrix = matrixStack.func_227866_c_().func_227870_a_();
        IVertexBuilder builder = buffer.getBuffer(RenderTypes.OVERLAY_LINES);
        TeamEnityRenderer.renderTriangle(builder, positionMatrix);
        matrixStack.func_227865_b_();
        RenderSystem.disableDepthTest();
        buffer.func_228462_a_(RenderTypes.OVERLAY_LINES);
    }

    static void renderText(MatrixStack matrixStack, IRenderTypeBuffer buffer, float x, float y, String text) {
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        FontRenderer fontrenderer = renderManager.func_78716_a();
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(0.02f, 0.02f, 0.02f);
        matrixStack.func_227863_a_(renderManager.func_229098_b_());
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        Matrix4f positionMatrix = matrixStack.func_227866_c_().func_227870_a_();
        fontrenderer.func_228079_a_(text, x, y, 49152, false, positionMatrix, buffer, false, 0, 0xF000F0);
        matrixStack.func_227865_b_();
    }

    public static void renderTriangle(IVertexBuilder builder, Matrix4f positionMatrix) {
        TeamEnityRenderer.addWhiteVertex(builder, positionMatrix, -0.5f, 0.0f, 0.0f);
        TeamEnityRenderer.addWhiteVertex(builder, positionMatrix, 0.5f, 0.0f, 0.0f);
        TeamEnityRenderer.addWhiteVertex(builder, positionMatrix, 0.5f, 0.0f, 0.0f);
        TeamEnityRenderer.addWhiteVertex(builder, positionMatrix, 0.5f, -1.0f, 0.0f);
        TeamEnityRenderer.addWhiteVertex(builder, positionMatrix, 0.5f, -1.0f, 0.0f);
        TeamEnityRenderer.addWhiteVertex(builder, positionMatrix, 0.0f, -1.25f, 0.0f);
        TeamEnityRenderer.addWhiteVertex(builder, positionMatrix, 0.0f, -1.25f, 0.0f);
        TeamEnityRenderer.addWhiteVertex(builder, positionMatrix, -0.5f, -1.0f, 0.0f);
        TeamEnityRenderer.addWhiteVertex(builder, positionMatrix, -0.5f, -1.0f, 0.0f);
        TeamEnityRenderer.addWhiteVertex(builder, positionMatrix, -0.5f, 0.0f, 0.0f);
    }

    static void addWhiteVertex(IVertexBuilder builder, Matrix4f positionMatrix, float x, float y, float z) {
        builder.func_227888_a_(positionMatrix, x, y, z).func_227885_a_(0.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
    }

    static void addWhiteVertex(IVertexBuilder builder, Matrix4f positionMatrix, double x, double y, double z) {
        TeamEnityRenderer.addWhiteVertex(builder, positionMatrix, (float)x, (float)y, (float)z);
    }
}

