/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.client.event.rendering.effect;

import bassebombecraft.client.event.rendering.effect.GraphicalEffect;
import bassebombecraft.operator.Operator2;
import bassebombecraft.operator.Operators2;
import bassebombecraft.operator.Ports;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.vector.Vector3d;

public class ClientGraphicalEffect
implements GraphicalEffect {
    final int sourceId;
    Entity source;
    final Entity target;
    final String id;
    final int duration;
    final Operator2 effectOp;
    Vector3d[] vectors = new Vector3d[0];

    ClientGraphicalEffect(Entity source, Entity target, int duration, Operator2 effectOp) {
        this.source = source;
        this.target = target;
        this.effectOp = effectOp;
        this.id = Integer.toString(this.hashCode());
        this.duration = duration;
        this.sourceId = Integer.MIN_VALUE;
    }

    ClientGraphicalEffect(int sourceId, Entity target, int duration, Operator2 effectOp) {
        this.sourceId = sourceId;
        this.target = target;
        this.effectOp = effectOp;
        this.id = Integer.toString(this.hashCode());
        this.duration = duration;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void render(Ports ports) {
        if (this.source != null) {
            this.doRender(ports);
            return;
        }
        Minecraft mcClient = Minecraft.func_71410_x();
        this.source = mcClient.field_71441_e.func_73045_a(this.sourceId);
    }

    void doRender(Ports ports) {
        ports.setEntity1(this.source);
        ports.setEntity2(this.target);
        ports.setVectors1(this.vectors);
        Operators2.run(ports, this.effectOp);
        this.vectors = ports.getVectors1();
    }

    public static GraphicalEffect getInstance(Entity source, Entity target, int duration, Operator2 effectOp) {
        return new ClientGraphicalEffect(source, target, duration, effectOp);
    }

    public static GraphicalEffect getInstance(int sourceId, Entity target, int duration, Operator2 effectOp) {
        return new ClientGraphicalEffect(sourceId, target, duration, effectOp);
    }
}

