/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.client.event.rendering.effect;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.ClientModConstants;
import bassebombecraft.client.event.rendering.effect.ClientGraphicalEffect;
import bassebombecraft.client.event.rendering.effect.GraphicalEffect;
import bassebombecraft.client.event.rendering.effect.GraphicalEffectRepository;
import bassebombecraft.client.operator.rendering.InitColor2;
import bassebombecraft.client.operator.rendering.InitElectrocute2;
import bassebombecraft.client.operator.rendering.InitLineRenderingFromPorts2;
import bassebombecraft.client.operator.rendering.InitProjectileTrailRendering2;
import bassebombecraft.client.operator.rendering.RenderLine2;
import bassebombecraft.client.operator.rendering.RenderLineWithDynamicColor2;
import bassebombecraft.client.rendering.rendertype.RenderTypes;
import bassebombecraft.event.duration.DurationRepository;
import bassebombecraft.operator.DefaultPorts;
import bassebombecraft.operator.NullOp2;
import bassebombecraft.operator.Operator2;
import bassebombecraft.operator.Sequence2;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;

public class ClientGraphicalEffectRepository
implements GraphicalEffectRepository {
    static final Operator2 DEFAULT_OPERATOR = new NullOp2();
    static final Operator2 ELECTROCUTE_OPERATOR = new Sequence2(new InitElectrocute2(), new InitColor2(DefaultPorts.getBcSetColor4f1(), ClientModConstants.LIGHTNING_LINE_COLOR1, ClientModConstants.LIGHTNING_LINE_COLOR2), new RenderLineWithDynamicColor2(DefaultPorts.getFnGetColor4f1(), RenderTypes.LIGHTNING_LINES));
    static final Operator2 PROJECTILE_TRAIL_OPERATOR = new Sequence2(new InitProjectileTrailRendering2(), new InitColor2(DefaultPorts.getBcSetColor4f1(), ClientModConstants.PROJECTILE_TRAIL_LINE_COLOR1, ClientModConstants.PROJECTILE_TRAIL_LINE_COLOR2), new RenderLineWithDynamicColor2(DefaultPorts.getFnGetColor4f1(), RenderTypes.PROJECTILE_TRAIL_LINES));
    static final Operator2 LINE_OPERATOR = new Sequence2(new InitLineRenderingFromPorts2(), new RenderLine2(ClientModConstants.DEFAULT_LINE_COLOR, RenderTypes.SIMPLE_LINES));
    Consumer<String> cRemovalCallback = id -> this.remove((String)id);
    Map<String, GraphicalEffect> effects = new ConcurrentHashMap<String, GraphicalEffect>();

    @Override
    public void add(Entity source, Entity target, int duration, GraphicalEffectRepository.Effect effect) {
        Operator2 effectOp = this.resolveOperator(effect);
        GraphicalEffect effectObject = ClientGraphicalEffect.getInstance(source, target, duration, effectOp);
        if (this.contains(effectObject.getId())) {
            return;
        }
        DurationRepository repository = BassebombeCraft.getProxy().getClientDurationRepository();
        repository.add(effectObject.getId(), duration, this.cRemovalCallback);
        this.effects.put(effectObject.getId(), effectObject);
    }

    @Override
    public void addUnresolvedSource(int sourceId, Entity target, int duration, GraphicalEffectRepository.Effect effect) {
        Operator2 effectOp = this.resolveOperator(effect);
        GraphicalEffect effectObject = ClientGraphicalEffect.getInstance(sourceId, target, duration, effectOp);
        if (this.contains(effectObject.getId())) {
            return;
        }
        DurationRepository repository = BassebombeCraft.getProxy().getClientDurationRepository();
        repository.add(effectObject.getId(), duration, this.cRemovalCallback);
        this.effects.put(effectObject.getId(), effectObject);
    }

    Operator2 resolveOperator(GraphicalEffectRepository.Effect effect) {
        switch (effect) {
            case NO_EFFECT: {
                return DEFAULT_OPERATOR;
            }
            case LINE: {
                return LINE_OPERATOR;
            }
            case ELECTROCUTE: {
                return ELECTROCUTE_OPERATOR;
            }
            case PROJECTILE_TRAIL: {
                return PROJECTILE_TRAIL_OPERATOR;
            }
        }
        return DEFAULT_OPERATOR;
    }

    @Override
    public void remove(String id) {
        if (!this.contains(id)) {
            return;
        }
        this.effects.remove(id);
    }

    @Override
    public boolean contains(String id) {
        return this.effects.containsKey(id);
    }

    @Override
    public Stream<GraphicalEffect> get() {
        return this.effects.values().stream();
    }

    public static GraphicalEffectRepository getInstance() {
        return new ClientGraphicalEffectRepository();
    }
}

