/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.client.operator.rendering;

import bassebombecraft.ClientModConstants;
import bassebombecraft.client.operator.ClientOperators2;
import bassebombecraft.client.operator.ClientPorts;
import bassebombecraft.client.operator.DefaultClientPorts;
import bassebombecraft.client.rendering.rendertype.RenderTypes;
import bassebombecraft.operator.DefaultPorts;
import bassebombecraft.operator.Operator2;
import bassebombecraft.operator.Operators2;
import bassebombecraft.operator.Ports;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector4f;

public class RenderLine2
implements Operator2 {
    Vector4f color;
    RenderType renderType;
    Function<ClientPorts, MatrixStack> fnGetMatrixStack = DefaultClientPorts.getFnMaxtrixStack1();
    Function<Ports, Vector3d[]> fnGetLineVertexes = DefaultPorts.getFnGetVectors1();

    public RenderLine2() {
        this.color = ClientModConstants.DEFAULT_LINE_COLOR;
        this.renderType = RenderTypes.DEFAULT_LINES;
    }

    public RenderLine2(Vector4f color, RenderType renderType) {
        this();
        this.color = color;
        this.renderType = renderType;
    }

    @Override
    public void run(Ports ports) {
        MatrixStack matrixStack = ClientOperators2.clientApplyV(this.fnGetMatrixStack, ports);
        Vector3d[] positions = Operators2.applyV(this.fnGetLineVertexes, ports);
        if (positions.length < 2) {
            return;
        }
        Minecraft mcClient = Minecraft.func_71410_x();
        IRenderTypeBuffer.Impl buffer = mcClient.func_228019_au_().func_228487_b_();
        IVertexBuilder builder = buffer.getBuffer(this.renderType);
        matrixStack.func_227860_a_();
        Vector3d projectedView = mcClient.field_71460_t.func_215316_n().func_216785_c();
        matrixStack.func_227861_a_(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c);
        Matrix4f positionMatrix = matrixStack.func_227866_c_().func_227870_a_();
        for (int index = 0; index < positions.length - 1; ++index) {
            Vector3d start = positions[index];
            Vector3d end = positions[index + 1];
            this.renderLine(start, end, builder, positionMatrix);
        }
        matrixStack.func_227865_b_();
        RenderSystem.disableDepthTest();
        buffer.func_228462_a_(this.renderType);
    }

    void renderLine(Vector3d start, Vector3d end, IVertexBuilder builder, Matrix4f positionMatrix) {
        this.addVertex(builder, positionMatrix, start.field_72450_a, start.field_72448_b, start.field_72449_c);
        this.addVertex(builder, positionMatrix, end.field_72450_a, end.field_72448_b, end.field_72449_c);
    }

    void addVertex(IVertexBuilder builder, Matrix4f positionMatrix, float x, float y, float z) {
        builder.func_227888_a_(positionMatrix, x, y, z).func_227885_a_(this.color.func_195910_a(), this.color.func_195913_b(), this.color.func_195914_c(), this.color.func_195915_d()).func_181675_d();
    }

    void addVertex(IVertexBuilder builder, Matrix4f positionMatrix, double x, double y, double z) {
        this.addVertex(builder, positionMatrix, (float)x, (float)y, (float)z);
    }
}

