/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.config;

import bassebombecraft.config.ParticlesConfig;
import bassebombecraft.config.SoundConfig;
import bassebombecraft.sound.RegisteredSounds;
import java.util.function.Supplier;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.ForgeConfigSpec;

public class InventoryItemConfig {
    public ForgeConfigSpec.ConfigValue<String> tooltip;
    public ForgeConfigSpec.IntValue cooldown;
    public ForgeConfigSpec.IntValue range;
    public ParticlesConfig particles;
    public SoundConfig sound;

    public InventoryItemConfig(ForgeConfigSpec.Builder builder, String name, String tooltip, int cooldown, int range, Supplier<ParticlesConfig> splParticles, Supplier<SoundConfig> splSound) {
        builder.comment(name + " settings").push(name);
        this.tooltip = builder.comment("Tooltip for item.").define("tooltip", (Object)tooltip);
        this.cooldown = builder.comment("Game ticks between item activation.").defineInRange("cooldown", cooldown, 0, Integer.MAX_VALUE);
        this.range = builder.comment("Item activation range in blocks. 1 = Not an AOE effect. ").defineInRange("range", range, 0, Integer.MAX_VALUE);
        this.particles = splParticles.get();
        this.sound = splSound.get();
        builder.pop();
    }

    public Supplier<SoundEvent> getSplSound() {
        return this.sound.getSplSound();
    }

    public static InventoryItemConfig getInstance(ForgeConfigSpec.Builder builder, String name, String tooltip, int cooldown, int range, Supplier<ParticlesConfig> splParticles) {
        return new InventoryItemConfig(builder, name, tooltip, cooldown, range, splParticles, () -> new SoundConfig(builder, RegisteredSounds.DEFAULT_SOUND));
    }

    public static InventoryItemConfig getInstance(ForgeConfigSpec.Builder builder, String name, String tooltip, int cooldown, int range, Supplier<ParticlesConfig> splParticles, Supplier<SoundConfig> splSound) {
        return new InventoryItemConfig(builder, name, tooltip, cooldown, range, splParticles, splSound);
    }

    public static InventoryItemConfig getInstanceWithNoRange(ForgeConfigSpec.Builder builder, String name, String tooltip, int cooldown, Supplier<ParticlesConfig> splParticles) {
        return new InventoryItemConfig(builder, name, tooltip, cooldown, 1, splParticles, () -> new SoundConfig(builder, RegisteredSounds.DEFAULT_SOUND));
    }

    public static InventoryItemConfig getInstanceWithNoRange(ForgeConfigSpec.Builder builder, String name, String tooltip, int cooldown, Supplier<ParticlesConfig> splParticles, Supplier<SoundConfig> splSound) {
        return new InventoryItemConfig(builder, name, tooltip, cooldown, 1, splParticles, splSound);
    }
}

