/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.config;

import bassebombecraft.config.SoundConfig;
import bassebombecraft.sound.RegisteredSounds;
import java.util.function.Supplier;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.ForgeConfigSpec;

public class ItemConfig {
    public ForgeConfigSpec.ConfigValue<String> tooltip;
    public ForgeConfigSpec.IntValue cooldown;
    public SoundConfig sound;

    public ItemConfig(ForgeConfigSpec.Builder builder, String name, String tooltip, int cooldown, Supplier<SoundConfig> splSound) {
        builder.comment(name + " settings").push(name);
        this.tooltip = builder.comment("Tooltip for item.").define("tooltip", (Object)tooltip);
        this.cooldown = builder.comment("Game ticks between item activation.").defineInRange("cooldown", cooldown, 0, Integer.MAX_VALUE);
        this.sound = splSound.get();
        builder.pop();
    }

    public String getToolTip() {
        return (String)this.tooltip.get();
    }

    int getCoolDown() {
        return (Integer)this.cooldown.get();
    }

    public Supplier<SoundEvent> getSplSound() {
        return this.sound.getSplSound();
    }

    public static ItemConfig getInstance(ForgeConfigSpec.Builder builder, String name, String tooltip, int cooldown) {
        return new ItemConfig(builder, name, tooltip, cooldown, () -> new SoundConfig(builder, RegisteredSounds.DEFAULT_SOUND));
    }

    public static ItemConfig getInstance(ForgeConfigSpec.Builder builder, String name, String tooltip, int cooldown, Supplier<SoundConfig> splSound) {
        return new ItemConfig(builder, name, tooltip, cooldown, splSound);
    }
}

