/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.entity;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.event.entity.target.TargetRepository;
import bassebombecraft.player.PlayerDirection;
import bassebombecraft.player.PlayerUtils;
import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class EntityUtils {
    static final float PITCH = 0.0f;

    public static void setProjectileEntityPosition(LivingEntity entity, LivingEntity projectileEntity, int spawnDisplacement) {
        Vector3d lookVec = entity.func_70040_Z();
        double x = entity.func_226277_ct_() + lookVec.field_72450_a * (double)spawnDisplacement;
        double y = entity.func_226278_cu_() + (double)entity.func_70047_e();
        double z = entity.func_226281_cx_() + lookVec.field_72449_c * (double)spawnDisplacement;
        projectileEntity.func_70107_b(x, y, z);
        projectileEntity.field_70177_z = projectileEntity.field_70759_as = entity.field_70177_z;
        projectileEntity.field_70126_B = projectileEntity.field_70759_as;
        projectileEntity.field_70127_C = projectileEntity.field_70125_A = entity.field_70125_A;
    }

    public static void explode(LivingEntity entity, World world, int size) {
        world.func_217385_a((Entity)entity, (double)entity.func_233580_cy_().func_177958_n(), (double)entity.func_233580_cy_().func_177956_o(), (double)entity.func_233580_cy_().func_177952_p(), (float)size, Explosion.Mode.DESTROY);
    }

    public static void killEntity(LivingEntity entity) {
        entity.func_174812_G();
    }

    public static boolean isType(Entity entity, Class<?> type) {
        Optional<Entity> oe = Optional.ofNullable(entity);
        if (oe.isPresent()) {
            return type.isInstance(oe.get());
        }
        return false;
    }

    public static boolean isTypeCreatureEntity(Entity entity) {
        Optional<Entity> oe = Optional.ofNullable(entity);
        if (oe.isPresent()) {
            return oe.get() instanceof CreatureEntity;
        }
        return false;
    }

    public static boolean isTypeMobEntity(Entity entity) {
        Optional<Entity> oe = Optional.ofNullable(entity);
        if (oe.isPresent()) {
            return oe.get() instanceof MobEntity;
        }
        return false;
    }

    public static boolean isTypeLivingEntity(Entity entity) {
        Optional<Entity> oe = Optional.ofNullable(entity);
        if (oe.isPresent()) {
            return oe.get() instanceof LivingEntity;
        }
        return false;
    }

    public static boolean isTypeCreeperEntity(Entity entity) {
        Optional<Entity> oe = Optional.ofNullable(entity);
        if (oe.isPresent()) {
            return oe.get() instanceof CreeperEntity;
        }
        return false;
    }

    public static boolean isTypeParrotEntity(Entity entity) {
        Optional<Entity> oe = Optional.ofNullable(entity);
        if (oe.isPresent()) {
            return oe.get() instanceof ParrotEntity;
        }
        return false;
    }

    public static boolean isTypeBeeEntity(Entity entity) {
        Optional<Entity> oe = Optional.ofNullable(entity);
        if (oe.isPresent()) {
            return oe.get() instanceof BeeEntity;
        }
        return false;
    }

    public static double calculateEntityFeetPositition(Entity entity) {
        return entity.func_226278_cu_() - entity.func_70033_W();
    }

    public static int calculateEntityFeetPosititionAsInt(Entity entity) {
        return (int)EntityUtils.calculateEntityFeetPositition(entity);
    }

    public static PlayerDirection getEntityDirection(Entity entity) {
        int direction = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        return PlayerDirection.getById(direction);
    }

    public static boolean hasAliveTarget(LivingEntity entity) {
        Optional<LivingEntity> target = EntityUtils.getNullableTarget(entity);
        if (target.isPresent()) {
            return target.get().func_70089_S();
        }
        return false;
    }

    public static boolean hasTarget(LivingEntity entity) {
        Optional<LivingEntity> target = EntityUtils.getNullableTarget(entity);
        return target.isPresent();
    }

    public static Optional<LivingEntity> getNullableTarget(LivingEntity entity) {
        if (EntityUtils.isTypeCreatureEntity((Entity)entity)) {
            CreatureEntity creatureEntity = (CreatureEntity)entity;
            return Optional.ofNullable(creatureEntity.func_70638_az());
        }
        return Optional.ofNullable(entity.func_110144_aD());
    }

    public static LivingEntity getTarget(LivingEntity entity) {
        if (EntityUtils.isTypeCreatureEntity((Entity)entity)) {
            CreatureEntity typedEntity = (CreatureEntity)entity;
            return typedEntity.func_70638_az();
        }
        return entity.func_110144_aD();
    }

    public static boolean supportTargeting(Entity entity) {
        if (EntityUtils.isTypeCreatureEntity(entity)) {
            return true;
        }
        return EntityUtils.isTypeLivingEntity(entity);
    }

    public static void setTarget(Entity entity, LivingEntity newTarget) {
        if (EntityUtils.isTypeCreatureEntity(entity)) {
            CreatureEntity creatureEntity = (CreatureEntity)entity;
            creatureEntity.func_70624_b(newTarget);
            return;
        }
        if (EntityUtils.isTypeLivingEntity(entity)) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.func_130011_c((Entity)newTarget);
            livingEntity.func_70604_c(newTarget);
        }
    }

    public static LivingEntity resolveTarget(Entity target, LivingEntity invoker) {
        try {
            if (PlayerUtils.isTypePlayerEntity((Entity)invoker)) {
                PlayerEntity player = (PlayerEntity)invoker;
                TargetRepository repository = BassebombeCraft.getProxy().getServerTargetRepository();
                Optional<LivingEntity> optTarget = repository.getFirst(player);
                if (optTarget.isPresent()) {
                    return optTarget.get();
                }
            }
            if (EntityUtils.isTypeLivingEntity(target)) {
                return (LivingEntity)target;
            }
            return null;
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
            return null;
        }
    }

    public static void setMobEntityAggroed(Entity entity) {
        if (EntityUtils.isTypeMobEntity(entity)) {
            MobEntity mobEntity = (MobEntity)entity;
            mobEntity.func_213395_q(true);
        }
    }

    public static void setRandomSpawnPosition(BlockPos pos, float rotationYaw, int spawnArea, LivingEntity entity) {
        EntityUtils.setRandomSpawnPosition(pos, rotationYaw, spawnArea, (Entity)entity);
    }

    public static void setRandomSpawnPosition(BlockPos pos, float rotationYaw, int spawnArea, Entity entity) {
        Random random = BassebombeCraft.getBassebombeCraft().getRandom();
        int randomX = random.nextInt(spawnArea) - spawnArea / 2;
        int randomZ = random.nextInt(spawnArea) - spawnArea / 2;
        double positionX = pos.func_177958_n() + randomX;
        double positionY = pos.func_177956_o();
        double positionZ = pos.func_177952_p() + randomZ;
        entity.func_70012_b(positionX, positionY, positionZ, rotationYaw, 0.0f);
    }

    public static float calculateRandomYaw() {
        return BassebombeCraft.getBassebombeCraft().getRandom().nextFloat() * 360.0f;
    }

    public static void selfDestruct(MobEntity entity) {
        entity.func_70015_d(1000);
        entity.func_70606_j(0.0f);
    }

    public static void selfDestruct(LivingEntity entity) {
        entity.func_70015_d(1000);
        entity.func_70606_j(0.0f);
    }

    public static boolean isMinimumDistanceReached(Entity entity, Entity entity2, double minDistanceSqr) {
        double distSqr = entity.func_70068_e(entity2);
        return minDistanceSqr > distSqr;
    }

    public static void setAttribute(LivingEntity entity, Attribute attribute, double value) {
        ModifiableAttributeInstance instance = entity.func_110148_a(attribute);
        instance.func_111128_a(value);
    }

    public static boolean isEntityAttributeSet(LivingEntity entity, Attribute attribute) {
        ModifiableAttributeInstance instance = entity.func_110148_a(attribute);
        return instance.func_111126_e() == 1.0;
    }
}

