/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.entity.ai;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.entity.EntityUtils;
import bassebombecraft.entity.ai.goal.AttackInRangeGoal;
import bassebombecraft.entity.ai.goal.ChargeTowardsGoal;
import bassebombecraft.entity.ai.goal.CommanderControlledTargeting;
import bassebombecraft.entity.ai.goal.CommandersTargetGoal;
import bassebombecraft.entity.ai.goal.CompanionAttack;
import bassebombecraft.entity.ai.goal.FollowEntityGoal;
import bassebombecraft.entity.ai.goal.SelfdestructWhenTargetDiesGoal;
import bassebombecraft.event.duration.DurationRepository;
import bassebombecraft.player.PlayerUtils;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.CreeperSwellGoal;
import net.minecraft.entity.ai.goal.FleeSunGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.OcelotAttackGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AiUtils {
    static final int INITIAL_GOAL_PRIORITY = 0;
    static final double AI_MOVE_SPEED = 1.5;
    static final float AI_MIN_DIST = 6.0f;
    static final float AI_MAX_DIST = 50.0f;
    static final int AI_MIN_CHARGE_DISTANCE = 1;
    static Logger logger = LogManager.getLogger(BassebombeCraft.class);

    public static Set<PrioritizedGoal> captureGoals(GoalSelector selector) {
        try {
            return selector.field_220892_d;
        }
        catch (Exception e) {
            logger.error("Failed to capture goals due to the error: " + e.getMessage());
            BassebombeCraft.getBassebombeCraft().reportException(e);
            return Sets.newLinkedHashSet();
        }
    }

    public static void clearAllAiGoals(MobEntity entity) {
        AiUtils.removeGoals(entity.field_70714_bg);
        AiUtils.removeGoals(entity.field_70715_bh);
    }

    static void removeGoals(GoalSelector selector) {
        try {
            Set goals = selector.field_220892_d;
            goals.forEach(g -> selector.func_85156_a((Goal)g));
        }
        catch (Exception e) {
            logger.error("Failed to remove goals due to the error: " + e.getMessage());
            BassebombeCraft.getBassebombeCraft().reportException(e);
        }
    }

    public static void assignAiGoals(MobEntity entity, Set<PrioritizedGoal> goals) {
        try {
            GoalSelector selector = entity.field_70714_bg;
            selector.field_220892_d.addAll(goals);
        }
        catch (Exception e) {
            logger.error("Failed to assign goals due to the error: " + e.getMessage());
            BassebombeCraft.getBassebombeCraft().reportException(e);
        }
    }

    public static void assignAiTargetGoals(MobEntity entity, Set<PrioritizedGoal> goals) {
        try {
            GoalSelector selector = entity.field_70715_bh;
            selector.field_220892_d.addAll(goals);
        }
        catch (Exception e) {
            logger.error("Failed to assign goals due to the error: " + e.getMessage());
            BassebombeCraft.getBassebombeCraft().reportException(e);
        }
    }

    public static void buildCharmedMobAi(MobEntity entity, LivingEntity commander) {
        GoalSelector selector = entity.field_70714_bg;
        selector.func_75776_a(0, (Goal)new SwimGoal(entity));
        if (PlayerUtils.isTypePlayerEntity((Entity)commander)) {
            PlayerEntity player = (PlayerEntity)commander;
            selector.func_75776_a(2, (Goal)new CompanionAttack(entity, player));
        } else {
            selector.func_75776_a(2, (Goal)new CompanionAttack(entity));
        }
        selector.func_75776_a(3, (Goal)new FollowEntityGoal(entity, commander, 1.5, 6.0f, 50.0f));
        selector.func_75776_a(5, (Goal)new LookRandomlyGoal(entity));
        if (!EntityUtils.isTypeCreatureEntity((Entity)entity)) {
            return;
        }
        CreatureEntity entityCreature = (CreatureEntity)CreatureEntity.class.cast(entity);
        AiUtils.setupTargetingTasks(entityCreature, commander);
    }

    public static void buildKittenArmyAi(CatEntity entity, LivingEntity commander) {
        GoalSelector selector = entity.field_70714_bg;
        selector.func_75776_a(1, (Goal)new SwimGoal((MobEntity)entity));
        selector.func_75776_a(2, (Goal)new LeapAtTargetGoal((MobEntity)entity, 0.3f));
        selector.func_75776_a(3, (Goal)new OcelotAttackGoal((MobEntity)entity));
        selector.func_75776_a(4, (Goal)new FollowEntityGoal((MobEntity)entity, commander, 1.5, 6.0f, 50.0f));
        selector.func_75776_a(5, (Goal)new SitGoal((TameableEntity)entity));
        selector.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)entity));
        CreatureEntity entityCreature = (CreatureEntity)CreatureEntity.class.cast(entity);
        AiUtils.setupTargetingTasks(entityCreature, commander);
    }

    public static void buildSkeletonArmyAi(SkeletonEntity entity, LivingEntity commander) {
        GoalSelector selector = entity.field_70714_bg;
        selector.func_75776_a(1, (Goal)new SwimGoal((MobEntity)entity));
        selector.func_75776_a(2, (Goal)new FleeSunGoal((CreatureEntity)entity, 1.0));
        selector.func_75776_a(3, (Goal)new RangedBowAttackGoal((MonsterEntity)entity, 1.0, 20, 15.0f));
        selector.func_75776_a(4, (Goal)new FollowEntityGoal((MobEntity)entity, commander, 1.5, 6.0f, 50.0f));
        selector.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)entity, PlayerEntity.class, 8.0f));
        selector.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)entity));
        CreatureEntity entityCreature = (CreatureEntity)CreatureEntity.class.cast(entity);
        AiUtils.setupTargetingTasks(entityCreature, commander);
    }

    public static void buildChargingAi(MobEntity entity, LivingEntity target, float damage) {
        GoalSelector selector = entity.field_70714_bg;
        selector.func_75776_a(1, (Goal)new ChargeTowardsGoal(entity, target, 1));
        selector.func_75776_a(2, (Goal)new AttackInRangeGoal(entity, target, 1.0f, damage));
        GoalSelector targetSelector = entity.field_70715_bh;
        targetSelector.func_75776_a(1, (Goal)new SelfdestructWhenTargetDiesGoal(entity, target));
    }

    public static void buildCreeperArmyAi(CreeperEntity entity, LivingEntity commander) {
        GoalSelector selector = entity.field_70714_bg;
        selector.func_75776_a(1, (Goal)new SwimGoal((MobEntity)entity));
        selector.func_75776_a(2, (Goal)new CreeperSwellGoal(entity));
        selector.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)entity, 1.0, false));
        selector.func_75776_a(4, (Goal)new FollowEntityGoal((MobEntity)entity, commander, 1.5, 6.0f, 50.0f));
        selector.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)entity, PlayerEntity.class, 8.0f));
        selector.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)entity));
        CreatureEntity entityCreature = (CreatureEntity)CreatureEntity.class.cast(entity);
        AiUtils.setupTargetingTasks(entityCreature, commander);
    }

    static void setupTargetingTasks(CreatureEntity entity, LivingEntity commander) {
        if (PlayerUtils.isTypePlayerEntity((Entity)commander)) {
            PlayerEntity player = (PlayerEntity)commander;
            GoalSelector selector = entity.field_70715_bh;
            selector.func_75776_a(0, (Goal)new CommanderControlledTargeting(entity, (LivingEntity)player));
            return;
        }
        GoalSelector selector = entity.field_70715_bh;
        selector.func_75776_a(0, (Goal)new CommanderControlledTargeting(entity, commander));
        selector.func_75776_a(1, (Goal)new CommandersTargetGoal(entity, commander));
        selector.func_75776_a(2, (Goal)new HurtByTargetGoal(entity, new Class[0]));
    }

    public static String getFirstRunningAiTargetGoalName(LivingEntity entity) {
        if (!EntityUtils.isTypeMobEntity((Entity)entity)) {
            return "AI Target Goal: N/A";
        }
        MobEntity mobEntity = (MobEntity)entity;
        Stream targetGoals = mobEntity.field_70715_bh.func_220888_c();
        Optional optFirstGoal = targetGoals.findFirst();
        if (optFirstGoal.isPresent()) {
            PrioritizedGoal goal = (PrioritizedGoal)optFirstGoal.get();
            Goal embbedGoal = goal.func_220772_j();
            return "AI Target Goal: " + embbedGoal.getClass().getSimpleName();
        }
        return "AI Target Goal: N/A";
    }

    public static String getFirstRunningAiGoalName(LivingEntity entity) {
        if (!EntityUtils.isTypeMobEntity((Entity)entity)) {
            return "AI Goal: N/A";
        }
        MobEntity mobEntity = (MobEntity)entity;
        Stream targetGoals = mobEntity.field_70714_bg.func_220888_c();
        Optional optFirstGoal = targetGoals.findFirst();
        if (optFirstGoal.isPresent()) {
            PrioritizedGoal goal = (PrioritizedGoal)optFirstGoal.get();
            Goal embbedGoal = goal.func_220772_j();
            return "AI Goal: " + embbedGoal.getClass().getSimpleName();
        }
        return "AI Goal: N/A";
    }

    public static void setMutexFlagsforTargetingGoal(Goal goal) {
        goal.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
    }

    public static void setMutexFlagsforAttackGoal(Goal goal) {
        goal.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public static void setMutexFlagsforMovementGoal(Goal goal) {
        goal.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public static int getCharmDuration(String id, DurationRepository repository) {
        try {
            if (repository.isExpired(id)) {
                return 0;
            }
            return repository.get(id);
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
            return 0;
        }
    }
}

