/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.entity.ai.goal;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.entity.EntityUtils;
import bassebombecraft.entity.ai.goal.DefaultFacts;
import bassebombecraft.entity.ai.goal.DefaultObservationRepository;
import bassebombecraft.entity.ai.goal.Observation;
import bassebombecraft.entity.ai.goal.ObservationRepository;
import bassebombecraft.entity.ai.goal.SituationalFacts;
import bassebombecraft.event.frequency.FrequencyRepository;
import bassebombecraft.item.action.RightClickedItemAction;
import bassebombecraft.item.action.ShootBaconBazooka;
import bassebombecraft.item.action.ShootCreeperCannon;
import bassebombecraft.item.action.ShootGenericEggProjectile;
import bassebombecraft.item.action.mist.entity.EntityMistActionStrategy;
import bassebombecraft.item.action.mist.entity.GenericEntityMist;
import bassebombecraft.item.action.mist.entity.LightningBoltMist;
import bassebombecraft.item.action.mist.entity.ToxicMist;
import bassebombecraft.item.action.mist.entity.VacuumMist;
import bassebombecraft.operator.DefaultPorts;
import bassebombecraft.operator.Operator2;
import bassebombecraft.operator.Sequence2;
import bassebombecraft.operator.entity.raytraceresult.DigMobHole2;
import bassebombecraft.operator.entity.raytraceresult.EmitHorizontalForce2;
import bassebombecraft.operator.entity.raytraceresult.EmitVerticalForce2;
import bassebombecraft.operator.entity.raytraceresult.SpawnAnvil2;
import bassebombecraft.operator.entity.raytraceresult.SpawnCobweb2;
import bassebombecraft.operator.entity.raytraceresult.SpawnIceBlock2;
import bassebombecraft.operator.entity.raytraceresult.SpawnLavaBlock2;
import bassebombecraft.operator.entity.raytraceresult.SpawnLightning2;
import bassebombecraft.operator.entity.raytraceresult.SpawnSquid2;
import bassebombecraft.operator.item.action.ExecuteOperatorAsAction2;
import bassebombecraft.operator.projectile.ShootArrowProjectile2;
import bassebombecraft.operator.projectile.ShootCircleProjectile2;
import bassebombecraft.operator.projectile.ShootFireballProjectile2;
import bassebombecraft.operator.projectile.ShootLargeFireballProjectile2;
import bassebombecraft.operator.projectile.ShootWitherSkullProjectile2;
import bassebombecraft.operator.projectile.formation.SingleProjectileFormation2;
import bassebombecraft.operator.projectile.formation.TrifurcatedProjectileFormation2;
import bassebombecraft.operator.projectile.modifier.TagProjectileWithProjectileModifier;
import bassebombecraft.projectile.action.ProjectileAction;
import bassebombecraft.projectile.action.SpawnFlamingChicken;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.PathNavigator;

public class CompanionAttack
extends Goal {
    static final ProjectileAction FLAMING_CHICKEN_PROJECTILE_ACTION = new SpawnFlamingChicken();
    static final EntityMistActionStrategy SPAWN_VACUUM_MIST_PROJECTILE_ACTION = new VacuumMist();
    static final EntityMistActionStrategy TOXIC_MIST_STRATEGY = new ToxicMist();
    static final EntityMistActionStrategy LIGHTNING_MIST_STRATEGY = new LightningBoltMist();
    static final String CREEPER_CANNON_CONFIG_KEY = ShootCreeperCannon.class.getSimpleName();
    static final boolean ISNT_PRIMED = false;
    double entityMoveSpeed = 1.0;
    static Supplier<Operator2> splLargeFireballOp = () -> {
        SingleProjectileFormation2 formationOp = new SingleProjectileFormation2();
        ShootLargeFireballProjectile2 projectileOp = new ShootLargeFireballProjectile2();
        return new Sequence2(formationOp, projectileOp);
    };
    static Supplier<Operator2> splFireballOp = () -> {
        SingleProjectileFormation2 formationOp = new SingleProjectileFormation2();
        ShootFireballProjectile2 projectileOp = new ShootFireballProjectile2();
        return new Sequence2(formationOp, projectileOp);
    };
    static Supplier<Operator2> splWitherSkullOp = () -> {
        SingleProjectileFormation2 formationOp = new SingleProjectileFormation2();
        ShootWitherSkullProjectile2 projectileOp = new ShootWitherSkullProjectile2();
        return new Sequence2(formationOp, projectileOp);
    };
    static Supplier<Operator2> splArrowsOp = () -> {
        TrifurcatedProjectileFormation2 formationOp = new TrifurcatedProjectileFormation2();
        ShootArrowProjectile2 projectileOp = new ShootArrowProjectile2();
        return new Sequence2(formationOp, projectileOp);
    };
    static Supplier<Operator2> splDigMobHoleOp = () -> {
        SingleProjectileFormation2 formationOp = new SingleProjectileFormation2();
        ShootCircleProjectile2 projectileOp = new ShootCircleProjectile2();
        TagProjectileWithProjectileModifier modifierOp = new TagProjectileWithProjectileModifier(DefaultPorts.getFnGetEntities1(), p -> DigMobHole2.NAME);
        return new Sequence2(formationOp, projectileOp, modifierOp);
    };
    static Supplier<Operator2> splSpawnCobwebOp = () -> {
        SingleProjectileFormation2 formationOp = new SingleProjectileFormation2();
        ShootCircleProjectile2 projectileOp = new ShootCircleProjectile2();
        TagProjectileWithProjectileModifier modifierOp = new TagProjectileWithProjectileModifier(DefaultPorts.getFnGetEntities1(), p -> SpawnCobweb2.NAME);
        return new Sequence2(formationOp, projectileOp, modifierOp);
    };
    static Supplier<Operator2> splSpawnIceBlockOp = () -> {
        SingleProjectileFormation2 formationOp = new SingleProjectileFormation2();
        ShootCircleProjectile2 projectileOp = new ShootCircleProjectile2();
        TagProjectileWithProjectileModifier modifierOp = new TagProjectileWithProjectileModifier(DefaultPorts.getFnGetEntities1(), p -> SpawnIceBlock2.NAME);
        return new Sequence2(formationOp, projectileOp, modifierOp);
    };
    static Supplier<Operator2> splSpawnLavaBlockOp = () -> {
        SingleProjectileFormation2 formationOp = new SingleProjectileFormation2();
        ShootCircleProjectile2 projectileOp = new ShootCircleProjectile2();
        TagProjectileWithProjectileModifier modifierOp = new TagProjectileWithProjectileModifier(DefaultPorts.getFnGetEntities1(), p -> SpawnLavaBlock2.NAME);
        return new Sequence2(formationOp, projectileOp, modifierOp);
    };
    static Supplier<Operator2> splSpawnAnvilOp = () -> {
        SingleProjectileFormation2 formationOp = new SingleProjectileFormation2();
        ShootCircleProjectile2 projectileOp = new ShootCircleProjectile2();
        TagProjectileWithProjectileModifier modifierOp = new TagProjectileWithProjectileModifier(DefaultPorts.getFnGetEntities1(), p -> SpawnAnvil2.NAME);
        return new Sequence2(formationOp, projectileOp, modifierOp);
    };
    static Supplier<Operator2> splEmitHorizontalForceOp = () -> {
        SingleProjectileFormation2 formationOp = new SingleProjectileFormation2();
        ShootCircleProjectile2 projectileOp = new ShootCircleProjectile2();
        TagProjectileWithProjectileModifier modifierOp = new TagProjectileWithProjectileModifier(DefaultPorts.getFnGetEntities1(), p -> EmitHorizontalForce2.NAME);
        return new Sequence2(formationOp, projectileOp, modifierOp);
    };
    static Supplier<Operator2> splEmitVerticalForceOp = () -> {
        SingleProjectileFormation2 formationOp = new SingleProjectileFormation2();
        ShootCircleProjectile2 projectileOp = new ShootCircleProjectile2();
        TagProjectileWithProjectileModifier modifierOp = new TagProjectileWithProjectileModifier(DefaultPorts.getFnGetEntities1(), p -> EmitVerticalForce2.NAME);
        return new Sequence2(formationOp, projectileOp, modifierOp);
    };
    static Supplier<Operator2> splSpawnLigthningOp = () -> {
        SingleProjectileFormation2 formationOp = new SingleProjectileFormation2();
        ShootCircleProjectile2 projectileOp = new ShootCircleProjectile2();
        TagProjectileWithProjectileModifier modifierOp = new TagProjectileWithProjectileModifier(DefaultPorts.getFnGetEntities1(), p -> SpawnLightning2.NAME);
        return new Sequence2(formationOp, projectileOp, modifierOp);
    };
    static Supplier<Operator2> splSpawnSquidOp = () -> {
        SingleProjectileFormation2 formationOp = new SingleProjectileFormation2();
        ShootCircleProjectile2 projectileOp = new ShootCircleProjectile2();
        TagProjectileWithProjectileModifier modifierOp = new TagProjectileWithProjectileModifier(DefaultPorts.getFnGetEntities1(), p -> SpawnSquid2.NAME);
        return new Sequence2(formationOp, projectileOp, modifierOp);
    };
    static List<RightClickedItemAction> longRangeActions = CompanionAttack.initializeLongRangeActions();
    static List<RightClickedItemAction> closeRangeActions = CompanionAttack.initializeCloseRangeActions();
    PlayerEntity commander;
    MobEntity entity;
    SituationalFacts targetFacts = DefaultFacts.getInstance();
    ObservationRepository observationRepository;

    public CompanionAttack(MobEntity entity) {
        this.entity = entity;
        this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        this.observationRepository = DefaultObservationRepository.getInstance((LivingEntity)entity);
    }

    public CompanionAttack(MobEntity entity, PlayerEntity commander) {
        this(entity);
        this.commander = commander;
    }

    public boolean func_75250_a() {
        if (!EntityUtils.hasTarget((LivingEntity)this.entity)) {
            return false;
        }
        Optional<LivingEntity> optTarget = EntityUtils.getNullableTarget((LivingEntity)this.entity);
        if (!optTarget.isPresent()) {
            return false;
        }
        this.observeAndupdateFacts(optTarget.get());
        return optTarget.get().func_70089_S();
    }

    public void func_75246_d() {
        try {
            FrequencyRepository repository = BassebombeCraft.getProxy().getServerFrequencyRepository();
            if (!repository.isActive(10)) {
                return;
            }
            Optional<LivingEntity> optTarget = Optional.ofNullable(EntityUtils.getTarget((LivingEntity)this.entity));
            if (!optTarget.isPresent()) {
                return;
            }
            this.lookAtTarget(optTarget.get());
            PathNavigator navigator = this.entity.func_70661_as();
            if (this.targetFacts.isTargetClose()) {
                navigator.func_75499_g();
            } else {
                this.entity.func_70661_as().func_75497_a((Entity)optTarget.get(), this.entityMoveSpeed);
            }
            if (this.targetFacts.isTargetClose()) {
                this.selectAction(closeRangeActions);
            } else {
                this.selectAction(longRangeActions);
            }
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    public void func_75251_c() {
        this.observationRepository.clear();
    }

    void observeAndupdateFacts(LivingEntity target) {
        Observation observation = this.observationRepository.observe(target);
        if (this.observationRepository.isTooFewObservationsRegistered()) {
            return;
        }
        Stream<Observation> observations = this.observationRepository.get();
        this.targetFacts.update(observations);
    }

    static List<RightClickedItemAction> initializeLongRangeActions() {
        ArrayList<RightClickedItemAction> actions = new ArrayList<RightClickedItemAction>();
        actions.add(ExecuteOperatorAsAction2.getInstance(DefaultPorts.getInstance(), splLargeFireballOp.get()));
        actions.add(ExecuteOperatorAsAction2.getInstance(DefaultPorts.getInstance(), splFireballOp.get()));
        actions.add(ExecuteOperatorAsAction2.getInstance(DefaultPorts.getInstance(), splWitherSkullOp.get()));
        actions.add(ExecuteOperatorAsAction2.getInstance(DefaultPorts.getInstance(), splArrowsOp.get()));
        actions.add(new ShootBaconBazooka());
        actions.add(new ShootCreeperCannon(false));
        actions.add(ExecuteOperatorAsAction2.getInstance(DefaultPorts.getInstance(), splSpawnSquidOp.get()));
        actions.add(ExecuteOperatorAsAction2.getInstance(DefaultPorts.getInstance(), splSpawnAnvilOp.get()));
        actions.add(ExecuteOperatorAsAction2.getInstance(DefaultPorts.getInstance(), splSpawnLigthningOp.get()));
        actions.add(ExecuteOperatorAsAction2.getInstance(DefaultPorts.getInstance(), splDigMobHoleOp.get()));
        actions.add(new ShootGenericEggProjectile(FLAMING_CHICKEN_PROJECTILE_ACTION));
        return actions;
    }

    static List<RightClickedItemAction> initializeCloseRangeActions() {
        ArrayList<RightClickedItemAction> actions = new ArrayList<RightClickedItemAction>();
        actions.add(new GenericEntityMist(TOXIC_MIST_STRATEGY));
        actions.add(ExecuteOperatorAsAction2.getInstance(DefaultPorts.getInstance(), splSpawnCobwebOp.get()));
        actions.add(ExecuteOperatorAsAction2.getInstance(DefaultPorts.getInstance(), splEmitHorizontalForceOp.get()));
        actions.add(ExecuteOperatorAsAction2.getInstance(DefaultPorts.getInstance(), splEmitVerticalForceOp.get()));
        actions.add(ExecuteOperatorAsAction2.getInstance(DefaultPorts.getInstance(), splSpawnIceBlockOp.get()));
        actions.add(ExecuteOperatorAsAction2.getInstance(DefaultPorts.getInstance(), splSpawnLavaBlockOp.get()));
        actions.add(ExecuteOperatorAsAction2.getInstance(DefaultPorts.getInstance(), splSpawnSquidOp.get()));
        actions.add(ExecuteOperatorAsAction2.getInstance(DefaultPorts.getInstance(), splSpawnAnvilOp.get()));
        actions.add(new GenericEntityMist(SPAWN_VACUUM_MIST_PROJECTILE_ACTION));
        actions.add(ExecuteOperatorAsAction2.getInstance(DefaultPorts.getInstance(), splSpawnLigthningOp.get()));
        actions.add(new GenericEntityMist(LIGHTNING_MIST_STRATEGY));
        actions.add(ExecuteOperatorAsAction2.getInstance(DefaultPorts.getInstance(), splDigMobHoleOp.get()));
        return actions;
    }

    void lookAtTarget(LivingEntity target) {
        LookController lookController = this.entity.func_70671_ap();
        lookController.func_75651_a((Entity)target, 10.0f, (float)this.entity.func_70646_bf());
    }

    String selectAction(List<RightClickedItemAction> actions) {
        Random random = BassebombeCraft.getBassebombeCraft().getRandom();
        int numberActions = actions.size();
        int choice = random.nextInt(numberActions);
        RightClickedItemAction action = actions.get(choice);
        action.onRightClick(this.entity.func_130014_f_(), (LivingEntity)this.entity);
        return action.getClass().getSimpleName();
    }
}

