/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.entity.ai.goal;

import bassebombecraft.entity.ai.goal.DefaultObservation;
import bassebombecraft.entity.ai.goal.Observation;
import bassebombecraft.entity.ai.goal.ObservationRepository;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.stream.Stream;
import net.minecraft.entity.LivingEntity;

public class DefaultObservationRepository
implements ObservationRepository {
    static final int LIMIT = 2;
    LivingEntity entity;
    Queue<Observation> observations = new ArrayBlockingQueue<Observation>(2);

    public DefaultObservationRepository(LivingEntity entity) {
        this.entity = entity;
    }

    @Override
    public Observation observe(LivingEntity target) {
        Observation observation = DefaultObservation.getInstance(this.entity, target);
        if (this.observations.size() == 2) {
            this.observations.remove();
        }
        this.observations.add(observation);
        return observation;
    }

    @Override
    public Stream<Observation> get() {
        return this.observations.stream();
    }

    @Override
    public boolean isTooFewObservationsRegistered() {
        return this.observations.size() < 2;
    }

    @Override
    public void clear() {
        this.observations.clear();
    }

    public static ObservationRepository getInstance(LivingEntity entity) {
        return new DefaultObservationRepository(entity);
    }
}

