/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.entity.commander.command;

import bassebombecraft.config.ModConfiguration;
import bassebombecraft.entity.EntityDistanceSorter;
import bassebombecraft.entity.commander.MobCommand;
import bassebombecraft.entity.commander.MobCommanderRepository;
import bassebombecraft.util.function.DiscardCommander;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;

public class AttackNearestPlayerCommand
implements MobCommand {
    public static final String NAME = AttackNearestPlayerCommand.class.getSimpleName();
    static final int FIRST_INDEX = 0;
    final int targetDistance;
    EntityDistanceSorter entityDistanceSorter = new EntityDistanceSorter();
    DiscardCommander discardTeamCommander = new DiscardCommander();

    public AttackNearestPlayerCommand() {
        this.targetDistance = (Integer)ModConfiguration.attackNearestPlayerCommandTargetDistance.get();
    }

    @Override
    public MobCommanderRepository.Commands getType() {
        return MobCommanderRepository.Commands.NEAREST_PLAYER;
    }

    @Override
    public String getTitle() {
        return "Attack nearest player";
    }

    @Override
    public boolean shouldExecute(LivingEntity commander, CreatureEntity entity) {
        this.discardTeamCommander.set(commander);
        AxisAlignedBB aabb = entity.func_174813_aQ().func_72314_b((double)this.targetDistance, (double)this.targetDistance, (double)this.targetDistance);
        List targetList = entity.field_70170_p.func_175647_a(PlayerEntity.class, aabb, (Predicate)((Object)this.discardTeamCommander));
        if (targetList.isEmpty()) {
            return false;
        }
        this.entityDistanceSorter.setEntity((Entity)entity);
        Collections.sort(targetList, this.entityDistanceSorter);
        PlayerEntity target = (PlayerEntity)targetList.get(0);
        if (target == null) {
            return false;
        }
        if (!target.func_70089_S()) {
            return false;
        }
        entity.func_70624_b((LivingEntity)target);
        return true;
    }

    @Override
    public void tick(LivingEntity commander, CreatureEntity entity) {
    }
}

