/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.entity.projectile;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.client.event.rendering.effect.GraphicalEffectRepository;
import bassebombecraft.config.ConfigUtils;
import bassebombecraft.config.ModConfiguration;
import bassebombecraft.config.ProjectileEntityConfig;
import bassebombecraft.event.duration.DurationRepository;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.operator.DefaultPorts;
import bassebombecraft.operator.Operator2;
import bassebombecraft.operator.Operators2;
import bassebombecraft.operator.Ports;
import bassebombecraft.operator.Sequence2;
import bassebombecraft.operator.client.rendering.AddGraphicalEffectAtClient2;
import bassebombecraft.operator.client.rendering.AddParticlesFromPosAtClient2;
import bassebombecraft.operator.entity.Electrocute2;
import bassebombecraft.operator.entity.FindEntities2;
import bassebombecraft.operator.projectile.path.AccelerateProjectilePath;
import bassebombecraft.operator.projectile.path.CircleProjectilePath;
import bassebombecraft.operator.projectile.path.DeaccelerateProjectilePath;
import bassebombecraft.operator.projectile.path.DecreaseGravityProjectilePath;
import bassebombecraft.operator.projectile.path.HomingProjectilePath;
import bassebombecraft.operator.projectile.path.IncreaseGravityProjectilePath;
import bassebombecraft.operator.projectile.path.RandomProjectilePath;
import bassebombecraft.operator.projectile.path.SineProjectilePath;
import bassebombecraft.operator.projectile.path.TeleportProjectilePath;
import bassebombecraft.operator.projectile.path.ZigZagProjectilePath;
import bassebombecraft.util.function.Predicates;
import bassebombecraft.world.WorldUtils;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;

public class GenericCompositeProjectileEntity
extends ProjectileEntity {
    public static final String NAME = GenericCompositeProjectileEntity.class.getSimpleName();
    static final Operator2 RENDERING_TRAIL_OP = new AddGraphicalEffectAtClient2(GraphicalEffectRepository.Effect.PROJECTILE_TRAIL);
    static final Operator2 RANDOM_PATH_OPERATOR = new RandomProjectilePath();
    static final Operator2 ACCELERATE_PATH_OPERATOR = new AccelerateProjectilePath();
    static final Operator2 DEACCELERATE_PATH_OPERATOR = new DeaccelerateProjectilePath();
    static final Operator2 ZIGZAG_PATH_OPERATOR = new ZigZagProjectilePath();
    static final Operator2 SINE_PATH_OPERATOR = new SineProjectilePath();
    static final Operator2 SPIRAL_PATH_OPERATOR = new CircleProjectilePath();
    static final Operator2 INCREASE_GRAVITY_PATH_OPERATOR = new IncreaseGravityProjectilePath();
    static final Operator2 DECREASE_GRAVITY_PATH_OPERATOR = new DecreaseGravityProjectilePath();
    static final Operator2 TELEPORT_PATH_OPERATOR = new TeleportProjectilePath();
    static Optional<Operator2> optHomingPathOperator = Optional.empty();
    static Supplier<Operator2> splHomingPathOp = () -> {
        Function<Ports, Entity> fnGetSource = DefaultPorts.getFnGetEntity1();
        Function<Ports, BlockPos> fnGetSourcePos = p -> ((Entity)Operators2.applyV(fnGetSource, p)).func_233580_cy_();
        Function<Ports, World> fnGetWorld = p -> ((Entity)Operators2.applyV(fnGetSource, p)).func_130014_f_();
        Function<Ports, Predicate<Entity>> fnGetPredicate = p -> Predicates.hasDifferentIds((Entity)Operators2.applyV(fnGetSource, p)).and(Predicates.isntProjectileShooter((Entity)Operators2.applyV(fnGetSource, p)));
        Function<Ports, Integer> fnGetRange = p -> (int)((Integer)ModConfiguration.genericProjectileEntityProjectileHomingAoeRange.get());
        return new Sequence2(new FindEntities2(fnGetSourcePos, fnGetWorld, fnGetPredicate, fnGetRange, DefaultPorts.getBcSetEntities1()), new HomingProjectilePath());
    };
    static final Operator2 HOMING_PATH_OPERATOR = splHomingPathOp.get();
    static final Operator2 ELECTROCUTE_OPERATOR = new Electrocute2();
    int duration;
    Consumer<String> cRemovalCallback = id -> this.func_70106_y();
    Ports projectileModifierPorts = DefaultPorts.getInstance();
    Ports renderingPorts = DefaultPorts.getInstance();
    ProjectileEntityConfig projectileConfig;
    Operator2 renderingOp;

    public GenericCompositeProjectileEntity(EntityType<? extends GenericCompositeProjectileEntity> type, World world, ProjectileEntityConfig config) {
        super(type, world);
        this.projectileConfig = config;
        ParticleRenderingInfo info = ConfigUtils.createInfoFromConfig(this.projectileConfig.particles);
        this.renderingOp = new AddParticlesFromPosAtClient2(info);
        this.duration = (Integer)ModConfiguration.genericProjectileEntityProjectileDuration.get();
        this.initialiseDuration();
    }

    public GenericCompositeProjectileEntity(EntityType<? extends GenericCompositeProjectileEntity> type, LivingEntity shooter, ProjectileEntityConfig config) {
        this(type, shooter.func_130014_f_(), config);
        this.func_70107_b(shooter.func_226277_ct_(), shooter.func_226280_cw_() - 0.1, shooter.func_226281_cx_());
        this.func_212361_a((Entity)shooter);
    }

    public void shootUsingProjectileConfig(Vector3d orientation) {
        Entity shooter = this.func_234616_v_();
        this.func_70107_b(shooter.func_226277_ct_(), shooter.func_226278_cu_() + (double)shooter.func_70047_e(), shooter.func_226281_cx_());
        double force = (Double)this.projectileConfig.force.get();
        double inaccuracy = (Double)this.projectileConfig.inaccuracy.get();
        double velocity = force * orientation.func_72433_c();
        this.func_70186_c(orientation.func_82615_a(), orientation.func_82617_b(), orientation.func_82616_c(), (float)velocity, (float)inaccuracy);
        this.addTrailGraphicalEffect();
    }

    void initialiseDuration() {
        DurationRepository repository = null;
        repository = WorldUtils.isLogicalServer(this.field_70170_p) ? BassebombeCraft.getProxy().getServerDurationRepository() : BassebombeCraft.getProxy().getClientDurationRepository();
        repository.add(this.func_110124_au().toString(), this.duration, this.cRemovalCallback);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.func_213293_j(x, y, z);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        try {
            if (!WorldUtils.isLogicalClient(this.func_130014_f_())) {
                RayTraceResult result = this.calculateCollision();
                if (result.func_216346_c() != RayTraceResult.Type.MISS) {
                    this.handleImpact(result);
                }
                this.processCompositeModifiers();
                this.addRendering();
                this.projectileModifierPorts.incrementCounter();
            }
            this.updateMotionAndPosition();
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    void handleImpact(RayTraceResult result) {
        if (WorldUtils.isLogicalClient(this.func_130014_f_())) {
            return;
        }
        boolean isCancelled = ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)result);
        if (isCancelled) {
            return;
        }
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity target = ((EntityRayTraceResult)result).func_216348_a();
            this.addEntityDamage(target);
        }
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos blockPos = ((BlockRayTraceResult)result).func_216350_a();
        }
        this.func_70106_y();
    }

    void addEntityDamage(Entity target) {
        if (target.func_110124_au().equals(this.func_110124_au())) {
            return;
        }
        double amount = (Double)this.projectileConfig.damage.get();
        DamageSource source = DamageSource.func_76354_b((Entity)this, (Entity)this.func_234616_v_());
        target.func_70097_a(source, (float)amount);
    }

    RayTraceResult calculateCollision() {
        Predicate<Entity> filter = entity -> !entity.func_175149_v() && entity.func_70067_L() && entity != this.func_234616_v_();
        return ProjectileHelper.func_234618_a_((Entity)this, filter);
    }

    void processCompositeModifiers() {
        Set tags = this.func_184216_O();
        if (tags.isEmpty()) {
            return;
        }
        if (tags.contains(RandomProjectilePath.NAME)) {
            this.calculateRandomPath();
        }
        if (tags.contains(AccelerateProjectilePath.NAME)) {
            this.calculateAccelerationPath();
        }
        if (tags.contains(DeaccelerateProjectilePath.NAME)) {
            this.calculateDeaccelerationPath();
        }
        if (tags.contains(ZigZagProjectilePath.NAME)) {
            this.calculateZigZagPath();
        }
        if (tags.contains(SineProjectilePath.NAME)) {
            this.calculateSinePath();
        }
        if (tags.contains(CircleProjectilePath.NAME)) {
            this.calculateSpiralPath();
        }
        if (tags.contains(IncreaseGravityProjectilePath.NAME)) {
            this.calculateIncreaseGravityPath();
        }
        if (tags.contains(DecreaseGravityProjectilePath.NAME)) {
            this.calculateDecreaseGravityPath();
        }
        if (tags.contains(TeleportProjectilePath.NAME)) {
            this.calculateTeleportPath();
        }
        if (tags.contains(HomingProjectilePath.NAME)) {
            this.calculateHomingPath();
        }
        if (tags.contains(Electrocute2.NAME)) {
            this.electrocute();
        }
    }

    void calculateRandomPath() {
        this.projectileModifierPorts.setEntity1((Entity)this);
        Operators2.run(this.projectileModifierPorts, RANDOM_PATH_OPERATOR);
    }

    void calculateAccelerationPath() {
        this.projectileModifierPorts.setEntity1((Entity)this);
        Operators2.run(this.projectileModifierPorts, ACCELERATE_PATH_OPERATOR);
    }

    void calculateDeaccelerationPath() {
        this.projectileModifierPorts.setEntity1((Entity)this);
        Operators2.run(this.projectileModifierPorts, DEACCELERATE_PATH_OPERATOR);
    }

    void calculateZigZagPath() {
        this.projectileModifierPorts.setEntity1((Entity)this);
        Operators2.run(this.projectileModifierPorts, ZIGZAG_PATH_OPERATOR);
    }

    void calculateSinePath() {
        this.projectileModifierPorts.setEntity1((Entity)this);
        Operators2.run(this.projectileModifierPorts, SINE_PATH_OPERATOR);
    }

    void calculateSpiralPath() {
        this.projectileModifierPorts.setEntity1((Entity)this);
        Operators2.run(this.projectileModifierPorts, SPIRAL_PATH_OPERATOR);
    }

    void calculateIncreaseGravityPath() {
        this.projectileModifierPorts.setDouble1((Double)this.projectileConfig.gravity.get());
        this.projectileModifierPorts.setEntity1((Entity)this);
        Operators2.run(this.projectileModifierPorts, INCREASE_GRAVITY_PATH_OPERATOR);
    }

    void calculateDecreaseGravityPath() {
        this.projectileModifierPorts.setDouble1((Double)this.projectileConfig.gravity.get());
        this.projectileModifierPorts.setEntity1((Entity)this);
        Operators2.run(this.projectileModifierPorts, DECREASE_GRAVITY_PATH_OPERATOR);
    }

    void calculateTeleportPath() {
        this.projectileModifierPorts.setEntity1((Entity)this);
        Operators2.run(this.projectileModifierPorts, TELEPORT_PATH_OPERATOR);
    }

    void calculateHomingPath() {
        this.projectileModifierPorts.setEntity1((Entity)this);
        Operators2.run(this.projectileModifierPorts, HOMING_PATH_OPERATOR);
    }

    void electrocute() {
        this.projectileModifierPorts.setEntity1((Entity)this);
        this.projectileModifierPorts.setEntity2(this.func_234616_v_());
        Operators2.run(this.projectileModifierPorts, ELECTROCUTE_OPERATOR);
    }

    void updateMotionAndPosition() {
        Vector3d motionVec = this.func_213322_ci();
        Vector3d positionVec = this.func_213303_ch();
        float motionScale = this.func_70090_H() ? this.getWaterDrag() : this.getAirDrag();
        Vector3d nextMotionVec = motionVec.func_186678_a((double)motionScale);
        Vector3d nextPositionVec = motionVec.func_178787_e(positionVec);
        this.func_213293_j(nextMotionVec.func_82615_a(), nextMotionVec.func_82617_b() - this.getGravity(), nextMotionVec.func_82616_c());
        this.func_70107_b(nextPositionVec.func_82615_a(), nextPositionVec.func_82617_b(), nextPositionVec.func_82616_c());
    }

    protected void func_70088_a() {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    float getWaterDrag() {
        return 0.6f;
    }

    float getAirDrag() {
        return 0.99f;
    }

    double getGravity() {
        return (Double)this.projectileConfig.gravity.get();
    }

    public ProjectileEntityConfig getConfiguration() {
        return this.projectileConfig;
    }

    void addRendering() {
        this.renderingPorts.setBlockPosition1(this.func_233580_cy_());
        Operators2.run(this.renderingPorts, this.renderingOp);
    }

    void addTrailGraphicalEffect() {
        this.renderingPorts.setDouble1(Double.valueOf(this.duration));
        this.renderingPorts.setEntity1((Entity)this);
        this.renderingPorts.setEntity2(this.func_234616_v_());
        Operators2.run(this.renderingPorts, RENDERING_TRAIL_OP);
    }
}

